/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.conpayplan;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.CollectionUtils;
import kd.pccs.concs.business.helper.ConPayPlanHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.enums.ConPayWayEnum;
import kd.pccs.concs.common.util.DateUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;
import org.apache.commons.lang.StringUtils;

public class ConPayPlanPropertyChanged
extends AbstractPropertyChanged {
    public ConPayPlanPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String filedName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (filedName = e.getProperty().getName()) {
            case "oricurrency": {
                this.oriCurrencyChanged(newValue, oldValue);
                break;
            }
            case "oriamt": {
                this.oriAmtChanged(newValue, oldValue);
                break;
            }
            case "amount": {
                break;
            }
            case "schentry_paymenttype": {
                this.schentry_paymentTypeChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_payway": {
                this.schentry_payWayChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_begindate": {
                this.schentry_beginDateChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_enddate": {
                this.schentry_endDateChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_payscale": {
                this.schentry_payScaleChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_payoriamt": {
                this.schentry_payOriAmtChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_preflushoriamt": {
                this.schentry_preFlushOriAmtChanged(rowIndex, newValue, oldValue);
                break;
            }
            case "schentry_paydate": {
                this.schentry_paydateChanged(rowIndex, newValue, oldValue);
                break;
            }
        }
    }

    protected void oriCurrencyChanged(Object newValue, Object oldValue) {
        this.getView().updateView("conpayplanschedule");
    }

    protected void oriAmtChanged(Object newValue, Object oldValue) {
        int i;
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("conpayplanschedule");
        DynamicObject maxEntryObj = null;
        BigDecimal tempPayAmt = (BigDecimal)newValue;
        BigDecimal tempPayScale = BigDecimal.ONE;
        Integer prePayRow = null;
        for (i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            BigDecimal payScale = NumberUtil.divide((Object)entryObj.getBigDecimal("schentry_payscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal payOriAmt = NumberUtil.multiply((Object)newValue, (Object)payScale);
            entryObj.set("schentry_payoriamt", (Object)payOriAmt);
            boolean isPrePayType = false;
            DynamicObject payTypeObj = entryObj.getDynamicObject("schentry_paymenttype");
            if (null != payTypeObj && FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) {
                isPrePayType = true;
                prePayRow = i;
            }
            if (isPrePayType) continue;
            tempPayAmt = NumberUtil.subtract((Object)tempPayAmt, (Object)payOriAmt);
            tempPayScale = NumberUtil.subtract((Object)tempPayScale, (Object)payScale);
            if (null != maxEntryObj && NumberUtil.compareTo((Object)maxEntryObj.get("schentry_payoriamt"), (Object)payOriAmt) >= 0) continue;
            maxEntryObj = entryObj;
        }
        if (NumberUtil.isZero((Object)tempPayScale) && !NumberUtil.isZero((Object)tempPayAmt) && null != maxEntryObj) {
            maxEntryObj.set("schentry_payoriamt", (Object)NumberUtil.add((Object)maxEntryObj.get("schentry_payoriamt"), (Object)tempPayAmt));
        }
        if (null != prePayRow) {
            this.getView().setEnable(Boolean.FALSE, prePayRow.intValue(), new String[]{"schentry_preflushoriamt"});
        } else {
            for (i = 0; i < entryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"schentry_preflushoriamt"});
            }
        }
        this.getView().updateView("conpayplanschedule");
        this.schentry_sumUp();
    }

    protected void amountChanged(Object newValue, Object oldValue) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("conpayplanschedule");
        DynamicObject maxEntryObj = null;
        BigDecimal tempPayAmt = (BigDecimal)newValue;
        BigDecimal tempPayScale = BigDecimal.ONE;
        for (DynamicObject entryObj : entryEntity) {
            BigDecimal payScale = NumberUtil.divide((Object)entryObj.getBigDecimal("schentry_payscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal payAmt = NumberUtil.multiply((Object)newValue, (Object)payScale);
            entryObj.set("schentry_payamt", (Object)payAmt);
            boolean isPrePayType = false;
            DynamicObject payTypeObj = entryObj.getDynamicObject("schentry_paymenttype");
            if (null != payTypeObj && FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) {
                isPrePayType = true;
            }
            if (isPrePayType) continue;
            tempPayAmt = NumberUtil.subtract((Object)tempPayAmt, (Object)payAmt);
            tempPayScale = NumberUtil.subtract((Object)tempPayScale, (Object)payScale);
            if (null != maxEntryObj && NumberUtil.compareTo((Object)maxEntryObj.get("schentry_payoriamt"), (Object)payAmt) >= 0) continue;
            maxEntryObj = entryObj;
        }
        if (NumberUtil.isZero((Object)tempPayScale) && !NumberUtil.isZero((Object)tempPayAmt) && null != maxEntryObj) {
            maxEntryObj.set("schentry_payamt", (Object)NumberUtil.add((Object)maxEntryObj.get("schentry_payamt"), (Object)tempPayAmt));
        }
        this.getView().updateView("conpayplanschedule");
        this.schentry_sumUp();
    }

    protected void schentry_paymentTypeChanged(int rowIndex, Object newValue, Object oldValue) {
        block3: {
            DynamicObjectCollection conPayPlanSchedule;
            block2: {
                DynamicObject payTypeObj = (DynamicObject)newValue;
                conPayPlanSchedule = this.getModel().getEntryEntity("conpayplanschedule");
                if (null == payTypeObj || !FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) break block2;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"schentry_preflushoriamt"});
                this.getModel().setValue("schentry_preflushoriamt", null, rowIndex);
                this.getModel().setValue("schentry_preflushamt", null, rowIndex);
                for (int i = 0; i < conPayPlanSchedule.size(); ++i) {
                    if (i == rowIndex) continue;
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"schentry_preflushoriamt"});
                }
                break block3;
            }
            if (ConPayPlanHelper.checkHasPrePayment((String)this.getAppId(), (DynamicObjectCollection)conPayPlanSchedule)) break block3;
            for (int i = 0; i < conPayPlanSchedule.size(); ++i) {
                this.getModel().setValue("schentry_preflushoriamt", null, i);
                this.getModel().setValue("schentry_preflushamt", null, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"schentry_preflushoriamt"});
            }
        }
    }

    protected void schentry_payWayChanged(int rowIndex, Object newValue, Object oldValue) {
        if (ConPayWayEnum.BYMONTH.getValue().equals(newValue)) {
            this.getModel().setValue("schentry_paydate", null, rowIndex);
        } else {
            this.getModel().setValue("schentry_enddate", null, rowIndex);
            this.getModel().setValue("schentry_begindate", null, rowIndex);
        }
    }

    protected void schentry_beginDateChanged(int rowIndex, Object newValue, Object oldValue) {
        if (this.checkIsLessPreTypeDate(rowIndex)) {
            this.getModel().setValue("schentry_begindate", oldValue, rowIndex);
            return;
        }
        Date beginDate = (Date)newValue;
        DynamicObject schEntryObj = this.getModel().getEntryRowEntity("conpayplanschedule", rowIndex);
        Date endDate = schEntryObj.getDate("schentry_enddate");
        if (null != beginDate && null != endDate && DateUtil.getDiffDays((Date)beginDate, (Date)endDate) < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f!", (String)"ConPayPlanPropertyChanged_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("schentry_begindate", null, rowIndex);
        }
    }

    protected void schentry_endDateChanged(int rowIndex, Object newValue, Object oldValue) {
        if (this.checkIsLessPreTypeDate(rowIndex)) {
            this.getModel().setValue("schentry_enddate", oldValue, rowIndex);
            return;
        }
        Date endDate = (Date)newValue;
        DynamicObject schEntryObj = this.getModel().getEntryRowEntity("conpayplanschedule", rowIndex);
        Date beginDate = schEntryObj.getDate("schentry_begindate");
        if (null != beginDate && null != endDate && DateUtil.getDiffDays((Date)beginDate, (Date)endDate) < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f!", (String)"ConPayPlanPropertyChanged_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("schentry_enddate", null, rowIndex);
        }
    }

    public void schentry_payScaleChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal payScale = NumberUtil.divide((Object)newValue, (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal payOriAmt = NumberUtil.multiply((Object)dataEntity.getBigDecimal("oriamt"), (Object)payScale);
        this.getModel().setValue("schentry_payoriamt", (Object)payOriAmt, rowIndex);
        this.schentry_sumUp();
    }

    protected void schentry_payOriAmtChanged(int rowIndex, Object newValue, Object oldValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal payScale = NumberUtil.divide((Object)newValue, (Object)dataEntity.getBigDecimal("oriamt"), (int)4);
        this.getModel().setValue("schentry_payscale", (Object)NumberUtil.multiply((Object)payScale, (Object)NumberUtil.ONE_HUNDRED), rowIndex);
        this.setPreFlushAmt(rowIndex, newValue);
        this.schentry_sumUp();
    }

    protected void schentry_preFlushOriAmtChanged(int rowIndex, Object newValue, Object oldValue) {
        if (NumberUtil.compareTo((Object)this.getModel().getValue("schentry_payoriamt", rowIndex), (Object)newValue) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8ba1\u5212\u652f\u4ed8\u91d1\u989d!", (String)"ConPayPlanPropertyChanged_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("schentry_preflushoriamt", null, rowIndex);
        }
        this.schentry_sumUp();
    }

    protected void schentry_sumUp() {
        DynamicObjectCollection schEntryColl = this.getModel().getEntryEntity("conpayplanschedule");
        BigDecimal schentry_payScale = BigDecimal.ZERO;
        BigDecimal schentry_payoriamt = BigDecimal.ZERO;
        BigDecimal schentry_preflushoriamt = BigDecimal.ZERO;
        DynamicObject tempEntryObj = null;
        int rowIndex = -1;
        int isize = schEntryColl.size();
        for (int i = 0; i < isize; ++i) {
            DynamicObject entryObj = (DynamicObject)schEntryColl.get(i);
            DynamicObject payTypeObj = entryObj.getDynamicObject("schentry_paymenttype");
            if (null != payTypeObj && FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) continue;
            BigDecimal payOriAmt = entryObj.getBigDecimal("schentry_payoriamt");
            schentry_payScale = NumberUtil.add((Object)schentry_payScale, (Object)entryObj.getBigDecimal("schentry_payscale"));
            schentry_payoriamt = NumberUtil.add((Object)schentry_payoriamt, (Object)payOriAmt);
            schentry_preflushoriamt = NumberUtil.add((Object)schentry_preflushoriamt, (Object)entryObj.getBigDecimal("schentry_preflushoriamt"));
            if (null != tempEntryObj && NumberUtil.compareTo((Object)tempEntryObj.getBigDecimal("schentry_payoriamt"), (Object)payOriAmt) >= 0) continue;
            tempEntryObj = entryObj;
            rowIndex = i;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal oriAmt = dataEntity.getBigDecimal("oriamt");
        if (null != tempEntryObj && NumberUtil.compareTo((Object)NumberUtil.ONE_HUNDRED, (Object)schentry_payScale) == 0 && NumberUtil.compareTo((Object)oriAmt, (Object)schentry_payoriamt) != 0) {
            tempEntryObj.set("schentry_payoriamt", (Object)NumberUtil.add((Object)tempEntryObj.getBigDecimal("schentry_payoriamt"), (Object)NumberUtil.subtract((Object)oriAmt, (Object)schentry_payoriamt)));
            this.getView().updateView("schentry_payoriamt", rowIndex);
            schentry_payoriamt = oriAmt;
        } else if (null != tempEntryObj && NumberUtil.compareTo((Object)oriAmt, (Object)schentry_payoriamt) == 0 && NumberUtil.compareTo((Object)NumberUtil.ONE_HUNDRED, (Object)schentry_payScale) != 0) {
            tempEntryObj.set("schentry_payscale", (Object)NumberUtil.add((Object)tempEntryObj.getBigDecimal("schentry_payscale"), (Object)NumberUtil.subtract((Object)NumberUtil.ONE_HUNDRED, (Object)schentry_payScale)));
            this.getView().updateView("schentry_payscale", rowIndex);
            schentry_payScale = NumberUtil.ONE_HUNDRED;
        }
        String sign = "";
        DynamicObject oriCurrencyObj = (DynamicObject)this.getModel().getValue("oricurrency");
        if (null != oriCurrencyObj && StringUtils.isNotEmpty((String)oriCurrencyObj.getString("sign"))) {
            sign = oriCurrencyObj.getString("sign");
        }
        HashMap<String, String> sumData = new HashMap<String, String>();
        sumData.put("schentry_payscale", NumberUtil.formatTo2ddString((Object)schentry_payScale));
        sumData.put("schentry_payoriamt", sign + NumberUtil.formatTo2ddString((Object)schentry_payoriamt));
        sumData.put("schentry_preflushoriamt", sign + NumberUtil.formatTo2ddString((Object)schentry_preflushoriamt));
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("conpayplanschedule");
        entryGrid.setFloatButtomData(sumData);
    }

    protected void setPreFlushAmt(int rowIndex, Object payOriAmt) {
        DynamicObject paymentType = (DynamicObject)this.getModel().getValue("schentry_paymenttype", rowIndex);
        if (paymentType != null && FiCasConst.PRE_PAYMENT.equals(paymentType.getPkValue())) {
            return;
        }
        Object preflushoriamt = this.getModel().getValue("schentry_preflushoriamt", rowIndex);
        if (NumberUtil.isZero((Object)preflushoriamt)) {
            DynamicObjectCollection scheduleEntry = this.getModel().getEntryEntity("conpayplanschedule");
            int isize = scheduleEntry.size();
            for (int i = 0; i < isize; ++i) {
                if (i == rowIndex) continue;
                DynamicObject scheduleEntryRow = (DynamicObject)scheduleEntry.get(i);
                paymentType = scheduleEntryRow.getDynamicObject("schentry_paymenttype");
                preflushoriamt = paymentType != null && FiCasConst.PRE_PAYMENT.equals(paymentType.getPkValue()) ? NumberUtil.add((Object)preflushoriamt, (Object)scheduleEntryRow.getBigDecimal("schentry_payoriamt")) : NumberUtil.subtract((Object)preflushoriamt, (Object)scheduleEntryRow.getBigDecimal("schentry_preflushoriamt"));
            }
            if (NumberUtil.isPositiveNum((Object)preflushoriamt)) {
                if (NumberUtil.compareTo((Object)preflushoriamt, (Object)payOriAmt) > 0) {
                    this.getModel().setValue("schentry_preflushoriamt", payOriAmt, rowIndex);
                } else {
                    this.getModel().setValue("schentry_preflushoriamt", preflushoriamt, rowIndex);
                }
            }
        } else if (NumberUtil.compareTo((Object)preflushoriamt, (Object)payOriAmt) > 0) {
            this.getModel().setValue("schentry_preflushoriamt", payOriAmt, rowIndex);
        }
    }

    protected void schentry_paydateChanged(int rowIndex, Object newValue, Object oldValue) {
        if (null == newValue) {
            return;
        }
        if (this.checkIsLessPreTypeDate(rowIndex)) {
            this.getModel().setValue("schentry_paydate", oldValue, rowIndex);
            return;
        }
    }

    protected boolean checkIsLessPreTypeDate(int rowIndex) {
        DynamicObject schEntryObj = this.getModel().getEntryRowEntity("conpayplanschedule", rowIndex);
        DynamicObject paymentType = schEntryObj.getDynamicObject("schentry_paymenttype");
        if (null == paymentType) {
            return false;
        }
        Date pre_payDate = null;
        Date pre_endDate = null;
        DynamicObject model = this.getModel().getDataEntity(true);
        DynamicObjectCollection schEntry = model.getDynamicObjectCollection("conpayplanschedule");
        Optional<DynamicObject> pre_payOpt = schEntry.stream().filter(entry -> Optional.ofNullable(entry.getDynamicObject("schentry_paymenttype")).isPresent()).filter(entry -> FiCasConst.PRE_PAYMENT.equals(entry.getDynamicObject("schentry_paymenttype").getLong("id"))).findFirst();
        pre_payDate = pre_payOpt.map(entry -> entry.getDate("schentry_paydate")).orElse(null);
        pre_endDate = pre_payOpt.map(entry -> entry.getDate("schentry_enddate")).orElse(null);
        if (null == pre_payDate && null == pre_endDate) {
            return false;
        }
        Date preDate = null == pre_payDate ? pre_endDate : pre_payDate;
        Set hasBeginDateEntrys = schEntry.stream().filter(entry -> Optional.ofNullable(entry.getDynamicObject("schentry_paymenttype")).isPresent()).filter(entry -> !FiCasConst.PRE_PAYMENT.equals(entry.getDynamicObject("schentry_paymenttype").getLong("id"))).filter(entry -> Optional.ofNullable(entry.getDate("schentry_begindate")).isPresent()).collect(Collectors.toSet());
        Date minBeginDate = null;
        if (!CollectionUtils.isEmpty(hasBeginDateEntrys)) {
            minBeginDate = hasBeginDateEntrys.stream().map(entry -> entry.getDate("schentry_begindate")).min((a, b) -> a.compareTo((Date)b)).get();
        }
        Set hasPayDateEntrys = schEntry.stream().filter(entry -> Optional.ofNullable(entry.getDynamicObject("schentry_paymenttype")).isPresent()).filter(entry -> !FiCasConst.PRE_PAYMENT.equals(entry.getDynamicObject("schentry_paymenttype").getLong("id"))).filter(entry -> Optional.ofNullable(entry.getDate("schentry_paydate")).isPresent()).collect(Collectors.toSet());
        Date minPayDate = null;
        if (!CollectionUtils.isEmpty(hasPayDateEntrys)) {
            minPayDate = hasPayDateEntrys.stream().map(entry -> entry.getDate("schentry_paydate")).min((a, b) -> a.compareTo((Date)b)).get();
        }
        boolean isLessPreDate = false;
        if (null != minBeginDate && preDate.compareTo(minBeginDate) > 0) {
            isLessPreDate = true;
        }
        if (null != minPayDate && preDate.compareTo(minPayDate) > 0) {
            isLessPreDate = true;
        }
        if (!isLessPreDate) {
            return false;
        }
        if (FiCasConst.PRE_PAYMENT.toString().equals(paymentType.getPkValue().toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u8ba1\u5212\u652f\u4ed8\u65e5\u671f\u6216\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5176\u4ed6\u6b3e\u9879\u8ba1\u5212\u652f\u4ed8\u65e5\u671f\u6216\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574", (String)"ConPayPlanPropertyChanged_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u9879\u8ba1\u5212\u652f\u4ed8\u65e5\u671f/\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u9884\u4ed8\u6b3e\u8ba1\u5212\u652f\u4ed8\u65e5\u671f\u6216\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574", (String)"ConPayPlanPropertyChanged_4", (String)"pccs-concs-formplugin", (Object[])new Object[0]), paymentType.getString("name")));
        }
        return true;
    }
}

