/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.conrevisebill;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.ConPayPlanHelper;
import kd.pccs.concs.business.helper.ConReviseBillHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.conrevisebill.ConReviseBillPropertyChanged;
import kd.pccs.concs.formplugin.contractbill.ContractBillFormPlugin;
import org.apache.commons.lang.StringUtils;

public class ConReviseBillFormPlugin
extends ContractBillFormPlugin {
    private Map<String, Object> ctrlMetaParamMap = new HashMap<String, Object>();

    public Map<String, Object> getCtrlMetaParamMap() {
        return this.ctrlMetaParamMap;
    }

    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new ConReviseBillPropertyChanged(this, this.getModel());
    }

    @Override
    protected void afterCreateNewData() {
        Long conId = (Long)this.getView().getFormShowParameter().getCustomParam("contractbill");
        DynamicObject conreviseObj = this.getModel().getDataEntity(true);
        DynamicObject[] hisReviseObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill"), (String)"version", (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)conId)}, (String)"version desc", (int)1);
        if (null != hisReviseObjs && hisReviseObjs.length > 0) {
            conreviseObj.set("version", (Object)(hisReviseObjs[0].getInt("version") + 1));
        } else {
            conreviseObj.set("version", (Object)2);
        }
        ConReviseBillHelper.copyContractData((String)this.getAppId(), (DynamicObject)conreviseObj, (Long)conId);
        DynamicObjectCollection taxEntryColl = conreviseObj.getDynamicObjectCollection("taxentry");
        if (null != taxEntryColl && taxEntryColl.size() > 0) {
            DynamicObjectType dynamicObjectType = ((DynamicObject)taxEntryColl.get(0)).getDynamicObjectType();
            long[] entryIds = ORM.create().genLongIds((IDataEntityType)dynamicObjectType, taxEntryColl.size());
            String pkName = dynamicObjectType.getPrimaryKey().getName();
            int size = taxEntryColl.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject taxEntryObj = (DynamicObject)taxEntryColl.get(i);
                taxEntryObj.set(pkName, (Object)entryIds[i]);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        boolean flag = false;
        DynamicObject conreviseObj = this.getModel().getDataEntity();
        Long pk = (Long)conreviseObj.getPkValue();
        if (0L != pk) {
            flag = ConPayPlanHelper.existsConPayPlan((String)this.getAppId(), (Long)pk, (boolean)true);
        } else {
            DynamicObject conObj = conreviseObj.getDynamicObject("contractbill");
            flag = ConPayPlanHelper.existsConPayPlan((String)this.getAppId(), (Long)((Long)conObj.getPkValue()), (boolean)false);
        }
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabconpayplan"});
            this.tabSelectListener.createSonViewFormParentView();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabconpayplan"});
        }
        this.setColor4ChgedProps();
    }

    @Override
    protected void initContractInfo() {
    }

    protected void setColor4ChgedProps() {
        this.ctrlMetaParamMap.put("fc", "#ff0000");
        DynamicObjectCollection reviseContentColl = this.getModel().getEntryEntity("conrevisecontent");
        for (DynamicObject entryObj : reviseContentColl) {
            String ctrlName = entryObj.getString("content_fieldname");
            if (StringUtils.isEmpty((String)ctrlName) || null == this.getView().getControl(ctrlName)) continue;
            this.getView().updateControlMetadata(ctrlName, this.ctrlMetaParamMap);
        }
    }

    @Override
    protected void invokeConPayPlanOperation(String operateKey) {
        OperationResult operationResult;
        String sonPageId = this.getPageCache().get("concs_conpayplantab_pageid");
        if (sonPageId == null) {
            return;
        }
        IFormView subView = this.getView().getView(sonPageId);
        if (null == subView) {
            return;
        }
        DynamicObject conReviseObj = this.getModel().getDataEntity();
        DynamicObject conPayPlanObj = subView.getModel().getDataEntity();
        conPayPlanObj.set("contractbill", null);
        conPayPlanObj.set("conrevisebill", conReviseObj.getPkValue());
        if (StringUtils.isEmpty((String)conPayPlanObj.getString("billno"))) {
            conPayPlanObj.set("billno", (Object)conReviseObj.getString("billno"));
        }
        if (null == conPayPlanObj.get("org")) {
            conPayPlanObj.set("org", conReviseObj.get("org"));
        }
        if (!(operationResult = this.getView().getView(sonPageId).invokeOperation(operateKey)).isSuccess()) {
            // empty if block
        }
        this.tabSelectListener.createSonViewFormParentView();
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("taxentry".equals(e.getEntryProp().getName())) {
            DynamicObject taxEntryObj = e.getRowDataEntities()[0].getDataEntity();
            Long entryId = ORM.create().genLongId(taxEntryObj.getDataEntityType());
            ISimpleProperty pkProp = taxEntryObj.getDynamicObjectType().getPrimaryKey();
            taxEntryObj.set(pkProp.getName(), (Object)entryId);
            DynamicObject billObj = this.getModel().getDataEntity(true);
            DynamicObjectCollection reviseEntryColl = billObj.getDynamicObjectCollection("conrevisecontent");
            DynamicObject reviseEntryObj = null;
            reviseEntryObj = reviseEntryColl.size() == 1 && StringUtils.isBlank((String)((DynamicObject)reviseEntryColl.get(0)).getString("content_fieldname")) ? (DynamicObject)reviseEntryColl.get(0) : reviseEntryColl.addNew();
            reviseEntryObj.set("content_fieldalias", (Object)new LocaleString(ResManager.loadKDString((String)"\u7a0e\u76ee\u660e\u7ec6", (String)"ConReviseBillFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0])));
            reviseEntryObj.set("content_fieldname", (Object)entryId);
            reviseEntryObj.set("content_description", (Object)ResManager.loadKDString((String)"\u6dfb\u52a0\u4e00\u884c", (String)"ConReviseBillFormPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getView().updateView("conrevisecontent");
        }
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if ("taxentry".equals(e.getEntryProp().getName())) {
            DynamicObject billObj = this.getModel().getDataEntity(true);
            DynamicObjectCollection reviseEntryColl = billObj.getDynamicObjectCollection("conrevisecontent");
            int[] indexes = e.getRowIndexs();
            DynamicObject taxEntryObj = this.getModel().getEntryRowEntity("taxentry", indexes[0]);
            String entryId = taxEntryObj.getPkValue().toString();
            for (DynamicObject entryObj : reviseEntryColl) {
                if (!entryId.equals(entryObj.getString("content_fieldname"))) continue;
                reviseEntryColl.remove((Object)entryObj);
                this.getView().updateView("conrevisecontent");
                return;
            }
            DynamicObject reviseEntryObj = null;
            reviseEntryObj = reviseEntryColl.size() == 1 && StringUtils.isBlank((String)((DynamicObject)reviseEntryColl.get(0)).getString("content_fieldname")) ? (DynamicObject)reviseEntryColl.get(0) : reviseEntryColl.addNew();
            reviseEntryObj.set("content_fieldalias", (Object)new LocaleString(ResManager.loadKDString((String)"\u7a0e\u76ee\u660e\u7ec6", (String)"ConReviseBillFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0])));
            reviseEntryObj.set("content_fieldname", (Object)entryId);
            reviseEntryObj.set("content_description", (Object)ResManager.loadKDString((String)"\u5220\u9664\u4e00\u884c", (String)"ConReviseBillFormPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getView().updateView("conrevisecontent");
        }
    }
}

