/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.conrevisebill;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.pccs.concs.common.util.DynamicObjectUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.conrevisebill.ConReviseBillFormPlugin;
import kd.pccs.concs.formplugin.contractbill.ContractBillPropertyChanged;
import org.apache.commons.lang.StringUtils;

public class ConReviseBillPropertyChanged
extends ContractBillPropertyChanged {
    public ConReviseBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.genReviseRecordData(e);
        super.propertyChanged(e);
    }

    protected void genReviseRecordData(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String ctrlName = property.getName();
        if ("contractbill".equals(ctrlName) || "version".equals(ctrlName) || "reviseby".equals(ctrlName) || "revisedate".equals(ctrlName) || "revisereason".equals(ctrlName) || ctrlName.startsWith("content_")) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        Control control = this.getView().getControl(ctrlName);
        if (null == control) {
            return;
        }
        Map<String, Object> ctrlMetaParamMap = ((ConReviseBillFormPlugin)this.plugin).getCtrlMetaParamMap();
        DynamicObject reviseEntryObj = this.getReviseEntry(property, changeData);
        if (null == reviseEntryObj) {
            ctrlMetaParamMap.put("fc", "#000000");
        } else {
            if (null != newValue) {
                reviseEntryObj.set("content_newvalue", (Object)new LocaleString(DynamicObjectUtil.valueToString((IDataEntityProperty)property, (Object)newValue)));
            }
            ctrlMetaParamMap.put("fc", "#ff0000");
        }
        this.getView().updateControlMetadata(ctrlName, ctrlMetaParamMap);
        this.getView().updateView("conrevisecontent");
    }

    protected DynamicObject getReviseEntry(IDataEntityProperty property, ChangeData changeData) {
        String ctrlName = property.getName();
        int rowIndex = changeData.getRowIndex();
        String fieldKey = ctrlName;
        boolean isEntryProp = ctrlName.startsWith("taxentry_");
        String taxEntryObjId = null;
        if (isEntryProp) {
            DynamicObject taxEntryObj = this.getModel().getEntryRowEntity("taxentry", rowIndex);
            taxEntryObjId = taxEntryObj.getPkValue().toString();
            fieldKey = ctrlName + "_" + taxEntryObjId;
        }
        DynamicObjectCollection reviseEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("conrevisecontent");
        DynamicObject reviseEntryObj = null;
        int size = reviseEntryColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject obj = (DynamicObject)reviseEntryColl.get(i);
            String fieldName = obj.getString("content_fieldname");
            if (StringUtils.isBlank((String)fieldName)) {
                reviseEntryObj = obj;
                break;
            }
            if (isEntryProp && fieldName.equals(taxEntryObjId)) {
                return "taxentry_content".equals(ctrlName) ? obj : null;
            }
            if (!fieldKey.equals(fieldName)) continue;
            if (this.isEquals(DynamicObjectUtil.valueToString((IDataEntityProperty)property, (Object)changeData.getNewValue()), obj.getString("content_oldvalue"))) {
                reviseEntryColl.remove(i);
                return null;
            }
            reviseEntryObj = obj;
            break;
        }
        if (null == reviseEntryObj) {
            reviseEntryObj = reviseEntryColl.addNew();
        }
        if (StringUtils.isBlank((String)reviseEntryObj.getString("content_fieldname"))) {
            String fieldAlias = property.getDisplayName().getLocaleValue();
            if (isEntryProp) {
                fieldAlias = ResManager.loadKDString((String)"\u7a0e\u76ee\u660e\u7ec6_", (String)"ConReviseBillPropertyChanged_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]) + fieldAlias;
                reviseEntryObj.set("content_description", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"ConReviseBillPropertyChanged_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]), rowIndex + 1));
            }
            reviseEntryObj.set("content_fieldalias", (Object)new LocaleString(fieldAlias));
            reviseEntryObj.set("content_oldvalue", (Object)new LocaleString(DynamicObjectUtil.valueToString((IDataEntityProperty)property, (Object)changeData.getOldValue())));
            reviseEntryObj.set("content_fieldname", (Object)fieldKey);
        }
        return reviseEntryObj;
    }

    private boolean isEquals(Object newValue, String oldValue) {
        if (null == newValue) {
            return StringUtils.isEmpty((String)oldValue);
        }
        if (newValue instanceof BigDecimal) {
            return NumberUtil.compareTo((Object)newValue, (Object)oldValue) == 0;
        }
        return newValue.toString().equals(oldValue);
    }
}

