/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.consettlebill;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplFormPlugin;
import kd.pccs.concs.formplugin.consettlebill.ConSettleBillPropertyChanged;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.PayItemF7SelectListener;

public class ConSettleBillFormPlugin
extends BillOrgTaxTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new ConSettleBillPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerContractBillF7();
        this.registerPayItemF7();
    }

    protected void registerPayItemF7() {
        new PayItemF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("sumentry_conpayitem")).setIncludeSysPreSet(true).setCustomQFilter((evt, qFilters) -> {
            DynamicObject[] bills;
            DynamicObjectCollection summaryEntrys = this.getModel().getEntryEntity("settlesumentry");
            HashSet<Object> idSet = new HashSet<Object>();
            for (DynamicObject summaryEntryRow : summaryEntrys) {
                DynamicObject payItem = summaryEntryRow.getDynamicObject("sumentry_conpayitem");
                if (null == payItem) continue;
                idSet.add(payItem.getPkValue());
            }
            HashSet<Object> payItemIdSet = new HashSet<Object>();
            DynamicObject contractBill = this.getModel().getDataEntity().getDynamicObject("contractbill");
            if (null != contractBill && (bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (String)"payitem", (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractBill.getPkValue()), new QFilter("payitem", "not in", idSet)})).length > 0) {
                for (DynamicObject bill : bills) {
                    DynamicObject conPayItem = bill.getDynamicObject("payitem");
                    if (null == conPayItem) continue;
                    payItemIdSet.add(conPayItem.getPkValue());
                }
            }
            qFilters.add(new QFilter("id", "in", payItemIdSet));
        });
    }

    protected void registerContractBillF7() {
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill")).setCustomQFilter((evt, qFilters) -> {
            DynamicObject contract;
            DynamicObject settleBill;
            DynamicObject billObj = this.getModel().getDataEntity();
            Set hasSettledConIds = ConSettleBillHelper.getHasSettledConIds((String)this.getAppId(), (long)OrgUtil.getCurrentOrgId((DynamicObject)billObj));
            if (hasSettledConIds.size() == 0) {
                return;
            }
            boolean isExists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billObj.getPkValue().toString())), new QFilter("contractbill", "!=", (Object)0L)});
            if (isExists && null != (settleBill = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(billObj.getPkValue().toString()), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (String)"contractbill")) && null != (contract = settleBill.getDynamicObject("contractbill")) && hasSettledConIds.contains(contract.getPkValue())) {
                hasSettledConIds.remove(contract.getPkValue());
            }
            qFilters.add(new QFilter("id", "not in", (Object)hasSettledConIds));
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int status = this.getView().getFormShowParameter().getStatus().getValue();
        if (status == OperationStatus.EDIT.getValue()) {
            DataStandardHelper.updateDataStandEntry((String)this.getAppId(), (IDataModel)this.getModel(), (IFormView)this.getView(), (String)DataStandardBillEnum.CONSETTLE.getValue());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setPresetSettleDetail();
    }

    protected void setPresetSettleDetail() {
        IDataModel model = this.getModel();
        DynamicObject[] conPayItems = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayitem"), (String)String.join((CharSequence)",", "id", "name", "number"), (QFilter[])new QFilter[]{new QFilter("syspreset", "=", (Object)NumberUtil.ONE)}, (String)"number");
        int conPayItemSize = conPayItems.length;
        if (conPayItemSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow("settlesumentry", conPayItemSize);
        int rowIndex = 0;
        for (int i = 0; i < conPayItems.length; ++i) {
            DynamicObject payItem = conPayItems[i];
            rowIndex = i < 3 ? i + 2 : (i == 4 ? 0 : 1);
            model.setValue("sumentry_conpayitem", (Object)payItem, rowIndex);
            model.setValue("sumentry_oriamt", (Object)NumberUtil.ZERO, rowIndex);
            model.setValue("sumentry_amount", (Object)NumberUtil.ZERO, rowIndex);
            model.setValue("sumentry_notaxamt", (Object)NumberUtil.ZERO, rowIndex);
            model.setValue("sumentry_amtscale", (Object)NumberUtil.ZERO, rowIndex);
        }
        this.getView().updateView("settlesumentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int selectedRowIndex;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deletesettlesumentry".equals(operateKey) && (selectedRowIndex = this.getModel().getEntryCurrentRowIndex("settlesumentry")) < 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u9884\u8bbe\u884c\uff01", (String)"ConSettleBillFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("partyb", "partybname", entityName, this.getModel().getDataEntity(true), null));
    }
}

