/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.consettlebill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.enums.DeductPropertyEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;
import org.apache.commons.lang.StringUtils;

public class ConSettleBillPropertyChanged
extends BillOrgTaxTplPropertyChanged {
    protected DynamicObjectCollection supplyConBills = new DynamicObjectCollection();
    protected DynamicObjectCollection chgCfmBills = new DynamicObjectCollection();
    protected DynamicObjectCollection conChgBills = new DynamicObjectCollection();
    protected static final String SUMENTRY_CONTRACT = "001";
    protected static final String SUMENTRY_SUPPLEYCON = "002";
    protected static final String SUMENTRY_CHANGE = "003";
    protected static final String SUMENTRY_SETTLEADJUST = "004";
    protected static final String SUMENTRY_CONSETTLE = "005";
    protected static final String TAX_SELECTORS = String.join((CharSequence)",", "oriamt", "amount", "notaxamt", "taxentry_content", "taxentry_amount", "taxentry_oriamt", "taxentry_tax", "taxentry_taxrate", "taxentry_notaxamt");

    public ConSettleBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "contractbill": {
                this.contractOnChange(newVal, oldVal);
                break;
            }
            case "project": {
                this.projectOnChange(newVal);
                break;
            }
            case "bailoriamt": {
                this.bailOriAmtOnChange(newVal);
                break;
            }
            case "bailamt": {
                this.bailAmtOnChange(newVal);
                break;
            }
            case "bailscale": {
                this.bailScaleOnChange(newVal);
                break;
            }
            case "sumentry_conpayitem": {
                this.conPayItemOnChange(newVal);
                break;
            }
        }
    }

    protected void contractOnChange(Object newVal, Object oldVal) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.getModel().deleteEntryData("taxentry");
        this.getModel().deleteEntryData("settledataentry");
        this.resetSummaryEntry();
        if (null == newVal) {
            return;
        }
        DynamicObject contractBill = (DynamicObject)newVal;
        Long contractId = contractBill.getLong("id");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", TAX_SELECTORS, "project", "contracttype", "partyb", "marginscale", "latestoriprice", "latestprice", "exchangerate", "bd_taxrate", "oricurrency", "currency", "org"));
        boolean isMultiTaxRate = contractBill.getBoolean("multitaxrateflag");
        boolean ismulticurrency = contractBill.getBoolean("foreigncurrencyflag");
        this.getRelatedBillsByContract(contractId);
        dataEntity.set("org", (Object)contract.getDynamicObject("org"));
        this.getModel().setValue("multitaxrateflag", (Object)isMultiTaxRate);
        this.getModel().setValue("foreigncurrencyflag", (Object)contractBill.getBoolean("foreigncurrencyflag"));
        dataEntity.set("oricurrency", contract.get("oricurrency"));
        dataEntity.set("currency", contract.get("currency"));
        dataEntity.set("contracttype", (Object)contractBill.getDynamicObject("contracttype"));
        dataEntity.set("partyb", (Object)contractBill.getDynamicObject("partyb"));
        dataEntity.set("project", contract.get("project"));
        dataEntity.set("exchangerate", contract.get("exchangerate"));
        dataEntity.set("bailscale", contract.get("marginscale"));
        this.setPayControlInfo(contract);
        if (!ismulticurrency) {
            this.getModel().setValue("amount", contract.get("latestprice"));
        } else {
            this.getModel().setValue("oriamt", contract.get("latestoriprice"));
        }
        if (isMultiTaxRate) {
            this.loadMultiTaxRateEntry(contractId, ismulticurrency, contract);
        }
        this.loadSettleSummaryEntry(contract);
        this.loadDataStandardEntry(dataEntity, contractBill);
        this.getView().updateView();
    }

    protected void getRelatedBillsByContract(Long contractId) {
        DynamicObject[] chgConBillColl;
        DynamicObject[] supplyConBillColl = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"supplyconbill"), (String)String.join((CharSequence)",", TAX_SELECTORS, "chgentry_changebill"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)contractId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue())});
        HashSet<Object> conCfmIds = new HashSet<Object>();
        if (supplyConBillColl.length > 0) {
            for (DynamicObject supplyCon : supplyConBillColl) {
                this.supplyConBills.add((Object)supplyCon);
                DynamicObjectCollection conCfmEntrys = supplyCon.getDynamicObjectCollection("supplyconchgentry");
                if (conCfmEntrys.size() <= 0) continue;
                for (DynamicObject conCfmEntry : conCfmEntrys) {
                    DynamicObject conCfmBill = conCfmEntry.getDynamicObject("chgentry_changebill");
                    conCfmIds.add(conCfmBill.getPkValue());
                }
            }
        }
        DynamicObject[] chgCfmBillColl = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"), (String)String.join((CharSequence)",", TAX_SELECTORS, "chgaudit"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)contractId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue())});
        HashSet<Object> conChgf7Ids = new HashSet<Object>();
        if (chgCfmBillColl.length > 0) {
            for (DynamicObject chgCfmBill : chgCfmBillColl) {
                if (conCfmIds.contains(chgCfmBill.getPkValue())) continue;
                this.chgCfmBills.add((Object)chgCfmBill);
                DynamicObject conChgBill = chgCfmBill.getDynamicObject("chgaudit");
                if (null == conChgBill) continue;
                conChgf7Ids.add(conChgBill.getPkValue());
            }
        }
        HashSet<Object> conChgIds = new HashSet<Object>();
        if (conChgf7Ids.size() > 0) {
            DynamicObject[] chgAuditf7Col;
            for (DynamicObject chgAuditf7 : chgAuditf7Col = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgaudit_f7"), (String)StringUtils.join((Object[])new Object[]{"billid", "id"}, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", conChgf7Ids)})) {
                conChgIds.add(chgAuditf7.get("billid"));
            }
        }
        if ((chgConBillColl = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conchgbill"), (String)TAX_SELECTORS, (QFilter[])new QFilter[]{new QFilter("contractbill", "=", (Object)contractId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue())})).length > 0) {
            for (DynamicObject conChgBill : chgConBillColl) {
                if (conChgIds.contains(conChgBill.getPkValue())) continue;
                this.conChgBills.add((Object)conChgBill);
            }
        }
    }

    protected void projectOnChange(Object currentValue) {
        this.getModel().setValue("contractbill", null);
        this.getView().updateView("contractbill");
    }

    protected void loadMultiTaxRateEntry(Long contractId, boolean ismulticurrency, DynamicObject contractBill) {
        DynamicObjectCollection settleTaxEntry = this.getModel().getEntryEntity("taxentry");
        DynamicObjectType dataEntityType = settleTaxEntry.getDynamicObjectType();
        DynamicObjectCollection conTaxEntrys = contractBill.getDynamicObjectCollection("taxentry");
        this.addSettleTaxEntry(ismulticurrency, (IDataEntityType)dataEntityType, conTaxEntrys);
        if (this.supplyConBills.size() > 0) {
            for (DynamicObject supplyCon : this.supplyConBills) {
                DynamicObjectCollection supplyTaxEntrys = supplyCon.getDynamicObjectCollection("taxentry");
                if (supplyTaxEntrys.size() <= 0) continue;
                this.addSettleTaxEntry(ismulticurrency, (IDataEntityType)dataEntityType, supplyTaxEntrys);
            }
        }
        if (this.chgCfmBills.size() > 0) {
            for (DynamicObject chgCfmBill : this.chgCfmBills) {
                DynamicObjectCollection chgCfmTaxEntrys = chgCfmBill.getDynamicObjectCollection("taxentry");
                if (chgCfmTaxEntrys.size() <= 0) continue;
                this.addSettleTaxEntry(ismulticurrency, (IDataEntityType)dataEntityType, chgCfmTaxEntrys);
            }
        }
        if (this.conChgBills.size() > 0) {
            for (DynamicObject conChgBill : this.conChgBills) {
                DynamicObjectCollection conChgTaxEntrys = conChgBill.getDynamicObjectCollection("taxentry");
                if (conChgTaxEntrys.size() <= 0) continue;
                this.addSettleTaxEntry(ismulticurrency, (IDataEntityType)dataEntityType, conChgTaxEntrys);
            }
        }
    }

    protected void addSettleTaxEntry(boolean ismulticurrency, IDataEntityType dataEntityType, DynamicObjectCollection taxEntrys) {
        int rowCount = this.getModel().getEntryRowCount("taxentry");
        int conTaxEntrySize = taxEntrys.size();
        this.getModel().batchCreateNewEntryRow("taxentry", conTaxEntrySize);
        for (int i = 0; i < taxEntrys.size(); ++i) {
            DynamicObject conTaxEntry = (DynamicObject)taxEntrys.get(i);
            this.getModel().setValue("taxentry_content", conTaxEntry.get("taxentry_content"), rowCount);
            if (ismulticurrency) {
                this.getModel().setValue("taxentry_oriamt", conTaxEntry.get("taxentry_oriamt"), rowCount);
            } else {
                this.getModel().setValue("taxentry_amount", conTaxEntry.get("taxentry_amount"), rowCount);
            }
            this.getModel().setValue("taxentry_taxrate", conTaxEntry.get("taxentry_taxrate"), rowCount);
            this.getModel().setValue("taxentry_notaxamt", conTaxEntry.get("taxentry_notaxamt"), rowCount);
            this.getModel().setValue("taxentry_tax", conTaxEntry.get("taxentry_tax"), rowCount);
            ++rowCount;
        }
    }

    public void loadSettleSummaryEntry(DynamicObject contractBill) {
        DynamicObjectCollection sumEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("settlesumentry");
        Object settleOriAmt = this.getModel().getValue("oriamt");
        Object settleAmount = this.getModel().getValue("amount");
        Object settleNoTaxAmt = this.getModel().getValue("notaxamt");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sumentry_oriamt", settleOriAmt);
        map.put("sumentry_amount", settleAmount);
        map.put("sumentry_notaxamt", settleNoTaxAmt);
        this.setSumEntryRow(SUMENTRY_CONSETTLE, map, sumEntrys);
        map = new HashMap();
        Object conOriAmt = contractBill.get("oriamt");
        Object conAmount = contractBill.get("amount");
        Object conNoTaxAmt = contractBill.get("notaxamt");
        map.put("sumentry_oriamt", conOriAmt);
        map.put("sumentry_amount", conAmount);
        map.put("sumentry_notaxamt", conNoTaxAmt);
        this.setSumEntryRow(SUMENTRY_CONTRACT, map, sumEntrys);
        BigDecimal supplyOriAmt = null;
        BigDecimal supplyAmount = null;
        BigDecimal supplyNoTaxAmt = null;
        for (DynamicObject supplyCon : this.supplyConBills) {
            supplyOriAmt = NumberUtil.add(supplyOriAmt, (Object)supplyCon.get("oriamt"));
            supplyAmount = NumberUtil.add(supplyAmount, (Object)supplyCon.get("amount"));
            supplyNoTaxAmt = NumberUtil.add(supplyNoTaxAmt, (Object)supplyCon.get("notaxamt"));
        }
        map = new HashMap();
        map.put("sumentry_oriamt", supplyOriAmt);
        map.put("sumentry_amount", supplyAmount);
        map.put("sumentry_notaxamt", supplyNoTaxAmt);
        map.put("sumentry_qty", this.supplyConBills.size());
        this.setSumEntryRow(SUMENTRY_SUPPLEYCON, map, sumEntrys);
        BigDecimal chgOriAmt = null;
        BigDecimal chgAmount = null;
        BigDecimal chgNoTaxAmt = null;
        for (DynamicObject conChgBill : this.conChgBills) {
            chgOriAmt = NumberUtil.add(chgOriAmt, (Object)conChgBill.get("oriamt"));
            chgAmount = NumberUtil.add(chgAmount, (Object)conChgBill.get("amount"));
            chgNoTaxAmt = NumberUtil.add(chgNoTaxAmt, (Object)conChgBill.get("notaxamt"));
        }
        for (DynamicObject chgCfmBill : this.chgCfmBills) {
            chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)chgCfmBill.get("oriamt"));
            chgAmount = NumberUtil.add((Object)chgAmount, (Object)chgCfmBill.get("amount"));
            chgNoTaxAmt = NumberUtil.add((Object)chgNoTaxAmt, (Object)chgCfmBill.get("notaxamt"));
        }
        map = new HashMap();
        map.put("sumentry_oriamt", chgOriAmt);
        map.put("sumentry_amount", chgAmount);
        map.put("sumentry_notaxamt", chgNoTaxAmt);
        map.put("sumentry_qty", this.conChgBills.size() + this.chgCfmBills.size());
        this.setSumEntryRow(SUMENTRY_CHANGE, map, sumEntrys);
        BigDecimal ajustOriAmt = NumberUtil.subtract((Object[])new Object[]{settleOriAmt, conOriAmt, supplyOriAmt, chgOriAmt});
        BigDecimal ajustAmt = NumberUtil.subtract((Object[])new Object[]{settleAmount, conAmount, supplyAmount, chgAmount});
        BigDecimal ajustNoTaxAmt = NumberUtil.subtract((Object[])new Object[]{settleNoTaxAmt, conNoTaxAmt, supplyNoTaxAmt, chgNoTaxAmt});
        map = new HashMap();
        map.put("sumentry_oriamt", ajustOriAmt);
        map.put("sumentry_amount", ajustAmt);
        map.put("sumentry_notaxamt", ajustNoTaxAmt);
        this.setSumEntryRow(SUMENTRY_SETTLEADJUST, map, sumEntrys);
    }

    protected void resetSummaryEntry() {
        int i;
        DynamicObjectCollection summaryEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("settlesumentry");
        int sumEntrySize = summaryEntrys.size();
        if (sumEntrySize > 5) {
            for (i = 5; i < sumEntrySize; ++i) {
                summaryEntrys.remove(i);
            }
        }
        if (summaryEntrys.size() == 0) {
            return;
        }
        for (i = 0; i < 5; ++i) {
            DynamicObject row = (DynamicObject)summaryEntrys.get(i);
            row.set("sumentry_oriamt", (Object)NumberUtil.ZERO);
            row.set("sumentry_amount", (Object)NumberUtil.ZERO);
            row.set("sumentry_notaxamt", (Object)NumberUtil.ZERO);
            row.set("sumentry_amtscale", (Object)NumberUtil.ZERO);
            row.set("sumentry_qty", (Object)NumberUtil.ZERO);
        }
    }

    protected void setSumEntryRow(String number, Map<String, Object> sumMap, DynamicObjectCollection sumEntrys) {
        if (sumEntrys.size() == 0) {
            return;
        }
        BigDecimal amtScale = null;
        if (!SUMENTRY_CONSETTLE.equals(number)) {
            int settleRowIndex = this.getRowIndexByNumber(SUMENTRY_CONSETTLE);
            DynamicObject settleRow = (DynamicObject)sumEntrys.get(settleRowIndex);
            amtScale = NumberUtil.multiply((Object)NumberUtil.divide((Object)sumMap.get("sumentry_oriamt"), (Object)settleRow.get("sumentry_oriamt"), (int)4), (Object)NumberUtil.ONE_HUNDRED);
        }
        int rowIndex = this.getRowIndexByNumber(number);
        DynamicObject row = (DynamicObject)sumEntrys.get(rowIndex);
        row.set("sumentry_oriamt", sumMap.get("sumentry_oriamt"));
        row.set("sumentry_amount", sumMap.get("sumentry_amount"));
        row.set("sumentry_notaxamt", sumMap.get("sumentry_notaxamt"));
        row.set("sumentry_amtscale", (Object)amtScale);
        row.set("sumentry_qty", sumMap.get("sumentry_qty"));
    }

    protected void loadDataStandardEntry(DynamicObject bill, DynamicObject contractBill) {
        DynamicObject contractType = contractBill.getDynamicObject("contracttype");
        if (null == contractType) {
            return;
        }
        DynamicObject[] dataStands = DataStandardHelper.getDataStandardArrByContract((String)this.getAppId(), (String)DataStandardBillEnum.CONSETTLE.getValue(), (DynamicObject)contractBill);
        int dataStandSize = dataStands.length;
        if (dataStandSize > 0) {
            this.getModel().batchCreateNewEntryRow("settledataentry", dataStandSize);
            for (int i = 0; i < dataStandSize; ++i) {
                DynamicObject dataStand = dataStands[i];
                this.getModel().setValue("dataentry_datastandard", (Object)dataStand, i);
                this.getModel().setValue("dataentry_reportflag", null, i);
                this.getModel().setValue("dataentry_verifyqty", (Object)0, i);
            }
        }
        this.getModel().updateCache();
    }

    protected void setPayControlInfo(DynamicObject contractBill) {
        DynamicObject[] payReqBills;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal totalrequestoriamt = NumberUtil.ZERO;
        BigDecimal totalrequestamt = NumberUtil.ZERO;
        BigDecimal totalactualpayoriamt = NumberUtil.ZERO;
        BigDecimal totalactualpayamt = NumberUtil.ZERO;
        for (DynamicObject payReqBill : payReqBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "oriamt", "amount", "prepayoriamt", "prepayamt", "payedoriamt", "payedamt"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractBill.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue())})) {
            totalrequestoriamt = NumberUtil.add((Object)totalrequestoriamt, (Object)payReqBill.get("oriamt"));
            totalrequestoriamt = NumberUtil.subtract((Object)totalrequestoriamt, (Object)payReqBill.get("prepayoriamt"));
            totalrequestamt = NumberUtil.add((Object)totalrequestamt, (Object)payReqBill.get("amount"));
            totalrequestamt = NumberUtil.subtract((Object)totalrequestamt, (Object)payReqBill.get("prepayamt"));
            totalactualpayoriamt = NumberUtil.add((Object)totalactualpayoriamt, (Object)payReqBill.get("payedoriamt"));
            totalactualpayamt = NumberUtil.add((Object)totalactualpayamt, (Object)payReqBill.get("payedamt"));
        }
        dataEntity.set("totalrequestoriamt", (Object)totalrequestoriamt);
        dataEntity.set("totalrequestamt", (Object)totalrequestamt);
        dataEntity.set("totalactualpayoriamt", (Object)totalactualpayoriamt);
        dataEntity.set("totalactualpayamt", (Object)totalactualpayamt);
        DynamicObject[] rewardDeductBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (String)String.join((CharSequence)",", "payitem", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractBill.getPkValue())});
        BigDecimal totalGuerdOriAmt = NumberUtil.ZERO;
        BigDecimal totalGuerdAmt = NumberUtil.ZERO;
        BigDecimal totalDeductOriAmt = NumberUtil.ZERO;
        BigDecimal totalDeductAmt = NumberUtil.ZERO;
        for (DynamicObject rewadDeductBill : rewardDeductBills) {
            DynamicObject payItem = rewadDeductBill.getDynamicObject("payitem");
            if (DeductPropertyEnum.ADD.getValue().equals(payItem.get("deductproperty"))) {
                totalGuerdOriAmt = NumberUtil.add((Object)totalGuerdOriAmt, (Object)rewadDeductBill.get("oriamt"));
                totalGuerdAmt = NumberUtil.add((Object)totalGuerdAmt, (Object)rewadDeductBill.get("amount"));
                continue;
            }
            if (!DeductPropertyEnum.SUBTRACT.getValue().equals(payItem.get("deductproperty"))) continue;
            totalDeductOriAmt = NumberUtil.add((Object)totalDeductOriAmt, (Object)rewadDeductBill.get("oriamt"));
            totalDeductAmt = NumberUtil.add((Object)totalDeductAmt, (Object)rewadDeductBill.get("amount"));
        }
        dataEntity.set("totaldeductoriamt", (Object)totalDeductOriAmt);
        dataEntity.set("totaldeductamt", (Object)totalDeductAmt);
        dataEntity.set("totalguerdoriamt", (Object)totalGuerdOriAmt);
        dataEntity.set("totalguerdamt", (Object)totalGuerdAmt);
    }

    @Override
    protected void oriAmtChanged(Object newValue, Object oldValue) {
        super.oriAmtChanged(newValue, oldValue);
        DynamicObject settleBill = this.getModel().getDataEntity(true);
        BigDecimal bailScale = NumberUtil.divide((Object)settleBill.getBigDecimal("bailscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        settleBill.set("bailoriamt", (Object)NumberUtil.multiply((Object)newValue, (Object)bailScale, (int)2));
        this.getView().updateView("bailoriamt");
        boolean isMultiCurrency = settleBill.getBoolean("foreigncurrencyflag");
        this.handleSumEntryByAmtChanged(isMultiCurrency, settleBill);
        this.updatePayableOriAmt(isMultiCurrency);
    }

    @Override
    protected void amountChanged(Object newValue, Object oldValue) {
        super.amountChanged(newValue, oldValue);
        DynamicObject settleBill = this.getModel().getDataEntity(true);
        BigDecimal bailScale = NumberUtil.divide((Object)settleBill.getBigDecimal("bailscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        settleBill.set("bailamt", (Object)NumberUtil.multiply((Object)newValue, (Object)bailScale, (int)2));
        this.getView().updateView("bailamt");
        boolean isMultiCurrency = settleBill.getBoolean("foreigncurrencyflag");
        this.handleSumEntryByAmtChanged(isMultiCurrency, settleBill);
        this.updatePayableAmt(isMultiCurrency);
    }

    @Override
    protected void noTaxAmtChanged(Object newValue, Object oldValue) {
        super.noTaxAmtChanged(newValue, oldValue);
        DynamicObject settleBill = this.getModel().getDataEntity(true);
        boolean isMultiCurrency = settleBill.getBoolean("foreigncurrencyflag");
        this.handleSumEntryByAmtChanged(isMultiCurrency, settleBill);
    }

    protected void handleSumEntryByAmtChanged(boolean isMultiCurrency, DynamicObject settleBill) {
        DynamicObjectCollection summaryEntrys = settleBill.getDynamicObjectCollection("settlesumentry");
        if (summaryEntrys.size() == 0) {
            return;
        }
        DynamicObject settleEntry = (DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_CONSETTLE));
        settleEntry.set("sumentry_oriamt", (Object)settleBill.getBigDecimal("oriamt"));
        settleEntry.set("sumentry_amount", (Object)settleBill.getBigDecimal("amount"));
        settleEntry.set("sumentry_notaxamt", settleBill.get("notaxamt"));
        BigDecimal adjustOriAmt = NumberUtil.ZERO;
        BigDecimal adjustAmt = NumberUtil.ZERO;
        if (isMultiCurrency) {
            BigDecimal exchangeRate = settleBill.getBigDecimal("exchangerate");
            adjustOriAmt = this.getAdjustData("sumentry_oriamt", summaryEntrys);
            adjustAmt = NumberUtil.multiply((Object)adjustOriAmt, (Object)exchangeRate, (int)2);
        } else {
            adjustOriAmt = adjustAmt = this.getAdjustData("sumentry_amount", summaryEntrys);
        }
        BigDecimal adjustNoTaxAmt = this.getAdjustData("sumentry_notaxamt", summaryEntrys);
        DynamicObject adjustEntry = (DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_SETTLEADJUST));
        adjustEntry.set("sumentry_oriamt", (Object)adjustOriAmt);
        adjustEntry.set("sumentry_amount", (Object)adjustAmt);
        adjustEntry.set("sumentry_notaxamt", (Object)adjustNoTaxAmt);
        for (DynamicObject summaryEntry : summaryEntrys) {
            DynamicObject conPayItem = summaryEntry.getDynamicObject("sumentry_conpayitem");
            String ayItemNumber = conPayItem.getString("number");
            if (!this.isNeedCalcAmtScale(ayItemNumber)) continue;
            summaryEntry.set("sumentry_amtscale", (Object)NumberUtil.multiply((Object)NumberUtil.divide((Object)summaryEntry.get("sumentry_oriamt"), (Object)settleBill.getBigDecimal("oriamt"), (int)4), (Object)NumberUtil.ONE_HUNDRED));
        }
        this.getView().updateView("settlesumentry");
    }

    protected BigDecimal getAdjustData(String amtStr, DynamicObjectCollection summaryEntrys) {
        if (summaryEntrys.size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal settleAmt = ((DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_CONSETTLE))).getBigDecimal(amtStr);
        BigDecimal contractAmt = ((DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_CONTRACT))).getBigDecimal(amtStr);
        BigDecimal supplyAmt = ((DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_SUPPLEYCON))).getBigDecimal(amtStr);
        BigDecimal chgAmt = ((DynamicObject)summaryEntrys.get(this.getRowIndexByNumber(SUMENTRY_CHANGE))).getBigDecimal(amtStr);
        return NumberUtil.subtract((Object[])new Object[]{settleAmt, contractAmt, supplyAmt, chgAmt});
    }

    protected boolean isNeedCalcAmtScale(String number) {
        return SUMENTRY_CONTRACT.equals(number) || SUMENTRY_SUPPLEYCON.equals(number) || SUMENTRY_CHANGE.equals(number) || SUMENTRY_SETTLEADJUST.equals(number);
    }

    protected int getRowIndexByNumber(String number) {
        int rowIndex = 0;
        switch (number) {
            case "005": {
                rowIndex = 0;
                break;
            }
            case "004": {
                rowIndex = 1;
                break;
            }
            case "001": {
                rowIndex = 2;
                break;
            }
            case "002": {
                rowIndex = 3;
                break;
            }
            case "003": {
                rowIndex = 4;
                break;
            }
        }
        return rowIndex;
    }

    private void updatePayableOriAmt(boolean isMultiCurrency) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal settleOriAmt = dataEntity.getBigDecimal("oriamt");
        BigDecimal totalDeductOriAmt = dataEntity.getBigDecimal("totaldeductoriamt");
        BigDecimal totalGuerdOriAmt = dataEntity.getBigDecimal("totalguerdoriamt");
        BigDecimal totalactualpayoriamt = dataEntity.getBigDecimal("totalactualpayoriamt");
        BigDecimal payableoriamt = NumberUtil.add((Object[])new Object[]{settleOriAmt, totalDeductOriAmt, totalGuerdOriAmt});
        payableoriamt = NumberUtil.subtract((Object)payableoriamt, (Object)totalactualpayoriamt);
        if (isMultiCurrency) {
            BigDecimal settleAmt = dataEntity.getBigDecimal("amount");
            BigDecimal totalDeductAmt = dataEntity.getBigDecimal("totaldeductamt");
            BigDecimal totalGuerdAmt = dataEntity.getBigDecimal("totalguerdamt");
            BigDecimal totalactualpayamt = dataEntity.getBigDecimal("totalactualpayamt");
            BigDecimal payableamt = NumberUtil.add((Object[])new Object[]{settleAmt, totalDeductAmt, totalGuerdAmt});
            payableamt = NumberUtil.subtract((Object)payableamt, (Object)totalactualpayamt);
            BigDecimal payScale = NumberUtil.multiply((Object)NumberUtil.divide((Object)totalactualpayoriamt, (Object)NumberUtil.add((Object[])new Object[]{settleOriAmt, totalDeductOriAmt, totalGuerdOriAmt}), (int)4), (Object)NumberUtil.ONE_HUNDRED);
            dataEntity.set("payableamt", (Object)payableamt);
            this.getView().updateView("payableamt");
            dataEntity.set("payscale", (Object)payScale);
            this.getView().updateView("payscale");
        }
        dataEntity.set("payableoriamt", (Object)payableoriamt);
        this.getView().updateView("payableoriamt");
    }

    protected void updatePayableAmt(boolean isMultiCurrency) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal settleAmt = dataEntity.getBigDecimal("amount");
        BigDecimal totalDeductAmt = dataEntity.getBigDecimal("totaldeductamt");
        BigDecimal totalGuerdAmt = dataEntity.getBigDecimal("totalguerdamt");
        BigDecimal totalactualpayamt = dataEntity.getBigDecimal("totalactualpayamt");
        BigDecimal payableamt = NumberUtil.add((Object[])new Object[]{settleAmt, totalDeductAmt, totalGuerdAmt});
        payableamt = NumberUtil.subtract((Object)payableamt, (Object)totalactualpayamt);
        if (!isMultiCurrency) {
            BigDecimal settleOriAmt = dataEntity.getBigDecimal("oriamt");
            BigDecimal totalDeductOriAmt = dataEntity.getBigDecimal("totaldeductoriamt");
            BigDecimal totalGuerdOriAmt = dataEntity.getBigDecimal("totalguerdoriamt");
            BigDecimal totalactualpayoriamt = dataEntity.getBigDecimal("totalactualpayoriamt");
            BigDecimal payableoriamt = NumberUtil.add((Object[])new Object[]{settleOriAmt, totalDeductOriAmt, totalGuerdOriAmt});
            payableoriamt = NumberUtil.subtract((Object)payableoriamt, (Object)totalactualpayoriamt);
            BigDecimal payScale = NumberUtil.multiply((Object)NumberUtil.divide((Object)totalactualpayamt, (Object)NumberUtil.add((Object[])new Object[]{settleAmt, totalDeductAmt, totalGuerdAmt}), (int)4), (Object)NumberUtil.ONE_HUNDRED);
            dataEntity.set("payableoriamt", (Object)payableoriamt);
            dataEntity.set("payscale", (Object)payScale);
            this.getView().updateView("payableoriamt");
            this.getView().updateView("payscale");
        }
        dataEntity.set("payableamt", (Object)payableamt);
        this.getView().updateView("payableamt");
    }

    protected void bailOriAmtOnChange(Object bailOriAmt) {
        DynamicObject settleBill = this.getModel().getDataEntity();
        BigDecimal exChangeRate = settleBill.getBigDecimal("exchangerate");
        settleBill.set("bailamt", (Object)NumberUtil.multiply((Object)bailOriAmt, (Object)exChangeRate, (int)2));
        BigDecimal oriAmt = settleBill.getBigDecimal("oriamt");
        BigDecimal bailScale = NumberUtil.divide((Object)bailOriAmt, (Object)oriAmt, (int)4);
        settleBill.set("bailscale", (Object)NumberUtil.multiply((Object)bailScale, (Object)NumberUtil.ONE_HUNDRED, (int)4));
        this.getView().updateView("bailamt");
        this.getView().updateView("bailscale");
    }

    protected void bailAmtOnChange(Object bailAmt) {
        DynamicObject settleBill = this.getModel().getDataEntity();
        settleBill.set("bailoriamt", bailAmt);
        BigDecimal amount = settleBill.getBigDecimal("amount");
        BigDecimal bailScale = NumberUtil.divide((Object)bailAmt, (Object)amount, (int)4);
        settleBill.set("bailscale", (Object)NumberUtil.multiply((Object)bailScale, (Object)NumberUtil.ONE_HUNDRED, (int)4));
        this.getView().updateView("bailoriamt");
        this.getView().updateView("bailscale");
    }

    protected void bailScaleOnChange(Object bailScale) {
        DynamicObject settleBill = this.getModel().getDataEntity();
        bailScale = NumberUtil.divide((Object)bailScale, (Object)NumberUtil.ONE_HUNDRED, (int)4);
        boolean isMultiCurrency = settleBill.getBoolean("foreigncurrencyflag");
        if (isMultiCurrency) {
            BigDecimal exChangeRate = settleBill.getBigDecimal("exchangerate");
            settleBill.set("bailoriamt", (Object)NumberUtil.multiply((Object)settleBill.get("oriamt"), (Object)bailScale, (int)2));
            settleBill.set("bailamt", (Object)NumberUtil.multiply((Object)settleBill.get("bailoriamt"), (Object)exChangeRate, (int)2));
        } else {
            settleBill.set("bailamt", (Object)NumberUtil.multiply((Object)settleBill.get("amount"), (Object)bailScale, (int)2));
            settleBill.set("bailoriamt", settleBill.get("bailamt"));
        }
        this.getView().updateView("bailoriamt");
        this.getView().updateView("bailamt");
        this.getView().updateView("bailscale");
    }

    protected void conPayItemOnChange(Object newVal) {
        if (null == newVal) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject conPayItem = (DynamicObject)newVal;
        DynamicObject contractBill = dataEntity.getDynamicObject("contractbill");
        DynamicObject[] rewardDeductBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (String)String.join((CharSequence)",", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractBill.getPkValue()), new QFilter("payitem", "=", conPayItem.getPkValue())});
        int billSize = rewardDeductBills.length;
        BigDecimal oriAmt = NumberUtil.ZERO;
        BigDecimal amount = NumberUtil.ZERO;
        for (DynamicObject rewardDeduct : rewardDeductBills) {
            oriAmt = NumberUtil.add((Object)oriAmt, (Object)rewardDeduct.get("oriamt"));
            amount = NumberUtil.add((Object)amount, (Object)rewardDeduct.get("amount"));
        }
        EntryGrid sumEntryGrid = (EntryGrid)this.getView().getControl("settlesumentry");
        int[] rows = sumEntryGrid.getSelectRows();
        if (0 == rows.length) {
            return;
        }
        int rowIndex = rows[0];
        DynamicObjectCollection summaryEntrys = dataEntity.getDynamicObjectCollection("settlesumentry");
        DynamicObject curEntry = (DynamicObject)summaryEntrys.get(rowIndex);
        curEntry.set("sumentry_oriamt", (Object)oriAmt);
        curEntry.set("sumentry_amount", (Object)amount);
        curEntry.set("sumentry_notaxamt", (Object)amount);
        curEntry.set("sumentry_qty", (Object)billSize);
        this.getView().updateView("settlesumentry");
    }
}

