/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractbill;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.ConPayPlanHelper;
import kd.pccs.concs.common.enums.BizStatusEnum;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplFormPlugin;
import kd.pccs.concs.formplugin.contractbill.ContractBillAttachmentListener;
import kd.pccs.concs.formplugin.contractbill.ContractBillPropertyChanged;
import kd.pccs.concs.formplugin.contractbill.ContractBillTabSelectListener;
import kd.pccs.concs.formplugin.f7.ConTemplateF7SelectListener;
import kd.pccs.concs.formplugin.f7.ContractTypeF7SelectListener;
import kd.pccs.concs.formplugin.f7.HandlerF7Listener;
import kd.pccs.concs.formplugin.f7.OrgF7Selectener;
import org.apache.commons.lang.StringUtils;

public class ContractBillFormPlugin
extends BillOrgTaxTplFormPlugin {
    public static final String CONCS_CONPAYPLANTAB_PAGEID = "concs_conpayplantab_pageid";
    protected static final String TABAP = "tabap";
    public static final String TABCONPAYPLANINFO = "tabconpayplaninfo";
    public static final String TABCONPAYPLAN = "tabconpayplan";
    protected static final String BAR_EDITDOC = "bar_editdoc";
    protected static final String ATTACHMENTPANEL = "attachmentpanel";
    protected ContractBillAttachmentListener conAttListener = null;
    protected ContractBillTabSelectListener tabSelectListener = null;

    @Override
    public void initialize() {
        super.initialize();
        this.initListener();
    }

    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new ContractBillPropertyChanged(this, this.getModel());
    }

    protected void initListener() {
        this.tabSelectListener = new ContractBillTabSelectListener(this, this.getModel());
        this.conAttListener = new ContractBillAttachmentListener(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.tabSelectListener.registerListener((Tab)this.getView().getControl(TABAP));
        this.registerContractTypeF7();
        this.registerConTemplateF7();
        this.registerOrgF7();
        this.registerBizDepartF7();
        this.addItemClickListeners(new String[]{BAR_EDITDOC});
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        attachmentpanel.addUploadListener((UploadListener)this.conAttListener);
    }

    protected void registerHandlerF7() {
        new HandlerF7Listener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("handler"));
    }

    protected void registerContractTypeF7() {
        new ContractTypeF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contracttype"));
    }

    protected void registerConTemplateF7() {
        new ConTemplateF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contemplate"));
    }

    protected void registerOrgF7() {
        new OrgF7Selectener((AbstractFormPlugin)this, this.getModel(), "10").registerListener((BasedataEdit)this.getView().getControl("fiaccountorg"));
    }

    protected void registerBizDepartF7() {
        new OrgF7Selectener((AbstractFormPlugin)this, this.getModel(), "01").registerListener((BasedataEdit)this.getView().getControl("bizdepart")).setCustomQFilter((evt, qFilters) -> qFilters.add(new QFilter("orgpattern", "=", (Object)"4")));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.afterCreateNewData();
    }

    protected void afterCreateNewData() {
        DynamicObject conObj = this.getModel().getDataEntity();
        DynamicObject org = conObj.getDynamicObject("org");
        if (null != org) {
            DynamicObject currencyObj = CurrencyHelper.getCurrency((Long)org.getLong("id"));
            conObj.set("oricurrency", (Object)currencyObj);
            conObj.set("currency", (Object)currencyObj);
        }
        conObj.set("exchangerate", (Object)BigDecimal.ONE);
        if (conObj.getDynamicObject("handler") != null) {
            DynamicObject handler = BusinessDataServiceHelper.loadSingle((Object)conObj.getDynamicObject("handler").getPkValue(), (String)"bos_user");
            DynamicObjectCollection departments = handler.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < departments.size(); ++i) {
                DynamicObject mainDpt;
                DynamicObject orgpattern;
                DynamicObject department = (DynamicObject)departments.get(i);
                if (department.getBoolean("ispartjob") || department.getDynamicObject("dpt") == null || !"4".equals((orgpattern = (mainDpt = BusinessDataServiceHelper.loadSingle((Object)department.getDynamicObject("dpt").getPkValue(), (String)"bos_org")).getDynamicObject("orgpattern")).getPkValue().toString())) continue;
                conObj.set("bizdepart", (Object)mainDpt);
                break;
            }
        }
        conObj.set("bizstatus", (Object)BizStatusEnum.TODO.getValue());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_EDITDOC.equals(itemKey)) {
            this.conAttListener.editDoc();
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.hasDbConPayPlan()) {
            this.tabSelectListener.createSonViewFormParentView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OperationUtil.isSubmitOp((String)operateKey) && !this.checkConPayPlanDataCanSubmit(args)) {
            args.setCancel(true);
            return;
        }
    }

    protected boolean checkConPayPlanDataCanSubmit(BeforeDoOperationEventArgs args) {
        String sonPageId = this.getPageCache().get(CONCS_CONPAYPLANTAB_PAGEID);
        if (sonPageId == null) {
            return true;
        }
        IFormView sonView = this.getView().getView(sonPageId);
        try {
            if (null != sonView) {
                DynamicObject sonDataEntity = sonView.getModel().getDataEntity(true);
                ConPayPlanHelper.checkScheduleEntryAmount((String)this.getAppId(), (DynamicObject)sonDataEntity);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (OperationUtil.isSaveOp((String)operateKey) || OperationUtil.isSubmitOp((String)operateKey) || "unsubmit".equals(operateKey)) {
            this.invokeConPayPlanOperation(operateKey);
        } else if (OperationUtil.isUnAuditOp((String)operateKey)) {
            this.invokeConPayPlanOperation("unsubmit");
        }
    }

    protected void invokeConPayPlanOperation(String operateKey) {
        OperationResult operationResult;
        String sonPageId = this.getPageCache().get(CONCS_CONPAYPLANTAB_PAGEID);
        if (sonPageId == null) {
            return;
        }
        IFormView subView = this.getView().getView(sonPageId);
        if (null == subView) {
            return;
        }
        DynamicObject conObj = this.getModel().getDataEntity();
        DynamicObject conF7Obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill_f7")));
        conF7Obj.set("id", conObj.getPkValue());
        DynamicObject conPayPlanObj = subView.getModel().getDataEntity();
        conPayPlanObj.set("contractbill", (Object)conF7Obj);
        if (StringUtils.isEmpty((String)conPayPlanObj.getString("billno"))) {
            conPayPlanObj.set("billno", (Object)conObj.getString("billno"));
        }
        if (null == conPayPlanObj.get("org")) {
            conPayPlanObj.set("org", conObj.get("org"));
        }
        if (!(operationResult = this.getView().getView(sonPageId).invokeOperation(operateKey)).isSuccess()) {
            // empty if block
        }
        this.tabSelectListener.createSonViewFormParentView();
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        SupplierUtil.handleContractSupplierName((String)this.getView().getFormShowParameter().getFormId(), (DynamicObject)this.getModel().getDataEntity(true), null);
    }

    protected boolean hasDbConPayPlan() {
        Long pk = (Long)this.getModel().getDataEntity().getPkValue();
        if (0L == pk) {
            return false;
        }
        return ConPayPlanHelper.existsConPayPlan((String)this.getAppId(), (Long)pk, (boolean)false);
    }
}

