/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractbill;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;
import kd.pccs.concs.formplugin.contractbill.ContractBillFormPlugin;

public class ContractBillPropertyChanged
extends BillOrgTaxTplPropertyChanged {
    public ContractBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String ctrlName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (ctrlName = e.getProperty().getName()) {
            case "contracttype": {
                this.contactTypeChanged(newValue, oldValue);
                break;
            }
            case "org": {
                this.orgChanged(newValue, oldValue);
                break;
            }
            case "foreigncurrencyflag": {
                this.isMultiCurrencyChanged(newValue, oldValue);
                break;
            }
            case "multitaxrateflag": {
                this.isMultiTaxRateChanged(newValue, oldValue);
                break;
            }
            case "oricurrency": {
                this.oriCurrencyChanged(newValue, oldValue);
                break;
            }
            case "exchangerate": {
                this.exchangeRateChanged(newValue, oldValue);
                break;
            }
            case "estchgscale": {
                this.estchgScaleChanged(newValue, oldValue);
                break;
            }
            case "marginscale": {
                this.marginScaleChanged(newValue, oldValue);
            }
        }
    }

    protected void contactTypeChanged(Object newValue, Object oldValue) {
        if (newValue == null) {
            this.getModel().setValue("estchgscale", null);
            this.getModel().setValue("marginscale", null);
            this.getModel().setValue("paywarnscale", null);
        } else {
            DynamicObject contractType = (DynamicObject)newValue;
            DynamicObject conctrlStand = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conctrlstand"), (String)String.join((CharSequence)",", "chgctrlscale", "marginscale", "paywarnscale"), (QFilter[])new QFilter[]{new QFilter("group", "=", contractType.getPkValue())});
            if (conctrlStand != null) {
                this.getModel().setValue("estchgscale", conctrlStand.get("chgctrlscale"));
                this.getModel().setValue("marginscale", conctrlStand.get("marginscale"));
                this.getModel().setValue("paywarnscale", conctrlStand.get("paywarnscale"));
            }
        }
    }

    protected void orgChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        if (newValue == null) {
            this.getModel().setValue("contracttype", null);
            this.getModel().setValue("currency", null);
        } else {
            DynamicObject createOrg;
            DynamicObject contractType = billObj.getDynamicObject("contracttype");
            Long orgId = (Long)((DynamicObject)newValue).getPkValue();
            if (contractType != null && (createOrg = contractType.getDynamicObject("createorg")) != null && !createOrg.getPkValue().equals(orgId)) {
                this.getModel().setValue("contracttype", null);
            }
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((Long)orgId));
            Optional.ofNullable(billObj.getDynamicObject("oricurrency")).map(oriCurrency -> (Long)oriCurrency.getPkValue()).ifPresent(sourceCurrencyID -> this.getModel().setValue("exchangerate", (Object)CurrencyHelper.getExchangeRate((Long)orgId, (Long)sourceCurrencyID)));
        }
    }

    protected void isMultiTaxRateChanged(Object newValue, Object oldValue) {
        Boolean isMultiTaxRate = (Boolean)newValue;
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection taxEntryColl = billObj.getDynamicObjectCollection("taxentry");
        if (isMultiTaxRate.booleanValue()) {
            if (taxEntryColl.size() == 0) {
                DynamicObject taxEntryObj = taxEntryColl.addNew();
                taxEntryObj.set("taxentry_oriamt", billObj.get("oriamt"));
                taxEntryObj.set("taxentry_amount", billObj.get("amount"));
                taxEntryObj.set("taxentry_notaxamt", billObj.get("notaxamt"));
                taxEntryObj.set("taxentry_tax", billObj.get("tax"));
                taxEntryObj.set("taxentry_taxrate", billObj.get("bd_taxrate"));
            }
        } else {
            taxEntryColl.clear();
            DynamicObject taxRate = billObj.getDynamicObject("bd_taxrate");
            if (!Objects.isNull(taxRate)) {
                this.getModel().setValue("taxrate", (Object)NumberUtil.multiply((Object)taxRate.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED));
                this.taxRateChanged(taxRate, null);
            }
        }
        this.getView().updateView("taxentry");
    }

    protected void isMultiCurrencyChanged(Object newValue, Object oldValue) {
        Boolean isMultiCurrency = (Boolean)newValue;
        DynamicObject billObj = this.getModel().getDataEntity();
        this.getModel().setValue("exchangerate", (Object)NumberUtil.ONE);
        if (!isMultiCurrency.booleanValue()) {
            this.getModel().setValue("oricurrency", billObj.get("currency"));
            this.amountChanged(billObj.get("amount"), null);
        }
    }

    protected void oriCurrencyChanged(Object newValue, Object oldValue) {
        DynamicObject orgObj;
        ((ContractBillFormPlugin)this.plugin).tabSelectListener.oriCurrencyChanged();
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        if (!isMultiCurrency) {
            return;
        }
        BigDecimal exchangeRate = NumberUtil.ONE;
        if (null != newValue && null != (orgObj = billObj.getDynamicObject("org"))) {
            exchangeRate = CurrencyHelper.getExchangeRate((Long)((Long)orgObj.getPkValue()), (Long)((Long)((DynamicObject)newValue).getPkValue()));
        }
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
    }

    protected void exchangeRateChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        if (!isMultiCurrency) {
            return;
        }
        BigDecimal exchangeRate = NumberUtil.toBigDecimal((Object)newValue);
        BigDecimal amount = NumberUtil.multiply((Object)billObj.getBigDecimal("oriamt"), (Object)exchangeRate);
        BigDecimal estchgAmt = NumberUtil.multiply((Object)billObj.getBigDecimal("estchgoriamt"), (Object)exchangeRate);
        BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
        BigDecimal marginAmt = NumberUtil.multiply((Object)billObj.getBigDecimal("marginoriamt"), (Object)exchangeRate);
        BigDecimal estsettleAmt = NumberUtil.add((Object)amount, (Object)estchgAmt);
        this.getModel().setValue("estchgamt", (Object)estchgAmt);
        this.getModel().setValue("marginamt", (Object)marginAmt);
        this.getModel().setValue("estsettleamt", (Object)estsettleAmt);
        this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
        this.getModel().setValue("amount", (Object)amount);
        DynamicObjectCollection taxEntryColl = billObj.getDynamicObjectCollection("taxentry");
        int isize = taxEntryColl.size();
        for (int i = 0; i < isize; ++i) {
            DynamicObject taxEntryObj = (DynamicObject)taxEntryColl.get(i);
            BigDecimal taxentry_amount = NumberUtil.multiply((Object)taxEntryObj.getBigDecimal("taxentry_oriamt"), (Object)exchangeRate);
            this.getModel().setValue("taxentry_amount", (Object)taxentry_amount, i);
        }
    }

    @Override
    protected void oriAmtChanged(Object newValue, Object oldValue) {
        super.oriAmtChanged(newValue, oldValue);
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        if (isMultiCurrency) {
            BigDecimal exchangeRate = billObj.getBigDecimal("exchangerate");
            BigDecimal estchgoriamt = NumberUtil.multiply((Object)newValue, (Object)NumberUtil.divide((Object)billObj.getBigDecimal("estchgscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4));
            BigDecimal estchgAmt = NumberUtil.multiply((Object)estchgoriamt, (Object)exchangeRate);
            BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
            this.getModel().setValue("estchgoriamt", (Object)estchgoriamt);
            this.getModel().setValue("estchgamt", (Object)estchgAmt);
            this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
            BigDecimal marginoriamt = NumberUtil.multiply((Object)newValue, (Object)NumberUtil.divide((Object)billObj.getBigDecimal("marginscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4));
            BigDecimal marginAmt = NumberUtil.multiply((Object)marginoriamt, (Object)exchangeRate);
            this.getModel().setValue("marginoriamt", (Object)marginoriamt);
            this.getModel().setValue("marginamt", (Object)marginAmt);
            BigDecimal estsettleoriamt = NumberUtil.add((Object)newValue, (Object)estchgoriamt);
            BigDecimal estsettleAmt = NumberUtil.add((Object)billObj.getBigDecimal("amount"), (Object)estchgAmt);
            this.getModel().setValue("estsettleoriamt", (Object)estsettleoriamt);
            this.getModel().setValue("estsettleamt", (Object)estsettleAmt);
        }
        ((ContractBillFormPlugin)this.plugin).tabSelectListener.oriAmtChanged();
    }

    @Override
    protected void amountChanged(Object newValue, Object oldValue) {
        super.amountChanged(newValue, oldValue);
        DynamicObject billObj = this.getModel().getDataEntity();
        boolean isMultiCurrency = billObj.getBoolean("foreigncurrencyflag");
        if (!isMultiCurrency) {
            BigDecimal estchgAmt = NumberUtil.multiply((Object)newValue, (Object)NumberUtil.divide((Object)billObj.getBigDecimal("estchgscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4));
            BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
            BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
            this.getModel().setValue("estchgoriamt", (Object)estchgAmt);
            this.getModel().setValue("estchgamt", (Object)estchgAmt);
            this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
            BigDecimal marginAmt = NumberUtil.multiply((Object)newValue, (Object)NumberUtil.divide((Object)billObj.getBigDecimal("marginscale"), (Object)NumberUtil.ONE_HUNDRED, (int)4));
            this.getModel().setValue("marginoriamt", (Object)marginAmt);
            this.getModel().setValue("marginamt", (Object)marginAmt);
            BigDecimal estsettleAmt = NumberUtil.add((Object)newValue, (Object)estchgAmt);
            this.getModel().setValue("estsettleoriamt", (Object)estsettleAmt);
            this.getModel().setValue("estsettleamt", (Object)estsettleAmt);
        }
        ((ContractBillFormPlugin)this.plugin).tabSelectListener.amountChanged();
    }

    protected void estchgScaleChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        BigDecimal oriAmt = billObj.getBigDecimal("oriamt");
        BigDecimal amount = billObj.getBigDecimal("amount");
        BigDecimal estchgScale = NumberUtil.divide((Object)newValue, (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal estchgoriamt = NumberUtil.multiply((Object)oriAmt, (Object)estchgScale);
        BigDecimal estchgAmt = NumberUtil.multiply((Object)amount, (Object)estchgScale);
        BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
        BigDecimal estsettleoriamt = NumberUtil.add((Object)oriAmt, (Object)estchgoriamt);
        BigDecimal estsettleAmt = NumberUtil.add((Object)amount, (Object)estchgAmt);
        this.getModel().setValue("estchgoriamt", (Object)estchgoriamt);
        this.getModel().setValue("estchgamt", (Object)estchgAmt);
        this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
        this.getModel().setValue("estsettleoriamt", (Object)estsettleoriamt);
        this.getModel().setValue("estsettleamt", (Object)estsettleAmt);
    }

    protected void marginScaleChanged(Object newValue, Object oldValue) {
        DynamicObject billObj = this.getModel().getDataEntity();
        BigDecimal oriAmt = billObj.getBigDecimal("oriamt");
        BigDecimal amount = billObj.getBigDecimal("amount");
        BigDecimal marginScale = NumberUtil.divide((Object)newValue, (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal marginOriAmt = NumberUtil.multiply((Object)oriAmt, (Object)marginScale);
        BigDecimal marginAmt = NumberUtil.multiply((Object)amount, (Object)marginScale);
        this.getModel().setValue("marginoriamt", (Object)marginOriAmt);
        this.getModel().setValue("marginamt", (Object)marginAmt);
    }

    @Override
    protected void taxEntry_taxRateChanged(int rowIndex, Object newValue, Object oldValue) {
        super.taxEntry_taxRateChanged(rowIndex, newValue, oldValue);
        DynamicObject billObj = this.getModel().getDataEntity(true);
        BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal estchgAmt = billObj.getBigDecimal("estchgamt");
        BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
        this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
    }

    @Override
    protected void taxRateChanged(Object newValue, Object oldValue) {
        super.taxRateChanged(newValue, oldValue);
        DynamicObject billObj = this.getModel().getDataEntity(true);
        BigDecimal taxRate = NumberUtil.divide((Object)billObj.getBigDecimal("taxrate"), (Object)NumberUtil.ONE_HUNDRED, (int)4);
        BigDecimal estchgAmt = billObj.getBigDecimal("estchgamt");
        BigDecimal estchgNoTaxAmt = NumberUtil.divide((Object)estchgAmt, (Object)NumberUtil.add((Object)NumberUtil.ONE, (Object)taxRate));
        this.getModel().setValue("estchgnotaxamt", (Object)estchgNoTaxAmt);
    }
}

