/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractbill;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.formplugin.base.AbstractTabSelectListener;
import org.apache.commons.lang.StringUtils;

public class ContractBillTabSelectListener
extends AbstractTabSelectListener {
    private static final String REOPENCONPAYPLANPAGE = "reOpenConPayPlanPage";

    public ContractBillTabSelectListener(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void registerListener(Tab tabCtrl) {
        tabCtrl.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (StringUtils.equals((String)"tabconpayplan", (String)tabKey) && this.needOpenSonPage()) {
            this.createSonViewFormParentView();
        }
    }

    public void createSonViewFormParentView() {
        String subPageId = this.getPageCache().get("concs_conpayplantab_pageid");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (subPageId != null && OperationUtil.isViewOp((OperationStatus)status)) {
            return;
        }
        boolean isConRevise = this.isConRevise();
        BillShowParameter billShowParameter = new BillShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long billId = (Long)dataEntity.getPkValue();
        billShowParameter.setParentFormId(billId.toString());
        billShowParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"));
        billShowParameter.setStatus(status);
        billShowParameter.setAppId(this.getAppId());
        billShowParameter.setHasRight(true);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("tabconpayplaninfo");
        billShowParameter.setOpenStyle(openStyle);
        if (billId != 0L) {
            QFilter qFilter = isConRevise ? new QFilter("conrevisebill", "=", (Object)billId) : new QFilter("contractbill", "=", (Object)billId);
            DynamicObject conPayPlanId = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"), (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (conPayPlanId != null) {
                billShowParameter.setPkId(conPayPlanId.getPkValue());
            }
        }
        if (isConRevise) {
            billShowParameter.setCustomParam("contractbill", dataEntity.getDynamicObject("contractbill").getPkValue());
            billShowParameter.setCustomParam("conrevisebill", (Object)billId);
            billShowParameter.setCustomParam("parentPage", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill"));
        } else {
            billShowParameter.setCustomParam("contractbill", (Object)billId);
            billShowParameter.setCustomParam("parentPage", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
        this.getPageCache().put("concs_conpayplantab_pageid", billShowParameter.getPageId());
        this.getPageCache().put(REOPENCONPAYPLANPAGE, "false");
    }

    private boolean needOpenSonPage() {
        String needOpenSonPage = this.getPageCache().get(REOPENCONPAYPLANPAGE);
        return needOpenSonPage == null || !StringUtils.equals((String)needOpenSonPage, (String)"false");
    }

    protected boolean isConRevise() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill").equals(formId)) {
            return false;
        }
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill").equals(formId);
    }

    protected void oriAmtChanged() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        fieldMap.put("oriamt", this.getModel().getValue("oriamt"));
        this.setData2Subpage(fieldMap);
    }

    protected void oriCurrencyChanged() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        fieldMap.put("oricurrency", this.getModel().getValue("oricurrency"));
        this.setData2Subpage(fieldMap);
    }

    protected void amountChanged() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        fieldMap.put("amount", this.getModel().getValue("amount"));
        this.setData2Subpage(fieldMap);
    }

    protected void setData2Subpage(Map<String, Object> fieldMap) {
        String subPageId = this.getPageCache().get("concs_conpayplantab_pageid");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (subPageId != null && OperationUtil.isViewOp((OperationStatus)status)) {
            return;
        }
        Optional.ofNullable(this.getView().getView(subPageId)).ifPresent(subView -> {
            IDataModel planModel = subView.getModel();
            fieldMap.entrySet().forEach(entry -> planModel.setValue((String)entry.getKey(), entry.getValue()));
            this.getView().sendFormAction(subView);
        });
    }
}

