/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractbill;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.pccs.concs.common.util.DynamicObjectUtil;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.util.WebOfficeUtil;
import org.apache.commons.lang.StringUtils;

public class WebOfficeOpFormPlugin
extends AbstractFormPlugin
implements UploadListener,
WebOfficeDataListener {
    private static final Log logger = LogFactory.getLog(WebOfficeOpFormPlugin.class);
    public static final String ID = "id";
    public static final String DOCURL = "docurl";
    public static final String DOCNAME = "docname";
    public static final String FILENAME = "filename";
    public static final String FILEURL = "fileurl";
    public static final String WEBOFFICEAP = "webofficeap";
    public static final String TPLID = "tplId";
    public static final String CURRENTDOCURL = "currentdocurl";
    public static final String BTN_SAVE = "btn_save";
    public static final String TOOLBARAP = "toolbarap";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String TEMPFILE = "tempfile";
    public static final String VARIABLEENTRY = "variableentry";
    public static final String VARIABLEMAP = "variablemap";
    public static final String VARIABLEKEY = "variablekey";
    public static final String UTF8 = "utf-8";
    protected static final String APPID = "appId";

    public String getAppId() {
        return (String)this.getView().getFormShowParameter().getCustomParam(APPID);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Long id = (Long)param.getCustomParam(ID);
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        String fileUrl = contractBill.getString("condocurl");
        String fileName = contractBill.getString("condocname");
        String name = contractBill.getString("billname");
        this.getModel().setValue(ID, (Object)id);
        this.getModel().setValue("billname", (Object)name);
        Object tplId = param.getCustomParam(TPLID);
        DynamicObject contemplate = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contemplate"));
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        if (StringUtils.isNotBlank((String)fileUrl)) {
            String encode;
            block9: {
                if (StringUtils.isEmpty((String)(fileUrl = UrlService.getAttachmentFullUrl((String)fileUrl)))) {
                    return;
                }
                name = fileName.substring(0, fileName.lastIndexOf(46));
                encode = "";
                try {
                    encode = URLEncoder.encode(name, UTF8);
                }
                catch (UnsupportedEncodingException e1) {
                    if (!logger.isErrorEnabled()) break block9;
                    logger.error((Throwable)e1);
                }
            }
            fileUrl = fileUrl.replace(name, encode);
            webOffice.open(fileUrl);
        } else {
            String url = contemplate.getString(CURRENTDOCURL);
            String tempName = contemplate.getString("currentdocname");
            if (StringUtils.isNotBlank((String)url)) {
                String encode;
                block10: {
                    if (StringUtils.isEmpty((String)(url = UrlService.getAttachmentFullUrl((String)url)))) {
                        return;
                    }
                    encode = "";
                    try {
                        encode = URLEncoder.encode(tempName, UTF8);
                    }
                    catch (UnsupportedEncodingException e1) {
                        if (!logger.isErrorEnabled()) break block10;
                        logger.error((Throwable)e1);
                    }
                }
                url = url.replace(tempName, encode);
                webOffice.open(url);
                String userName = RequestContext.get().getUserName();
                webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
                this.replaceDoc();
            }
        }
        String userName = RequestContext.get().getUserName();
        webOffice.setTrackingMode(userName, WebOfficeTrackingType.TRACKING_EDIT);
        webOffice.unLimitDoc(WEBOFFICEAP);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[0]);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBARAP);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_save": {
                this.saveDoc();
                break;
            }
        }
    }

    protected void saveDoc() {
        String name = this.getModel().getDataEntity().getString("billname");
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.save(name);
    }

    public void afterUpload(UploadEvent evt) {
        Long id = this.getModel().getDataEntity().getLong(ID);
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        String docurl = contractBill.getString("condocurl");
        String docname = contractBill.getString("condocname");
        String name = this.getModel().getDataEntity().getString("billname");
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u6863", (String)"WebOfficeOpFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            return;
        }
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof Map) {
            filePath = ((Map)urlData).get(URL).toString();
            fileName = StringUtils.isBlank((String)docname) ? name : name + docname.substring(docname.lastIndexOf(46));
            url = filePath;
        }
        HashMap<String, Object> filePathDataMap = new HashMap<String, Object>();
        filePathDataMap.put(APPID, this.getAppId());
        filePathDataMap.put("formId", this.getView().getFormShowParameter().getFormId());
        filePathDataMap.put("pkId", id);
        Map<String, String> uploaDataMap = WebOfficeUtil.uploadTempFile(url, docurl, filePath, fileName, filePathDataMap);
        fileName = uploaDataMap.get("fileName");
        url = uploaDataMap.get(URL);
        String key = evt.getCallbackKey();
        if (WEBOFFICEAP.equals(key)) {
            Long conDocFileId;
            block5: {
                contractBill.set("condocurl", (Object)url);
                contractBill.set("condocname", (Object)fileName);
                conDocFileId = contractBill.getLong("condocfileid");
                try {
                    conDocFileId = WebOfficeUtil.uploadDoc(this.getAppId(), id, conDocFileId, fileName, url, true);
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Throwable)e);
                }
            }
            contractBill.set("condocfileid", (Object)conDocFileId);
            SaveServiceHelper.update((DynamicObject)contractBill);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"WebOfficeOpFormPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void replaceDoc() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Long id = (Long)param.getCustomParam(ID);
        Long tplId = (Long)param.getCustomParam(TPLID);
        DynamicObject tpl = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contemplate"));
        DynamicObjectCollection tplVariables = tpl.getDynamicObjectCollection(VARIABLEENTRY);
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        DataEntityPropertyCollection properties = contractBill.getDynamicObjectType().getProperties();
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>();
        for (DynamicObject variable : tplVariables) {
            String mapProp = variable.getString(VARIABLEMAP);
            String key = variable.getString(VARIABLEKEY);
            Object objectValue = contractBill.get(mapProp);
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)mapProp);
            String value = DynamicObjectUtil.valueToString((IDataEntityProperty)property, (Object)objectValue);
            marks.add(new WebOfficeMark(key, value));
        }
        if (marks.size() > 0) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            webOffice.modifyMarks(marks);
        }
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent var1) {
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent var1) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent var1) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent var1) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent var1) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent var1) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent var1) {
    }
}

