/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.PermissionUtil;

public abstract class AbstractSubBillTpl4CCFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long conId = null;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object contractBillId = formShowParameter.getCustomParam("contractbill");
        if (null != contractBillId) {
            conId = Long.valueOf(contractBillId.toString());
        }
        this.loadData(conId);
    }

    protected abstract void loadData(Long var1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillShowParameter showParameter = this.getHyperLinkClickShowParameter(hyperLinkClickEvent);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent event) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billentry");
        DynamicObject curRow = (DynamicObject)rows.get(event.getRowIndex());
        String billId = this.getBillId4HyperLink(curRow);
        String billStatus = curRow.getString("entry_billstatus");
        String detailFormId = this.getDetailFormId(event);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(detailFormId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)billId);
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.setAppId(this.getAppId());
        Long userId = RequestContext.get().getCurrUserId();
        Long orgId = RequestContext.get().getOrgId();
        boolean hasModifyPerm = PermissionUtil.checkPermissionById((String)"4715a0df000000ac", (Long)userId, (Long)orgId, (String)this.getAppId(), (String)detailFormId);
        boolean isSave = BillStatusEnum.SAVED.getValue().equals(billStatus);
        if (hasModifyPerm && isSave) {
            showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.EDIT.getValue()));
        }
        return showParameter;
    }

    protected String getBillId4HyperLink(DynamicObject rowData) {
        return rowData.getString("id");
    }

    protected abstract String getDetailFormId(HyperLinkClickEvent var1);
}

