/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.ChgBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class ConChgBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conchgbill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadConChgEntryData(conId);
    }

    protected void loadConChgEntryData(Long conId) {
        if (null == conId) {
            return;
        }
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "oricurrency", "currency", "estchgoriamt"));
        IDataModel model = this.getModel();
        BigDecimal totalconchgamt = BigDecimal.ZERO;
        String chgAuditSelect = this.getChgAuditSelect();
        ArrayList<QFilter> chgAuditFilter = new ArrayList<QFilter>();
        chgAuditFilter.add(new QFilter("contractbill", "=", (Object)conId));
        DynamicObject[] chgAuditBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgaudit_f7"), (String)chgAuditSelect, (QFilter[])chgAuditFilter.toArray(new QFilter[chgAuditFilter.size()]));
        int chgAuditBillLength = chgAuditBills.length;
        String cfmSelect = this.getChgCfmSelect();
        ArrayList<QFilter> cfmFilter = new ArrayList<QFilter>();
        cfmFilter.add(new QFilter("contractbill", "=", (Object)conId));
        DynamicObject[] cfmBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"), (String)cfmSelect, (QFilter[])cfmFilter.toArray(new QFilter[cfmFilter.size()]));
        int cfmBillLength = cfmBills.length;
        HashMap<Long, DynamicObject> cfmMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> notChgAuditcfmMap = new HashMap<Long, DynamicObject>();
        for (int i = 0; i < cfmBillLength; ++i) {
            DynamicObject bill = cfmBills[i];
            if (null != bill.getDynamicObject("chgaudit")) {
                cfmMap.put((Long)bill.getPkValue(), bill);
                continue;
            }
            notChgAuditcfmMap.put((Long)bill.getPkValue(), bill);
        }
        model.deleteEntryData("billentry");
        DynamicObjectCollection conChgEntryCol = model.getEntryEntity("billentry");
        for (int i = 0; i < chgAuditBillLength; ++i) {
            DynamicObject row = new DynamicObject(conChgEntryCol.getDynamicObjectType());
            DynamicObject bill = chgAuditBills[i];
            BigDecimal applyOriAmt = bill.getBigDecimal("applyoriamt");
            BigDecimal oriAmt = this.getChgAuditOriAmt(bill);
            String billStatus = bill.getString("billstatus");
            String billType = bill.getString("billtype");
            DynamicObject changeReason = bill.getDynamicObject("changereason");
            Long refBillId = bill.getLong("refbillid");
            row.set("id", (Object)refBillId);
            row.set("id", (Object)bill.getLong("billid"));
            row.set("entry_billstatus", (Object)bill.getString("billstatus"));
            row.set("entry_bizstatusp", (Object)bill.getString("bizstatus"));
            row.set("entry_bizdate", (Object)bill.getDate("bizdate"));
            row.set("entry_chgtype", (Object)billType);
            row.set("entry_billno", (Object)bill.getString("number"));
            row.set("entry_changereason", (Object)changeReason);
            row.set("entry_handler", (Object)bill.getDynamicObject("handler"));
            if (BillStatusEnum.AUDITTED.getValue().equals(billStatus)) {
                row.set("entry_applyoriamt", (Object)oriAmt);
            } else {
                row.set("entry_applyoriamt", (Object)applyOriAmt);
            }
            if (0L != refBillId) {
                DynamicObject cfmBill = (DynamicObject)cfmMap.get(refBillId);
                if (null != cfmBill) {
                    row.set("entry_chgcfmbillno", (Object)cfmBill.getString("billno"));
                    row.set("entry_chgcfmbillid", (Object)cfmBill.getString("id"));
                    row.set("entry_chgcfmbillstatus", (Object)cfmBill.getString("billstatus"));
                    if (BillStatusEnum.AUDITTED.getValue().equals(cfmBill.getString("billstatus"))) {
                        row.set("entry_oriamt", (Object)this.getConCfmOriAmt(cfmBill));
                        totalconchgamt = NumberUtil.add((Object)totalconchgamt, (Object)this.getConCfmOriAmt(cfmBill));
                    } else {
                        row.set("entry_oriamt", (Object)cfmBill.getBigDecimal("applyoriamt"));
                        if (BillStatusEnum.AUDITTED.getValue().equals(billStatus)) {
                            totalconchgamt = NumberUtil.add((Object)totalconchgamt, (Object)applyOriAmt);
                        }
                    }
                }
            } else if (BillStatusEnum.AUDITTED.getValue().equals(billStatus)) {
                totalconchgamt = NumberUtil.add((Object)totalconchgamt, (Object)oriAmt);
            }
            conChgEntryCol.add((Object)row);
        }
        for (Map.Entry billData : notChgAuditcfmMap.entrySet()) {
            DynamicObject value = (DynamicObject)billData.getValue();
            DynamicObject row = new DynamicObject(conChgEntryCol.getDynamicObjectType());
            row.set("entry_chgcfmbillid", (Object)value.getString("id"));
            row.set("entry_chgcfmbillno", (Object)value.getString("billno"));
            row.set("entry_bizdate", (Object)value.getDate("bizdate"));
            row.set("entry_chgtype", (Object)value.getString("chgtype"));
            row.set("entry_handler", (Object)value.getDynamicObject("handler"));
            row.set("entry_chgcfmbillstatus", (Object)value.getString("billstatus"));
            if (BillStatusEnum.AUDITTED.getValue().equals(value.getString("billstatus"))) {
                row.set("entry_oriamt", (Object)this.getConCfmOriAmt(value));
                totalconchgamt = NumberUtil.add((Object)totalconchgamt, (Object)this.getConCfmOriAmt(value));
            } else {
                row.set("entry_oriamt", (Object)value.getBigDecimal("applyoriamt"));
            }
            conChgEntryCol.add((Object)row);
        }
        conChgEntryCol.sort(Comparator.comparing(chgObj -> chgObj.getDate("entry_bizdate")).reversed());
        BigDecimal estChgOriAmt = BigDecimal.ZERO;
        BigDecimal estChgOriBalanceAmt = BigDecimal.ZERO;
        estChgOriAmt = contractBill.getBigDecimal("estchgoriamt");
        Map<String, BigDecimal> conChgAmt = this.getChgAmt(conId);
        BigDecimal chgAmountSum = conChgAmt.get("oriamt");
        estChgOriBalanceAmt = NumberUtil.subtract((Object)estChgOriAmt, (Object)chgAmountSum);
        model.setValue("oriamt", (Object)totalconchgamt);
        model.setValue("estchgoriamt", (Object)estChgOriAmt);
        model.setValue("estchgoribalance", (Object)estChgOriBalanceAmt);
        model.setValue("oricurrency", contractBill.get("oricurrency"));
        this.getView().updateView("billentry");
    }

    protected String getChgCfmSelect() {
        return String.join((CharSequence)",", "id", "bizdate", "billstatus", "billno", "billname", "oriamt", "applyoriamt", "chgaudit", "chgtype", "oricurrency", "handler");
    }

    protected BigDecimal getConCfmOriAmt(DynamicObject cfmBill) {
        return cfmBill.getBigDecimal("oriamt");
    }

    protected BigDecimal getChgAuditOriAmt(DynamicObject bill) {
        return bill.getBigDecimal("oriamt");
    }

    protected String getChgAuditSelect() {
        return String.join((CharSequence)",", "billid", "bizdate", "billstatus", "bizstatus", "number", "name", "oriamt", "applyoriamt", "changereason", "refbillid", "billtype", "oricurrency", "handler");
    }

    protected Map<String, BigDecimal> getChgAmt(long conId) {
        return new ChgBillHelper().getChgAmtIncSupply(this.getAppId(), conId, true, null);
    }

    @Override
    protected BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billentry");
        DynamicObject curRow = (DynamicObject)rows.get(event.getRowIndex());
        String billId = curRow.getString("id");
        String chgauditbillstatus = curRow.getString("entry_billstatus");
        String chgcfmbillstatus = curRow.getString("entry_chgcfmbillstatus");
        BillShowParameter showParameter = new BillShowParameter();
        Long userId = RequestContext.get().getCurrUserId();
        Long orgId = Long.parseLong(String.valueOf(((DynamicObject)this.getView().getParentView().getModel().getValue("org")).getPkValue()));
        String entityNumber = "";
        String entityName = "";
        if ("entry_billno".equals(fieldName)) {
            showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conchgbill"));
            entityNumber = "conchgbill";
            entityName = ResManager.loadKDString((String)"\u53d8\u66f4\u7533\u8bf7", (String)"ConChgBill4CCFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]);
        } else if ("entry_chgcfmbillno".equals(fieldName)) {
            billId = curRow.getString("entry_chgcfmbillid");
            showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"));
            entityNumber = "chgcfmbill";
            entityName = ResManager.loadKDString((String)"\u53d8\u66f4\u786e\u8ba4", (String)"ConChgBill4CCFormPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]);
        }
        boolean hasPerm = PermissionUtil.checkPermissionById((String)"47150e89000000ac", (Long)userId, (Long)orgId, (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)entityNumber));
        if (!hasPerm) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u65e0\"%s\"\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ConChgBill4CCFormPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]), entityName), "", MessageTypes.Permission);
            return null;
        }
        if (BillStatusEnum.SAVED.getValue().equals(chgauditbillstatus) || BillStatusEnum.SAVED.getValue().equals(chgcfmbillstatus)) {
            showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.EDIT.getValue()));
        } else {
            showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)billId);
        return showParameter;
    }
}

