/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;
import org.apache.commons.lang.StringUtils;

public class ConReviseBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadConReviseBillData(conId);
    }

    protected void loadConReviseBillData(Object conId) {
        IDataModel model = this.getModel();
        String select = String.join((CharSequence)",", "id", "revisedate", "billstatus", "billno", "version", "revisereason", "handler");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", conId));
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "oricurrency", "currency"));
        model.setValue("oricurrency", (Object)contractBill.getDynamicObject("oricurrency"));
        model.setValue("currency", (Object)contractBill.getDynamicObject("oricurrency"));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]), (String)"version DESC");
        model.deleteEntryData("billentry");
        int length = bills.length;
        if (0 == length) {
            return;
        }
        model.batchCreateNewEntryRow("billentry", length);
        DynamicObjectCollection rows = model.getEntryEntity("billentry");
        String lastVersion = "";
        for (int i = 0; i < length; ++i) {
            DynamicObject bill = bills[i];
            String status = bill.getString("billstatus");
            if (StringUtils.isBlank((String)lastVersion) && BillStatusEnum.AUDITTED.getValue().equals(status)) {
                lastVersion = bill.getString("version");
            }
            DynamicObject row = (DynamicObject)rows.get(i);
            row.set("id", (Object)bill.getLong("id"));
            row.set("entry_bizdate", (Object)bill.getDate("revisedate"));
            row.set("entry_billstatus", (Object)status);
            row.set("entry_billno", (Object)bill.getString("billno"));
            row.set("entry_reason", (Object)bill.getString("revisereason"));
            row.set("entry_version", (Object)bill.getString("version"));
            row.set("entry_handler", (Object)bill.getDynamicObject("handler"));
        }
        model.setValue("latestversion", (Object)lastVersion);
        model.setValue("revisetime", (Object)length);
        this.getView().updateView("billentry");
    }
}

