/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.supplier.SupplierUtil;

public class ContractBill4CCFormPlugin
extends AbstractFormPlugin {
    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSupplierName();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Optional.ofNullable(this.getView().getFormShowParameter()).map(FormShowParameter::getCustomParams).map(m -> m.get("contractbill")).ifPresent(id -> this.createSonViewFormParentView(id));
    }

    public void createSonViewFormParentView(Object id) {
        QFilter qFilter = new QFilter("contractbill", "=", id);
        DynamicObject conPayPlanId = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (conPayPlanId == null) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setParentFormId(id.toString());
        billShowParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conpayplan"));
        billShowParameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("tabconpayplancha");
        billShowParameter.setOpenStyle(openStyle);
        billShowParameter.setPkId(conPayPlanId.getPkValue());
        billShowParameter.setCustomParam("contractbill", id);
        billShowParameter.setCustomParam("parentPage", (Object)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill_cc"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    protected void initSupplierName() {
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handleContractSupplierName((String)entityName, (DynamicObject)this.getModel().getDataEntity(true), null);
    }
}

