/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.concs.common.constant.OperationConst;
import kd.pccs.concs.common.entity.ChgCfmBillConst;
import kd.pccs.concs.common.entity.ConChgBillConst;
import kd.pccs.concs.common.entity.ConReviseBillConst;
import kd.pccs.concs.common.entity.ConSettleBillConst;
import kd.pccs.concs.common.entity.EstChgAdjustBillConst;
import kd.pccs.concs.common.entity.InvoiceBillConst;
import kd.pccs.concs.common.entity.PayReqBillConst;
import kd.pccs.concs.common.entity.RewardDeductBillConst;
import kd.pccs.concs.common.entity.StageSettleBillConst;
import kd.pccs.concs.common.entity.SupplyConBillConst;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.contractcenter.CcOpParam;

public class ContractCenterListHelper {
    protected AbstractListPlugin plugin;
    protected IFormView view;
    protected Long mainOrgId;
    protected Long userId;
    protected static Map<String, CcOpParam> opEntityMap = new HashMap<String, CcOpParam>();

    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.view);
    }

    public ContractCenterListHelper(AbstractListPlugin plugin) {
        this.plugin = plugin;
        this.view = plugin.getView();
        List selectedMainOrgIds = ((IListView)this.view).getSelectedMainOrgIds();
        this.mainOrgId = null != selectedMainOrgIds && selectedMainOrgIds.size() > 0 ? (Long)selectedMainOrgIds.get(0) : Long.valueOf(RequestContext.get().getOrgId());
        this.userId = RequestContext.get().getCurrUserId();
    }

    public void checkBeforeDoContractOperation(BeforeDoOperationEventArgs args, Long mainOrgId) {
        String operationKey;
        if (mainOrgId == null) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        Long userId = UserServiceHelper.getCurrentUserId();
        String permissionId = "";
        String permissionName = "";
        switch (operationKey = formOperate.getOperateKey()) {
            case "new": {
                permissionId = "47156aff000000ac";
                permissionName = OperationConst.NEW_ALIAS;
                break;
            }
            case "submit": {
                permissionId = "804f6478000000ac";
                permissionName = OperationConst.SUBMIT_ALIAS;
                break;
            }
            case "unsubmit": {
                permissionId = "80513207000000ac";
                permissionName = OperationConst.UNSUBMIT_ALIAS;
                break;
            }
            case "audit": {
                permissionId = "47162f66000000ac";
                permissionName = OperationConst.AUDIT_ALIAS;
                break;
            }
            case "unaudit": {
                permissionId = "47165e8e000000ac";
                permissionName = OperationConst.UNAUDIT_ALIAS;
                break;
            }
            case "delete": {
                permissionId = "4715e1f1000000ac";
                permissionName = OperationConst.DELETE_ALIAS;
                break;
            }
        }
        if (!PermissionUtil.checkPermissionById((String)permissionId, (Long)userId, (Long)mainOrgId, (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"))) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709[\u5408\u540c\u7b7e\u8ba2]\u7684[%s]\u6743\u9650,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]), permissionName));
            args.setCancel(true);
        }
    }

    public void checkBeforeDoOperation(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CcOpParam opParam = opEntityMap.get(operateKey);
        if (null == opParam) {
            return;
        }
        this.checkSelected(args, selectRow);
        this.checkOpPermissionCheck(args, opParam);
        switch (operateKey) {
            case "conrevisebill": {
                this.checkBeforeDoConReviseBill(args, selectRow);
                break;
            }
            case "estchgadjustbill": {
                this.checkBeforeDoEstChgAdjust(args, selectRow);
                break;
            }
            case "supplyconbill": {
                this.checkBeforeDoSupplyConBill(args, selectRow);
                break;
            }
            case "conchgbill": {
                this.checkBeforeDoConChgBill(args, selectRow);
                break;
            }
            case "chgcfmbill": {
                this.checkBeforeDoChgCfmBill(args, selectRow);
                break;
            }
            case "stagesettlebill": {
                this.checkBeforeDoStageSettleBill(args, selectRow);
                break;
            }
            case "consettlebill": {
                this.checkBeforeDoConSettleBill(args, selectRow);
                break;
            }
            case "payreqbill": {
                break;
            }
            case "invoicebill": {
                break;
            }
            case "rewarddeductbill": {
                break;
            }
        }
    }

    protected void checkBeforeDoConReviseBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        Object conId = selectRow.getPrimaryKeyValue();
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"conrevisebill"), (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", conId)})) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u72b6\u6001\u7684\u5408\u540c\u4fee\u8ba2\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoStageSettleBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoChgCfmBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoConChgBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoSupplyConBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoConSettleBill(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        this.checkHasSettle(args, selectRow);
    }

    protected void checkBeforeDoEstChgAdjust(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        Object conId = selectRow.getPrimaryKeyValue();
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill"), (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", conId)})) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6279\u7684\u9884\u4f30\u53d8\u66f4\u8c03\u6574\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.checkHasSettle(args, selectRow);
    }

    protected void checkOpPermissionCheck(BeforeDoOperationEventArgs args, CcOpParam opParam) {
        if (!PermissionUtil.checkPermissionById((String)opParam.opPermId, (Long)this.userId, (Long)this.mainOrgId, (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)opParam.entityName))) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u7684%2$s\u6743\u9650,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]), opParam.entityAlias, opParam.opPermName));
            args.setCancel(true);
            return;
        }
    }

    protected void checkSelected(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        if (null == selectRow) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u5408\u540c,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_4", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billstatus = selectRow.getBillStatus();
        if (!BillStatusEnum.AUDITTED.getValue().equals(billstatus)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u672a\u5ba1\u6838,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_5", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected void checkHasSettle(BeforeDoOperationEventArgs args, ListSelectedRow selectRow) {
        Object conId = selectRow.getPrimaryKeyValue();
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", conId)})) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5b58\u5728\u672a\u5ba1\u6279\u7684\u7ed3\u7b97\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_6", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", conId)})) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u7ed3\u7b97,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c!", (String)"ContractCenterListHelper_7", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected static CcOpParam getCcOpParam(String entityId, String entityAlias, String opPermId, String opPermName, OperationStatus opStatus) {
        return new CcOpParam(entityId, entityAlias, opPermId, opPermName, opStatus);
    }

    static {
        opEntityMap.put("conrevisebill", new CcOpParam("conrevisebill", ConReviseBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("supplyconbill", new CcOpParam("supplyconbill", SupplyConBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("conchgbill", new CcOpParam("conchgbill", ConChgBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("chgcfmbill", new CcOpParam("chgcfmbill", ChgCfmBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("payreqbill", new CcOpParam("payreqbill", PayReqBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("invoicebill", new CcOpParam("invoicebill", InvoiceBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("stagesettlebill", new CcOpParam("stagesettlebill", StageSettleBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("consettlebill", new CcOpParam("consettlebill", ConSettleBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("estchgadjustbill", new CcOpParam("estchgadjustbill", EstChgAdjustBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
        opEntityMap.put("rewarddeductbill", new CcOpParam("rewarddeductbill", RewardDeductBillConst.ENTITY_NAME_ALIAS, "47156aff000000ac", OperationConst.NEW_ALIAS, OperationStatus.ADDNEW));
    }
}

