/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.contractbill.ContractBillListPlugin;
import kd.pccs.concs.formplugin.contractcenter.CcOpParam;
import kd.pccs.concs.formplugin.contractcenter.ContractCenterListHelper;

public class ContractCenterListPlugin
extends ContractBillListPlugin {
    protected ContractCenterListHelper listHelper;

    public void initialize() {
        super.initialize();
        this.initListHelper();
    }

    protected void initListHelper() {
        if (null == this.listHelper) {
            this.listHelper = new ContractCenterListHelper(this);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Donothing) {
            this.listHelper.checkBeforeDoOperation(args, this.getselectedRow());
        } else if (!(formOperate instanceof Refresh)) {
            ListSelectedRow selectedRow;
            formOperate.setEntityId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
            Long mainOrgId = null;
            mainOrgId = this.getSelectedMainOrgIds() != null && this.getSelectedMainOrgIds().size() == 1 ? (Long)this.getSelectedMainOrgIds().get(0) : ((selectedRow = this.getselectedRow()) == null ? null : Long.valueOf(selectedRow.getMainOrgId()));
            this.listHelper.checkBeforeDoContractOperation(args, mainOrgId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (!(formOperate instanceof Donothing)) {
            ListSelectedRow selectRow = this.getselectedRow();
            if (null != selectRow && "modify".equals(operateKey)) {
                MutexHelper.release((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractcenter"), (String)"modify", (String)selectRow.getPrimaryKeyValue().toString());
            }
            return;
        }
        CcOpParam opParam = ContractCenterListHelper.opEntityMap.get(operateKey);
        if (null == opParam) {
            return;
        }
        this.doOperation(opParam);
    }

    protected void doOperation(CcOpParam opParam) {
        ListSelectedRow selectRow;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)opParam.entityName));
        showParameter.setCaption(opParam.entityAlias);
        showParameter.setStatus(opParam.opStatus);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.setShowParameter4Operation(showParameter);
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds != null && selectedMainOrgIds.size() == 1) {
            showParameter.setCustomParam("SELECT_ORG_ID", (Object)((Long)selectedMainOrgIds.get(0)).toString());
        }
        if (null != (selectRow = this.getselectedRow())) {
            showParameter.setCustomParam("contractbill", selectRow.getPrimaryKeyValue());
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        if (OperationUtil.isAddNewOp((BillOperationStatus)billStatus) || OperationUtil.isEditOp((BillOperationStatus)billStatus) || OperationUtil.isSubmitOp((BillOperationStatus)billStatus)) {
            if (OperationUtil.isEditOp((BillOperationStatus)billStatus)) {
                ListSelectedRow selectedRow;
                Long mainOrgId;
                Long userId = UserServiceHelper.getCurrentUserId();
                if (PermissionUtil.checkPermissionById((String)"4715a0df000000ac", (Long)userId, (Long)(mainOrgId = Long.valueOf((selectedRow = this.getselectedRow()).getMainOrgId())), (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"))) {
                    parameter.setStatus(OperationStatus.EDIT);
                } else {
                    parameter.setStatus(OperationStatus.VIEW);
                }
            }
            parameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
            parameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2", (String)"ContractCenterListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        }
    }

    protected void setShowParameter4Operation(BillShowParameter showParameter) {
        showParameter.setAppId(this.getAppId());
    }
}

