/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.base.AbstractTabSelectListener;
import org.apache.commons.lang.StringUtils;

public class ContractCenterTabSelectListener
extends AbstractTabSelectListener {
    public ContractCenterTabSelectListener(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void registerListener(Tab tabCtrl) {
        tabCtrl.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (StringUtils.isBlank((String)tabKey)) {
            return;
        }
        String entityName = tabKey.substring(tabKey.indexOf(95) + 1);
        Long contractBillId = (Long)this.getModel().getDataEntity().getPkValue();
        String subFormId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)entityName) + "_cc";
        this.openSubPage(tabKey, tabKey, subFormId, contractBillId);
    }

    protected void openSubPage(String tabKey, String tabContentPanel, String subFormId, Long contractBillId) {
        BillShowParameter showParameter;
        if ("tabpap_contractbill".equals(tabKey) || "tabpap_consettlebill".equals(tabKey)) {
            showParameter = new BillShowParameter();
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            String subBillPkId = this.getPageCache().get(tabKey + "_PK");
            if (StringUtils.isNotEmpty((String)subBillPkId)) {
                showParameter.setPkId((Object)Long.parseLong(subBillPkId));
            }
        } else {
            showParameter = new FormShowParameter();
        }
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId(subFormId);
        showParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(tabContentPanel);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("contractbill", (Object)contractBillId);
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put(tabKey, showParameter.getPageId());
    }
}

