/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class EstChgAdjustBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadBillData(conId);
    }

    protected void loadBillData(Long contractBillId) {
        IDataModel model = this.getModel();
        BigDecimal totalEstChgOriamt = BigDecimal.ZERO;
        String selectCon = String.join((CharSequence)",", "oricurrency", "estchgoriamt", "hassettled", "estsettleoriamt");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)selectCon);
        String select = String.join((CharSequence)",", "id", "bizdate", "billstatus", "billno", "oricurrency", "srcoriamt", "adjustoriamt", "estsettleoriamt", "oriamt", "handler");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", (Object)contractBillId));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"estchgadjustbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]), (String)"bizdate desc");
        model.deleteEntryData("billentry");
        DynamicObjectCollection rows = model.getEntryEntity("billentry");
        DynamicObjectType entryType = rows.getDynamicObjectType();
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            if (BillStatusEnum.AUDITTED.getValue().equals(bill.getString("billstatus"))) {
                totalEstChgOriamt = NumberUtil.add((Object)totalEstChgOriamt, (Object)bill.getBigDecimal("adjustoriamt"));
            }
            DynamicObject row = new DynamicObject(entryType);
            row.set("id", (Object)bill.getLong("id"));
            row.set("entry_bizdate", (Object)bill.getDate("bizdate"));
            row.set("entry_billstatus", (Object)bill.getString("billstatus"));
            row.set("entry_billno", (Object)bill.getString("billno"));
            row.set("entry_applyoriamt", (Object)bill.getBigDecimal("srcoriamt"));
            row.set("entry_adjustoriamt", (Object)bill.getBigDecimal("adjustoriamt"));
            row.set("entry_estsettleoriamt", (Object)bill.getBigDecimal("estsettleoriamt"));
            row.set("entry_oriamt", (Object)bill.getBigDecimal("oriamt"));
            row.set("entry_handler", (Object)bill.getDynamicObject("handler"));
            rows.add((Object)row);
        }
        this.getView().updateView("billentry");
        model.setValue("oriamt", (Object)contract.getBigDecimal("estchgoriamt"));
        model.setValue("oricurrency", (Object)contract.getDynamicObject("oricurrency"));
        if (contract.getBoolean("hassettled")) {
            ArrayList<QFilter> settleFilter = new ArrayList<QFilter>();
            settleFilter.add(new QFilter("contractbill", "=", (Object)contract.getLong("id")));
            DynamicObject conSettle = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"consettlebill"), (String)String.join((CharSequence)",", "oriamt"), (QFilter[])settleFilter.toArray(new QFilter[filter.size()]));
            BigDecimal settleOriAmt = conSettle.getBigDecimal("oriamt");
            model.setValue("estsettleoriamt", (Object)settleOriAmt);
        } else {
            model.setValue("estsettleoriamt", (Object)contract.getBigDecimal("estsettleoriamt"));
        }
    }
}

