/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class InvoiceBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadInvoiceBillData(conId);
    }

    protected void loadInvoiceBillData(Object conId) {
        IDataModel model = this.getModel();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal noTaxAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        String select = String.join((CharSequence)",", "id", "bizdate", "billstatus", "purorg", "saleorg", "hasreceipt", "invoicecode", "invoiceno", "amount", "tax", "notaxamt");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", conId));
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "oricurrency", "currency"));
        model.setValue("oricurrency", (Object)contractBill.getDynamicObject("oricurrency"));
        model.setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]), (String)"bizdate DESC");
        model.deleteEntryData("billentry");
        int length = bills.length;
        if (length > 0) {
            model.batchCreateNewEntryRow("billentry", length);
            DynamicObjectCollection rows = model.getEntryEntity("billentry");
            for (int i = 0; i < length; ++i) {
                DynamicObject bill = bills[i];
                BigDecimal curAmt = bill.getBigDecimal("amount");
                BigDecimal curNoTaxAmt = bill.getBigDecimal("notaxamt");
                BigDecimal curTax = bill.getBigDecimal("tax");
                if (BillStatusEnum.AUDITTED.getValue().equals(bill.getString("billstatus"))) {
                    amount = NumberUtil.add((Object)amount, (Object)curAmt);
                    noTaxAmt = NumberUtil.add((Object)noTaxAmt, (Object)curNoTaxAmt);
                    tax = NumberUtil.add((Object)tax, (Object)curTax);
                }
                DynamicObject row = (DynamicObject)rows.get(i);
                row.set("id", (Object)bill.getLong("id"));
                row.set("entry_bizdate", (Object)bill.getDate("bizdate"));
                row.set("entry_billstatus", (Object)bill.getString("billstatus"));
                row.set("entry_purorg", (Object)bill.getDynamicObject("purorg"));
                row.set("entry_saleorg", (Object)bill.getDynamicObject("saleorg"));
                row.set("entry_invoicecode", (Object)bill.getString("invoicecode"));
                row.set("entry_billno", (Object)bill.getString("invoiceno"));
                row.set("entry_hasreceipt", (Object)bill.getBoolean("hasreceipt"));
                row.set("entry_tax", (Object)curTax);
                row.set("entry_notaxamt", (Object)curNoTaxAmt);
                row.set("entry_amount", (Object)curAmt);
            }
            this.getView().updateView("billentry");
        }
        model.setValue("amount", (Object)amount);
        model.setValue("notaxamt", (Object)noTaxAmt);
        model.setValue("tax", (Object)tax);
    }
}

