/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class PayReqBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadPayReqData(conId);
    }

    protected void loadPayReqData(Object contractId) {
        IDataModel model = this.getModel();
        model.deleteEntryData("billentry");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)"oricurrency");
        model.setValue("oricurrency", (Object)contract.getDynamicObject("oricurrency"));
        DynamicObject[] payReqBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)this.getPayReqSelector(), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractId)});
        BigDecimal reqAmt = NumberUtil.ZERO;
        BigDecimal payConAmt = NumberUtil.ZERO;
        BigDecimal payAmt = NumberUtil.ZERO;
        DynamicObjectCollection rows = model.getEntryEntity("billentry");
        DynamicObjectType entryType = rows.getDynamicObjectType();
        for (int i = 0; i < payReqBills.length; ++i) {
            DynamicObject bill = payReqBills[i];
            DynamicObject[] paymentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", "id", "billno", "entry", "e_corebillentryseq", "e_actamt"), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bill.getPkValue()), new QFilter("billstatus", "=", (Object)"D")});
            if (paymentBills.length > 0) {
                for (int j = 0; j < paymentBills.length; ++j) {
                    DynamicObject paybill = paymentBills[j];
                    DynamicObject row = j == 0 ? this.getRowData(bill, entryType) : new DynamicObject(entryType);
                    DynamicObjectCollection entrys = paybill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        int seq = entry.getInt("e_corebillentryseq");
                        if (seq == 1 || seq == 2) {
                            row.set("entry_payedconoriamt", (Object)NumberUtil.add((Object)row.get("entry_payedconoriamt"), (Object)entry.get("e_actamt")));
                        }
                        row.set("entry_payedoriamt", (Object)NumberUtil.add((Object)row.get("entry_payedoriamt"), (Object)entry.get("e_actamt")));
                    }
                    row.set("entry_payid", paybill.get("id"));
                    row.set("entry_paynum", paybill.get("billno"));
                    rows.add((Object)row);
                }
            } else {
                DynamicObject row = this.getRowData(bill, entryType);
                rows.add((Object)row);
            }
            if (!BillStatusEnum.AUDITTED.getValue().equals(bill.get("billstatus"))) continue;
            reqAmt = NumberUtil.add((Object)reqAmt, (Object)bill.get("oriamt"));
            payAmt = NumberUtil.add((Object)payAmt, (Object)bill.get("payedoriamt"));
            payConAmt = NumberUtil.add((Object)payConAmt, (Object)bill.get("payedconoriamt"));
        }
        this.getView().updateView("billentry");
        model.setValue("oriamt", (Object)reqAmt);
        model.setValue("payedoriamt", (Object)payAmt);
        model.setValue("payedconoriamt", (Object)payConAmt);
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)"latestoriprice");
        BigDecimal latestoriPrice = contractBill.getBigDecimal("latestoriprice");
        model.setValue("reqscale", (Object)NumberUtil.multiply((Object)NumberUtil.divide((Object)reqAmt, (Object)latestoriPrice, (int)4), (Object)NumberUtil.ONE_HUNDRED));
        model.setValue("payscale", (Object)NumberUtil.multiply((Object)NumberUtil.divide((Object)payAmt, (Object)latestoriPrice, (int)4), (Object)NumberUtil.ONE_HUNDRED));
    }

    protected DynamicObject getRowData(DynamicObject bill, DynamicObjectType entryType) {
        DynamicObject row = new DynamicObject(entryType);
        row.set("entry_billid", bill.get("id"));
        row.set("entry_bizdate", bill.get("bizdate"));
        row.set("entry_billstatus", bill.get("billstatus"));
        row.set("entry_paytype", bill.get("paymenttype"));
        row.set("entry_billno", bill.get("billno"));
        row.set("entry_receiveunit", bill.get("receiveunit"));
        row.set("entry_handler", bill.get("handler"));
        row.set("entry_applyoriamt", bill.get("oriamt"));
        return row;
    }

    @Override
    protected BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent arg0) {
        Long orgId;
        Long userId;
        Boolean hasModifyPerm;
        String fieldName = arg0.getFieldName();
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billentry");
        DynamicObject curRow = (DynamicObject)rows.get(arg0.getRowIndex());
        String billId = null;
        String status = null;
        String formId = null;
        if ("entry_billno".equals(fieldName)) {
            billId = curRow.getString("entry_billid");
            status = curRow.getString("entry_billstatus");
            formId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e", (String)"PayReqBill4CCFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        } else {
            billId = curRow.getString("entry_payid");
            formId = "cas_paybill";
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)billId);
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        showParameter.setAppId(this.getAppId());
        if ("entry_billno".equals(fieldName) && BillStatusEnum.SAVED.getValue().equals(status) && (hasModifyPerm = Boolean.valueOf(PermissionUtil.checkPermissionById((String)"4715a0df000000ac", (Long)(userId = Long.valueOf(RequestContext.get().getCurrUserId())), (Long)(orgId = Long.valueOf(RequestContext.get().getOrgId())), (String)"concs", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill")))).booleanValue()) {
            showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        }
        return showParameter;
    }

    protected String getPayReqSelector() {
        return String.join((CharSequence)",", "id", "bizdate", "billstatus", "billno", "paymenttype", "oricurrency", "oriamt", "receiveunit", "handler", "payedconoriamt", "payedoriamt", "receiveunit");
    }
}

