/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.DeductPropertyEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class RewardDeductBill4CCPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeductbill");
    }

    @Override
    protected void loadData(Long conId) {
        this.load(conId);
    }

    protected void load(Object conObj) {
        Long conId = Long.valueOf(conObj.toString());
        Object[] rewardDeductbills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeductbill"), (String)String.join((CharSequence)",", "billno", "bizdate", "entry_contractbill", "entry_payitem", String.join((CharSequence)".", "entry_payitem", "deductproperty"), "billstatus", "entry_supplier", "entry_oriamt", "entry_amount", "entry_currency", "entry_oricurrency", "handler"), (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "rewarddeductentry", "entry_contractbill"), "=", (Object)conId)}, (String)"bizdate desc");
        if (ArrayUtils.isEmpty((Object[])rewardDeductbills)) {
            return;
        }
        this.loadBaseData(conId, (DynamicObject[])rewardDeductbills);
        this.loadEntry(conId, (DynamicObject[])rewardDeductbills);
    }

    protected void loadBaseData(Long conId, DynamicObject[] rewardDeductbills) {
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "oricurrency", "currency"));
        this.getModel().setValue("oricurrency", (Object)contractBill.getDynamicObject("oricurrency"));
        Set auditedBills = Arrays.stream(rewardDeductbills).filter(r -> BillStatusEnum.AUDITTED.getValue().equals(r.getString("billstatus"))).collect(Collectors.toSet());
        BigDecimal outAmt = BigDecimal.ZERO;
        BigDecimal inAmt = BigDecimal.ZERO;
        for (DynamicObject bill : auditedBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("rewarddeductentry");
            outAmt = entrys.stream().filter(entry -> conId.equals(entry.getDynamicObject("entry_contractbill").getPkValue())).filter(entry -> DeductPropertyEnum.ADD.getValue().equals(entry.getDynamicObject("entry_payitem").getString("deductproperty"))).map(entry -> entry.getBigDecimal("entry_oriamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).add(outAmt);
            inAmt = entrys.stream().filter(entry -> conId.equals(entry.getDynamicObject("entry_contractbill").getPkValue())).filter(entry -> DeductPropertyEnum.SUBTRACT.getValue().equals(entry.getDynamicObject("entry_payitem").getString("deductproperty"))).map(entry -> entry.getBigDecimal("entry_oriamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).add(inAmt);
        }
        this.getModel().setValue("outamt", (Object)outAmt);
        this.getModel().setValue("inamt", (Object)inAmt);
    }

    protected void loadEntry(Long conId, DynamicObject[] rewardDeductbills) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
        entrys.clear();
        Arrays.stream(rewardDeductbills).forEach(bill -> {
            DynamicObjectCollection srcEntrys = bill.getDynamicObjectCollection("rewarddeductentry");
            if (null != srcEntrys && srcEntrys.size() > 0) {
                boolean refFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (QFilter[])new QFilter[]{new QFilter("refbillid", "!=", (Object)0L), new QFilter("billId", "=", bill.getPkValue())});
                srcEntrys.stream().filter(srcEntry -> null != srcEntry.getDynamicObject("entry_contractbill")).filter(srcEntry -> conId.equals(srcEntry.getDynamicObject("entry_contractbill").getPkValue())).forEach(srcEntry -> {
                    DynamicObject entry = entrys.addNew();
                    entry.set("entry_billstatus", (Object)bill.getString("billstatus"));
                    entry.set("entry_bizdate", (Object)bill.getDate("bizdate"));
                    entry.set("entry_billno", (Object)bill.getString("billno"));
                    entry.set("entry_handler", (Object)bill.getDynamicObject("handler"));
                    entry.set("entry_payitem", (Object)srcEntry.getDynamicObject("entry_payitem"));
                    entry.set("entry_supplier", (Object)srcEntry.getDynamicObject("entry_supplier"));
                    entry.set("entry_haspayreq", (Object)(refFlag ? 1 : 0));
                    entry.set("entry_billid", bill.getPkValue());
                    DynamicObject payItem = srcEntry.getDynamicObject("entry_payitem");
                    BigDecimal oriAmt = srcEntry.getBigDecimal("entry_oriamt");
                    if (null != payItem) {
                        String payType = srcEntry.getDynamicObject("entry_payitem").getString("deductproperty");
                        entry.set("entry_paytype", (Object)payType);
                    }
                    entry.set("entry_oriamt", (Object)oriAmt);
                });
            }
        });
    }

    @Override
    protected BillShowParameter getHyperLinkClickShowParameter(HyperLinkClickEvent e) {
        Long orgId;
        Long userId;
        Boolean hasModifyPerm;
        int rowIndex = e.getRowIndex();
        String status = this.getModel().getValue("entry_billstatus", rowIndex).toString();
        String billId = this.getModel().getValue("entry_billid", rowIndex).toString();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeductbill"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)billId);
        showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.VIEW.getValue()));
        if (BillStatusEnum.SAVED.getValue().equals(status) && (hasModifyPerm = Boolean.valueOf(PermissionUtil.checkPermissionById((String)"4715a0df000000ac", (Long)(userId = Long.valueOf(RequestContext.get().getCurrUserId())), (Long)(orgId = Long.valueOf(RequestContext.get().getOrgId())), (String)this.getAppId(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeductbill")))).booleanValue()) {
            showParameter.setBillStatusValue(Integer.valueOf(OperationStatus.EDIT.getValue()));
        }
        return showParameter;
    }
}

