/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class StageSettleBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"stagesettlebill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadBillData(conId);
    }

    protected void loadBillData(Long contractBillId) {
        IDataModel model = this.getModel();
        BigDecimal totalSettleOriAmt = BigDecimal.ZERO;
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "latestoriprice", "oricurrency"));
        String select = String.join((CharSequence)",", "id", "bizdate", "billstatus", "billno", "billname", "oricurrency", "oriamt", "applyoriamt", "handler");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", (Object)contractBillId));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"stagesettlebill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]), (String)"bizdate desc");
        model.deleteEntryData("billentry");
        DynamicObjectCollection rows = model.getEntryEntity("billentry");
        DynamicObjectType entryType = rows.getDynamicObjectType();
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            if (BillStatusEnum.AUDITTED.getValue().equals(bill.getString("billstatus"))) {
                totalSettleOriAmt = NumberUtil.add((Object)totalSettleOriAmt, (Object)bill.getBigDecimal("oriamt"));
            }
            DynamicObject row = new DynamicObject(entryType);
            row.set("id", (Object)bill.getLong("id"));
            row.set("entry_bizdate", (Object)bill.getDate("bizdate"));
            row.set("entry_billstatus", bill.get("billstatus"));
            row.set("entry_billno", bill.get("billno"));
            row.set("entry_billname", bill.get("billname"));
            row.set("entry_oriamt", (Object)bill.getBigDecimal("oriamt"));
            row.set("entry_applyoriamt", (Object)bill.getBigDecimal("applyoriamt"));
            row.set("entry_handler", (Object)bill.getDynamicObject("handler"));
            rows.add((Object)row);
        }
        this.getView().updateView("billentry");
        model.setValue("latestoriprice", (Object)contract.getBigDecimal("latestoriprice"));
        model.setValue("totalsettleoriamt", (Object)totalSettleOriAmt);
        model.setValue("oricurrency", (Object)contract.getDynamicObject("oricurrency"));
    }
}

