/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.contractcenter;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.SuppFormWayEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.contractcenter.AbstractSubBillTpl4CCFormPlugin;

public class SupplyConBill4CCFormPlugin
extends AbstractSubBillTpl4CCFormPlugin {
    @Override
    protected String getDetailFormId(HyperLinkClickEvent event) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"supplyconbill");
    }

    @Override
    protected void loadData(Long conId) {
        this.loadSupplyConBillData(conId);
    }

    protected void loadSupplyConBillData(Object conId) {
        IDataModel model = this.getModel();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal noTaxAmt = BigDecimal.ZERO;
        BigDecimal addSuppAmt = BigDecimal.ZERO;
        BigDecimal chgToSuppAmt = BigDecimal.ZERO;
        String select = String.join((CharSequence)",", "id", "bizdate", "billstatus", "billno", "billname", "oriamt", "tax", "formway", "notaxamt", "handler");
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("contractbill", "=", conId));
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)conId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "oricurrency", "currency"));
        model.setValue("oricurrency", (Object)contractBill.getDynamicObject("oricurrency"));
        model.setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"supplyconbill"), (String)select, (QFilter[])filter.toArray(new QFilter[filter.size()]));
        model.deleteEntryData("billentry");
        int length = bills.length;
        if (length > 0) {
            model.batchCreateNewEntryRow("billentry", length);
            DynamicObjectCollection rows = model.getEntryEntity("billentry");
            for (int i = 0; i < length; ++i) {
                DynamicObject bill = bills[i];
                BigDecimal curAmt = bill.getBigDecimal("oriamt");
                BigDecimal curNoTaxAmt = bill.getBigDecimal("notaxamt");
                if (BillStatusEnum.AUDITTED.getValue().equals(bill.getString("billstatus"))) {
                    amount = NumberUtil.add((Object)amount, (Object)curAmt);
                    noTaxAmt = NumberUtil.add((Object)noTaxAmt, (Object)curNoTaxAmt);
                    if (SuppFormWayEnum.ADDSUPP.getValue().equals(bill.getString("formway"))) {
                        addSuppAmt = NumberUtil.add((Object)addSuppAmt, (Object)curAmt);
                    } else {
                        chgToSuppAmt = NumberUtil.add((Object)chgToSuppAmt, (Object)curAmt);
                    }
                }
                DynamicObject row = (DynamicObject)rows.get(i);
                row.set("id", (Object)bill.getLong("id"));
                row.set("entry_bizdate", (Object)bill.getDate("bizdate"));
                row.set("entry_billstatus", (Object)bill.getString("billstatus"));
                row.set("entry_billname", (Object)bill.getString("billname"));
                row.set("entry_oriamt", (Object)curAmt);
                row.set("entry_handler", (Object)bill.getDynamicObject("handler"));
                row.set("entry_formway", (Object)bill.getString("formway"));
            }
            this.getView().updateView("billentry");
        }
        model.setValue("oriamt", (Object)amount);
        model.setValue("addsupplyamt", (Object)addSuppAmt);
        model.setValue("chgtosupplyamt", (Object)chgToSuppAmt);
    }
}

