/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.estchgadjustbill;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.ContractBillHelper;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;

public class EstChgAdjustBillPropertyChanged
extends AbstractPropertyChanged {
    public EstChgAdjustBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (propertyName = e.getProperty().getName()) {
            case "adjustoriamt": {
                this.adjustOriAmtChanged(newValue, oldValue);
                break;
            }
            case "contractbill": {
                this.contractChanged(newValue, oldValue);
                break;
            }
            case "project": {
                this.projectChanged(newValue, oldValue);
                break;
            }
        }
    }

    protected void contractChanged(Object newValue, Object oldValue) {
        this.setContractNew((DynamicObject)newValue);
    }

    protected void projectChanged(Object newValue, Object oldValue) {
        this.setContractNew(null);
    }

    protected void adjustOriAmtChanged(Object newValue, Object oldValue) {
        DynamicObject model = this.getModel().getDataEntity();
        BigDecimal exchangeRate = (BigDecimal)model.get("exchangerate");
        BigDecimal adjustOriAmt = (BigDecimal)model.get("adjustoriamt");
        BigDecimal srcOriAmt = (BigDecimal)model.get("srcoriamt");
        BigDecimal srcAmt = (BigDecimal)model.get("srcamt");
        DynamicObject contract = model.getDynamicObject("contractbill");
        long conId = contract.getLong("id");
        BigDecimal adjustAmt = exchangeRate.multiply(adjustOriAmt);
        model.set("adjustamt", (Object)adjustAmt);
        this.getView().updateView("adjustamt");
        BigDecimal oriAmt = adjustOriAmt.add(srcOriAmt);
        model.set("oriamt", (Object)oriAmt);
        this.getView().updateView("oriamt");
        BigDecimal amount = adjustAmt.add(srcAmt);
        model.set("amount", (Object)amount);
        this.getView().updateView("amount");
        Map realHasChangeMap = new ContractBillHelper().getConRealHasChange(this.getAppId(), Long.valueOf(conId));
        BigDecimal realOriHasChange = (BigDecimal)realHasChangeMap.get("realOriHasChange");
        Map supplyBalancAmtMap = ContractBillHelper.getConSupplyBalanceAmt((String)this.getAppId(), (long)conId);
        BigDecimal supplyBalanceAmt = (BigDecimal)supplyBalancAmtMap.get("supplyBalancOriAmt");
        BigDecimal conOriAmt = contract.getBigDecimal("oriamt");
        BigDecimal estSettleOriAmt = NumberUtil.add((Object[])new BigDecimal[]{conOriAmt, NumberUtil.max((Object)oriAmt, (Object)realOriHasChange), supplyBalanceAmt});
        model.set("estsettleoriamt", (Object)estSettleOriAmt);
        this.getView().updateView("estsettleoriamt");
        BigDecimal estSettleAmt = estSettleOriAmt.multiply(exchangeRate);
        model.set("estsettleamt", (Object)estSettleAmt);
        this.getView().updateView("estsettleamt");
    }

    protected void setContractNew(DynamicObject contract) {
        DynamicObject model = this.getModel().getDataEntity();
        model.set("contractbill", (Object)contract);
        if (contract == null) {
            model.set("srcoriamt", null);
            model.set("srcamt", null);
            model.set("foreigncurrencyflag", null);
            model.set("exchangerate", null);
            model.set("oricurrency", null);
            model.set("currency", null);
            model.set("adjustoriamt", null);
            model.set("adjustamt", null);
            model.set("applyoriamt", null);
            model.set("applyamt", null);
            model.set("oriamt", null);
            model.set("amount", null);
            model.set("estsettleoriamt", null);
            model.set("estsettleamt", null);
        } else {
            DynamicObject currency;
            DynamicObject oriCurrency = contract.getDynamicObject("oricurrency");
            if (null != oriCurrency) {
                oriCurrency = BusinessDataServiceHelper.loadSingle((Object)oriCurrency.getPkValue(), (String)"bd_currency");
            }
            if (null != (currency = contract.getDynamicObject("currency"))) {
                currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
            }
            model.set("org", (Object)contract.getDynamicObject("org"));
            model.set("project", (Object)contract.getDynamicObject("project"));
            model.set("foreigncurrencyflag", (Object)contract.getBoolean("foreigncurrencyflag"));
            model.set("exchangerate", (Object)contract.getBigDecimal("exchangerate"));
            model.set("currency", (Object)currency);
            model.set("oricurrency", (Object)oriCurrency);
            model.set("adjustoriamt", null);
            model.set("adjustamt", null);
            model.set("srcoriamt", (Object)contract.getBigDecimal("estchgoriamt"));
            model.set("srcamt", (Object)contract.getBigDecimal("estchgamt"));
            model.set("oriamt", (Object)contract.getBigDecimal("estchgoriamt"));
            model.set("amount", (Object)contract.getBigDecimal("estchgamt"));
            model.set("estsettleoriamt", (Object)contract.getBigDecimal("estsettleoriamt"));
            model.set("estsettleamt", (Object)contract.getBigDecimal("estsettleamt"));
        }
        this.getView().updateView();
    }
}

