/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.f7;

import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.formplugin.base.AbstractF7SelectListener;

public class ContractBillF7SelectListener
extends AbstractF7SelectListener {
    public ContractBillF7SelectListener(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super((AbstractFormPlugin)plugin, dataModel);
        this.needCustomF7ViewFlag = true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject project = dataEntity.getDynamicObject("project");
        this.addProjectFilter(project, qFilters);
        qFilters.add(new QFilter("org", "=", (Object)OrgUtil.getCurrentOrgId((DynamicObject)dataEntity)));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
    }

    protected void addProjectFilter(DynamicObject project, List<QFilter> qFilters) {
        if (null != project) {
            qFilters.add(new QFilter("project", "=", project.getPkValue()));
        }
    }

    @Override
    protected String getF7ViewFormId(Object f7Id) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill");
    }
}

