/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.f7;

import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.formplugin.base.AbstractF7SelectListener;

public class InvoiceBillF7SelectListener
extends AbstractF7SelectListener {
    public InvoiceBillF7SelectListener(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super((AbstractFormPlugin)plugin, dataModel);
        this.needCustomF7ViewFlag = true;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject project = dataEntity.getDynamicObject("project");
        if (null != project) {
            QFilter qFilter = new QFilter("project", "=", project.getPkValue());
            qFilter.or(new QFilter("project", "=", (Object)0L));
            qFilters.add(qFilter);
        }
        qFilters.add(new QFilter("org", "=", (Object)OrgUtil.getCurrentOrgId((DynamicObject)dataEntity)));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
        DynamicObject contract = dataEntity.getDynamicObject("contractbill");
        if (null != contract) {
            QFilter qFilter = new QFilter("contractbill", "=", contract.getPkValue());
            qFilter.or(new QFilter("contractbill", "=", (Object)0L));
            qFilters.add(qFilter);
            DynamicObject contractObj = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)"fiaccountorg");
            DynamicObject fiAccountOrg = contractObj.getDynamicObject("fiaccountorg");
            if (null != fiAccountOrg) {
                qFilters.add(new QFilter("accountancyorg", "=", fiAccountOrg.getPkValue()));
            }
        }
    }

    @Override
    protected String getF7ViewFormId(Object f7Id) {
        return MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill");
    }
}

