/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.invoicebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.pccs.concs.business.helper.InvoiceBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.InvoiceTypeEnum;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplFormPlugin;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.OrgF7Selectener;
import kd.pccs.concs.formplugin.f7.PayReqF7SelectListener;
import kd.pccs.concs.formplugin.invoicebill.InvoiceBillPropertyChanged;
import kd.pccs.concs.formplugin.invoicebill.InvoiceBillUtil;

public class InvoiceBillFormPlugin
extends BillOrgTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new InvoiceBillPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerContractBillF7();
        this.registerAccountancyOrgF7();
        this.registerPurOrgF7();
        this.registerPayReqF7();
    }

    protected void registerPayReqF7() {
        new PayReqF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("payreqbill"));
    }

    protected void registerPurOrgF7() {
        new OrgF7Selectener((AbstractFormPlugin)this, this.getModel(), "10").registerListener((BasedataEdit)this.getView().getControl("purorg"));
    }

    protected void registerAccountancyOrgF7() {
        new OrgF7Selectener((AbstractFormPlugin)this, this.getModel(), "10").registerListener((BasedataEdit)this.getView().getControl("accountancyorg"));
    }

    protected void registerContractBillF7() {
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Optional.ofNullable(this.getView().getFormShowParameter()).map(FormShowParameter::getCustomParams).map(m -> m.get("accountancyorg")).ifPresent(orgId -> this.getModel().setValue("accountancyorg", orgId));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        DynamicObject currencyObj = CurrencyHelper.getCurrency((Long)orgId);
        this.getModel().setValue("currency", (Object)currencyObj);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        DynamicObject invoiceBill = this.getModel().getDataEntity();
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        int status = showParameter.getStatus().getValue();
        Map<String, Object[]> info = new HashMap();
        boolean isView = false;
        if (status == OperationStatus.ADDNEW.getValue() && showParameter.getBillStatusValue().intValue() == OperationStatus.ADDNEW.getValue()) {
            model.batchCreateNewEntryRow("invoiceentry", 6);
            DynamicObjectCollection collection = this.getModel().getEntryEntity("invoiceentry");
            collection.forEach(coll -> coll.getDataEntityState().setPushChanged(true));
        } else if (status == OperationStatus.EDIT.getValue()) {
            isView = this.getPageStatus(invoiceBill);
        }
        info = InvoiceBillHelper.getModelMap4InvoiceCustomCtl((String)this.getAppId(), (DynamicObject)invoiceBill);
        info.put("invoiceentry", this.getEntryMap4InvoiceCustomCtl(invoiceBill));
        InvoiceTypeEnum[] enums = InvoiceTypeEnum.values();
        int len = enums.length;
        Object[] type = new Object[len];
        for (int i = 0; i < len; ++i) {
            InvoiceTypeEnum typeE = enums[i];
            HashMap<String, String> typeMap = new HashMap<String, String>(2);
            typeMap.put("alias", typeE.getAlias());
            typeMap.put("value", typeE.getValue());
            type[i] = typeMap;
        }
        data.put("invoicetype", JSON.toJSONString((Object)type));
        data.put("isView", isView);
        data.put(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"), JSON.toJSONString(info));
        customcontrol.setData(data);
    }

    private final boolean getPageStatus(DynamicObject invoiceBill) {
        String billStatus = invoiceBill.getString("billstatus");
        return BillStatusEnum.AUDITTED.getValue().equals(billStatus) || BillStatusEnum.SUBMITTED.getValue().equals(billStatus);
    }

    protected Object[] getEntryMap4InvoiceCustomCtl(DynamicObject invoiceBill) {
        DynamicObjectCollection entryCol = invoiceBill.getDynamicObjectCollection("invoiceentry");
        if (entryCol.size() < 6) {
            this.getModel().batchCreateNewEntryRow("invoiceentry", 6 - entryCol.size());
        }
        Object[] entryData = new Object[6];
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            data.put("entry_content", entry.getString("entry_content"));
            data.put("entry_model", entry.getString("entry_model"));
            data.put("entry_notaxamt", entry.getBigDecimal("entry_notaxamt"));
            data.put("entry_price", entry.getBigDecimal("entry_price"));
            data.put("entry_qty", entry.getBigDecimal("entry_qty"));
            data.put("entry_tax", entry.getBigDecimal("entry_tax"));
            BigDecimal taxRate = null;
            DynamicObject entry_taxrate = entry.getDynamicObject("entry_taxrate");
            if (entry_taxrate != null) {
                taxRate = entry_taxrate.getBigDecimal("taxrate");
            }
            data.put("entry_taxrate", taxRate == null ? "" : taxRate);
            DynamicObject unit = entry.getDynamicObject("entry_unit");
            String unitName = Optional.ofNullable(unit).map(u -> u.getString("name")).orElse("");
            data.put("entry_unit", unitName);
            if (i >= 6) continue;
            entryData[i] = data;
        }
        return entryData;
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        Map reqParam = (Map)JSON.parse((String)e.getEventArgs());
        Optional.ofNullable(reqParam).ifPresent(params -> {
            int idx = event.indexOf(95);
            String eventType = event.substring(0, idx);
            String field = event.substring(idx + 1);
            Object pValue = params.get("value");
            Optional.ofNullable(pValue).map(v -> v.toString()).ifPresent(value -> {
                IDataModel model = this.getModel();
                if ("invoiceno".equals(field)) {
                    model.setValue(field, value);
                    model.setValue("billno", value);
                    return;
                }
                BigDecimal noTaxAmount = BigDecimal.ZERO;
                if (field.startsWith("entry_")) {
                    int rowIndex = Integer.parseInt(params.get("rowIndex").toString());
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    switch (field) {
                        case "entry_qty": {
                            model.setValue("entry_qty", (Object)new BigDecimal(value.equals("") ? "0" : value), rowIndex);
                            noTaxAmount = NumberUtil.multiply((Object)model.getValue("entry_price", rowIndex), (Object)value);
                            model.setValue("entry_notaxamt", (Object)noTaxAmount, rowIndex);
                            BigDecimal tax = NumberUtil.multiply((Object)noTaxAmount, (Object)this.getEntryTaxRate(model, rowIndex));
                            model.setValue("entry_tax", (Object)tax, rowIndex);
                            data.put("entry_tax", tax);
                            data.put("entry_notaxamt", noTaxAmount);
                            data.put("rowIndex", rowIndex);
                            InvoiceBillUtil.calcEntrySumAmount(model);
                            InvoiceBillUtil.updateEntryAmountToCustomCtl(model, this.getView(), data);
                            break;
                        }
                        case "entry_price": {
                            model.setValue("entry_price", value, rowIndex);
                            noTaxAmount = NumberUtil.multiply((Object)value, (Object)model.getValue("entry_qty", rowIndex));
                            model.setValue("entry_notaxamt", (Object)noTaxAmount, rowIndex);
                            BigDecimal tax = NumberUtil.multiply((Object)noTaxAmount, (Object)this.getEntryTaxRate(model, rowIndex));
                            model.setValue("entry_tax", (Object)tax, rowIndex);
                            data.put("entry_tax", tax);
                            data.put("entry_notaxamt", noTaxAmount);
                            data.put("rowIndex", rowIndex);
                            InvoiceBillUtil.calcEntrySumAmount(model);
                            InvoiceBillUtil.updateEntryAmountToCustomCtl(model, this.getView(), data);
                            break;
                        }
                        case "entry_notaxamt": {
                            model.setValue("entry_notaxamt", value, rowIndex);
                            BigDecimal tax = NumberUtil.multiply((Object)value, (Object)this.getEntryTaxRate(model, rowIndex));
                            model.setValue("entry_tax", (Object)tax, rowIndex);
                            data.put("entry_tax", tax);
                            data.put("rowIndex", rowIndex);
                            InvoiceBillUtil.calcEntrySumAmount(model);
                            InvoiceBillUtil.updateEntryAmountToCustomCtl(model, this.getView(), data);
                            break;
                        }
                        case "entry_tax": {
                            model.setValue("entry_tax", value, rowIndex);
                            InvoiceBillUtil.calcEntrySumAmount(model);
                            InvoiceBillUtil.updateEntryAmountToCustomCtl(model, this.getView(), null);
                            break;
                        }
                        default: {
                            model.setValue(field, value, rowIndex);
                            break;
                        }
                    }
                } else if ("onchange".equals(eventType)) {
                    model.setValue(field, value);
                } else {
                    this.getView().getControl(field);
                }
            });
        });
    }

    private BigDecimal getEntryTaxRate(IDataModel model, int rowIndex) {
        return Optional.ofNullable((DynamicObject)model.getValue("entry_taxrate", rowIndex)).map(o -> (BigDecimal)o.get("taxrate")).map(tR -> NumberUtil.divide((Object)tR, (Object)NumberUtil.ONE_HUNDRED)).orElse(BigDecimal.ZERO);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (OperationUtil.isSubmitOp((String)operateKey) && operationResult.isSuccess()) {
            IFormView view = this.getView();
            CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("hasSubmitted", Boolean.TRUE);
            customcontrol.setData(data);
        } else if (OperationUtil.isUnSubmitOp((String)operateKey) && operationResult.isSuccess()) {
            IFormView view = this.getView();
            CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap");
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("cancelSubmitted", Boolean.TRUE);
            customcontrol.setData(data);
        }
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("saleorg", "saleorgname", entityName, this.getModel().getDataEntity(true), null));
    }
}

