/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.invoicebill;

import java.util.List;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.PermissionUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplListPlugin;

public class InvoiceBillListPlugin
extends BillOrgTplListPlugin {
    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        String fileName;
        super.filterColumnSetFilter(args);
        FilterColumn cfc = (FilterColumn)args.getSource();
        MainEntityType entityType = cfc.getEntityType();
        switch (fileName = args.getFieldName()) {
            case "accountancyorg.name": {
                HasPermOrgResult permOrgResult = PermissionUtil.getAllViewPermOrgs((String)entityType.getAppId(), (String)entityType.getName());
                if (permOrgResult.hasAllOrgPerm()) break;
                List orgIds = permOrgResult.getHasPermOrgs();
                args.addCustomQFilter(new QFilter("id", "in", (Object)orgIds));
                break;
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        ((ListView)e.getSource()).getControlFilters().getFilter("accountancyorg.id").stream().findFirst().ifPresent(o -> parameter.setCustomParam("accountancyorg", o));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        Optional.ofNullable(operationResult).filter(OperationResult::isSuccess).ifPresent(o -> {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operateKey = formOperate.getOperateKey();
            ListSelectedRowCollection rows = ((FormOperate)args.getSource()).getListSelectedData();
            ListSelectedRow selectRow = Optional.ofNullable(rows).filter(r -> rows.size() > 0).map(ro -> ro.get(0)).orElse(null);
            DynamicObject bill = null;
            switch (operateKey) {
                case "invoiceref": {
                    bill = BusinessDataServiceHelper.loadSingle((Object)selectRow.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"));
                    if (!BillStatusEnum.AUDITTED.getValue().equals(bill.get("billstatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55\u4e0d\u5141\u8bb8\u8ba4\u9886\uff01", (String)"InvoiceBillListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject payReqBill = bill.getDynamicObject("payreqbill");
                    if (null != payReqBill) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5df2\u7ecf\u88ab\u4ed8\u6b3e\u7533\u8bf7\u5355\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u8ba4\u9886\uff01", (String)"InvoiceBillListPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.showInvoiceBillRefForm(selectRow);
                    break;
                }
                case "receiptinvoice": {
                    bill = BusinessDataServiceHelper.loadSingle((Object)selectRow.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"));
                    if (bill.get("hasreceipt") == null || bill.get("hasreceipt").equals(Boolean.FALSE)) {
                        bill.set("hasreceipt", (Object)Boolean.TRUE);
                        SaveServiceHelper.update((DynamicObject)bill);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u7968\u6210\u529f\uff01", (String)"InvoiceBillListPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                        ((BillList)this.getView().getControl("billlistap")).refresh();
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6536\u7968\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\uff01", (String)"InvoiceBillListPlugin_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }

    private void showInvoiceBillRefForm(ListSelectedRow selectRow) {
        FormShowParameter form = new FormShowParameter();
        String formId = MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill_ref");
        form.setFormId(formId);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("id", selectRow.getPrimaryKeyValue());
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(form);
    }
}

