/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.invoicebill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;
import kd.pccs.concs.formplugin.invoicebill.InvoiceBillUtil;

public class InvoiceBillPropertyChanged
extends AbstractPropertyChanged {
    public InvoiceBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (propertyName = e.getProperty().getName()) {
            case "contractbill": {
                this.contractBillChanged(newValue);
                break;
            }
            case "project": {
                this.projectChanged();
                break;
            }
            case "payreqbill": {
                this.payReqBillChanged(newValue);
                break;
            }
            case "purorg": {
                this.purOrgChanged(newValue);
                break;
            }
            case "saleorg": {
                this.saleOrgChanged(newValue);
                break;
            }
            case "entry_taxrate": {
                this.entryTaxRateChanged(e, newValue);
                break;
            }
            case "entry_unit": {
                this.entryUnitChanged(e, newValue);
                break;
            }
        }
    }

    protected void entryUnitChanged(PropertyChangedArgs e, Object newValue) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject unit = (DynamicObject)newValue;
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("entry_unit", unit.getString("name"));
        data.put("rowIndex", rowIndex);
        customcontrol.setData(data);
    }

    protected void entryTaxRateChanged(PropertyChangedArgs e, Object newValue) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject taxRateDyn = (DynamicObject)newValue;
        BigDecimal taxRate = taxRateDyn.getBigDecimal("taxrate");
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("rowIndex", rowIndex);
        BigDecimal noTaxAmount = (BigDecimal)this.getModel().getValue("entry_notaxamt", rowIndex);
        data.put("entry_taxrate", taxRate);
        BigDecimal tax = NumberUtil.divide((Object)NumberUtil.multiply((Object)noTaxAmount, (Object)taxRate), (Object)NumberUtil.ONE_HUNDRED);
        data.put("entry_tax", tax);
        this.getModel().setValue("entry_tax", (Object)tax, rowIndex);
        InvoiceBillUtil.calcEntrySumAmount(this.getModel());
        InvoiceBillUtil.updateEntryAmountToCustomCtl(this.getModel(), this.getView(), data);
    }

    protected void saleOrgChanged(Object newValue) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        DynamicObject saleOrg = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)this.getSupplierEntityName());
        String bankAccount = "";
        String bankName = "";
        DynamicObjectCollection bankCol = saleOrg.getDynamicObjectCollection("entry_bank");
        for (DynamicObject bankInfo : bankCol) {
            if (!bankInfo.getBoolean("isdefault_bank")) continue;
            bankAccount = bankInfo.getString("bankaccount");
            this.getModel().setValue("salebankaccount", (Object)bankAccount);
            DynamicObject bank = bankInfo.getDynamicObject("bank");
            bankName = Optional.ofNullable(bank).map(b -> b.getString("name")).orElse("");
            this.getModel().setValue("saledepositbank", (Object)bankName);
        }
        String phone = this.getSupplierphone(saleOrg);
        this.getModel().setValue("saletelnumber", (Object)phone);
        String address = saleOrg.getString(this.getSupplieraddress());
        this.getModel().setValue("saleaddress", (Object)address);
        String taxPayer = this.getTxRegisterNo(saleOrg);
        HashMap<String, String> data = new HashMap<String, String>(6);
        if (taxPayer != null) {
            this.getModel().setValue("saletaxpayer", (Object)taxPayer);
            data.put("saletaxpayer", taxPayer);
        }
        data.put("salebankaccount", bankAccount);
        data.put("saledepositbank", bankName);
        data.put("saletelnumber", phone);
        data.put("saleaddress", address);
        data.put("saleorg", saleOrg.getString("name"));
        customcontrol.setData(data);
    }

    protected void purOrgChanged(Object newValue) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        DynamicObject purOrg = (DynamicObject)newValue;
        String bankAccount = purOrg.getString("bankaccount");
        String depositBank = purOrg.getString("depositbank");
        String phone = purOrg.getString("phone");
        String contactAddress = purOrg.getString("contactaddress");
        long taxRegNum = purOrg.getLong("ftaxregnum");
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        if (taxRegNum != 0L) {
            this.getModel().setValue("purtaxpayer", (Object)taxRegNum);
            data.put("purtaxpayer", taxRegNum);
        }
        this.getModel().setValue("purbankaccount", (Object)bankAccount);
        this.getModel().setValue("purdepositbank", (Object)depositBank);
        this.getModel().setValue("purtelnumber", (Object)phone);
        this.getModel().setValue("puraddress", (Object)contactAddress);
        data.put("purbankaccount", bankAccount);
        data.put("purdepositbank", depositBank);
        data.put("purtelnumber", phone);
        data.put("puraddress", contactAddress);
        data.put("purorg", purOrg.getString("name"));
        customcontrol.setData(data);
    }

    protected void payReqBillChanged(Object newValue) {
        if (newValue != null) {
            DynamicObject info = this.getModel().getDataEntity();
            DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"));
            DynamicObject contractBill = payReqBill.getDynamicObject("contractbill");
            if (contractBill != null) {
                info.set("contractbill", (Object)contractBill);
                contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBill.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
                this.getModel().setValue("saleorg", (Object)contractBill.getDynamicObject("partyb"));
            }
            info.set("project", (Object)payReqBill.getDynamicObject("project"));
            this.getView().updateView("project");
            this.getView().updateView("contractbill");
        }
    }

    protected void projectChanged() {
        DynamicObject info = this.getModel().getDataEntity();
        info.set("contractbill", null);
        info.set("payreqbill", null);
        this.getView().updateView("contractbill");
        this.getView().updateView("payreqbill");
    }

    protected void contractBillChanged(Object newValue) {
        DynamicObject info = this.getModel().getDataEntity();
        if (newValue != null) {
            DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
            this.getModel().setValue("saleorg", (Object)contractBill.getDynamicObject("partyb"));
            info.set("org", (Object)contractBill.getDynamicObject("org"));
            info.set("project", (Object)contractBill.getDynamicObject("project"));
            this.getView().updateView("project");
        }
        info.set("payreqbill", null);
        this.getView().updateView("payreqbill");
    }

    protected String getTxRegisterNo(DynamicObject saleOrg) {
        return saleOrg.getString("tx_register_no");
    }

    protected String getSupplierEntityName() {
        return "bd_supplier";
    }

    protected String getSupplierphone(DynamicObject saleOrg) {
        return saleOrg.getString("bizpartner_phone");
    }

    protected String getSupplieraddress() {
        return "bizpartner_address";
    }
}

