/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.invoicebill;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.PayReqF7SelectListener;
import kd.pccs.concs.formplugin.f7.ProjectF7SelectListener;

public class InvoiceBillRefFormPlugin
extends AbstractBillPlugIn {
    public String getAppId() {
        return "concs";
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long invoiceId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        IDataModel model = this.getModel();
        DynamicObject invoiceBill = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"));
        model.setValue("org", (Object)invoiceBill.getDynamicObject("org"));
        model.setValue("project", (Object)invoiceBill.getDynamicObject("project"));
        model.setValue("contractbill", (Object)invoiceBill.getDynamicObject("contractbill"));
        model.setValue("payreqbill", (Object)invoiceBill.getDynamicObject("payreqbill"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        new ProjectF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("project"));
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill"));
        new PayReqF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("payreqbill"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (propertyName = e.getProperty().getName()) {
            case "project": {
                this.projectChanged();
                break;
            }
            case "contractbill": {
                this.contractBillChanged();
                break;
            }
        }
    }

    protected void contractBillChanged() {
        this.getModel().getDataEntity().set("payreqbill", null);
        this.getView().updateView("payreqbill");
    }

    protected void projectChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        model.set("contractbill", null);
        model.set("payreqbill", null);
        this.getView().updateView("contractbill");
        this.getView().updateView("payreqbill");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("updateinvoiceref".equals(operateKey) && operationResult.isSuccess()) {
            this.savaOperation();
        }
    }

    protected void savaOperation() {
        Long oldInvoiceId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        String invoiceSelect = String.join((CharSequence)",", "payreqbill", "id", "project", "refbillstatus", "refbillid", "contractbill");
        DynamicObject newInvoiceBill = this.getModel().getDataEntity();
        DynamicObject oldInvoiceBill = BusinessDataServiceHelper.loadSingle((Object)oldInvoiceId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"invoicebill"), (String)invoiceSelect);
        DynamicObject newPayReq = newInvoiceBill.getDynamicObject("payreqbill");
        DynamicObject oldPayReq = oldInvoiceBill.getDynamicObject("payreqbill");
        Object oldPayReqPk = oldPayReq == null ? null : oldPayReq.getPkValue();
        Object newPayReqPk = newPayReq == null ? null : newPayReq.getPkValue();
        oldInvoiceBill.set("project", (Object)newInvoiceBill.getDynamicObject("project"));
        oldInvoiceBill.set("contractbill", (Object)newInvoiceBill.getDynamicObject("contractbill"));
        oldInvoiceBill.set("payreqbill", (Object)newPayReq);
        oldInvoiceBill.set("refbillid", newPayReqPk);
        oldInvoiceBill.set("refbillstatus", (Object)BillStatusEnum.AUDITTED.getValue());
        SaveServiceHelper.update((DynamicObject)oldInvoiceBill);
        PayReqBillHelper.updateInvoiceInfo((String)this.getAppId(), (Object)newPayReqPk, (Object)oldInvoiceId, (Object)oldPayReqPk);
        IFormView view = this.getView().getParentView();
        view.showSuccessNotification(ResManager.loadKDString((String)"\u8ba4\u9886\u6210\u529f\uff01", (String)"InvoiceBillRefFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        ((BillList)view.getControl("billlistap")).refresh();
        this.getView().close();
    }
}

