/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.payreqbill;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplFormPlugin;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.InvoiceBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.PaymentTypeF7SelectListener;
import kd.pccs.concs.formplugin.f7.RewarddeductBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.SupplierF7SelectListener;
import kd.pccs.concs.formplugin.payreqbill.PayReqBillPropertyChanged;

public class PayReqBillFormPlugin
extends BillOrgTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new PayReqBillPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerContractBillF7();
        this.registerPaymentTypeF7();
        this.registerReceiveUnitF7();
        this.registerRewarddeductBillF7();
        this.registerInvoiceBillF7();
    }

    protected void registerInvoiceBillF7() {
        new InvoiceBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("invoiceentrys")).setCustomQFilter((evt, qFilters) -> {
            String propertyName = evt.getProperty().getName();
            if (!"invoiceentrys".equals(propertyName)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            QFilter qFilter = new QFilter("refbillid", "=", (Object)0L);
            qFilter.or(new QFilter("refbillid", "=", dataEntity.getPkValue()));
            qFilters.add(qFilter);
        });
    }

    protected void registerRewarddeductBillF7() {
        new RewarddeductBillF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("inventry_rewarddeduct")).setCustomQFilter((evt, qFilters) -> {
            String propertyName = evt.getProperty().getName();
            if (!"inventry_rewarddeduct".equals(propertyName)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject contractBill = dataEntity.getDynamicObject("contractbill");
            if (null == contractBill) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("contractbill", "=", contractBill.getPkValue()));
                DynamicObjectCollection redeEntrys = dataEntity.getDynamicObjectCollection("payreqredeentry");
                if (redeEntrys.size() > 0) {
                    HashSet<Object> idSet = new HashSet<Object>();
                    for (DynamicObject entry : redeEntrys) {
                        DynamicObject redeBill = entry.getDynamicObject("inventry_rewarddeduct");
                        if (null == redeBill) continue;
                        idSet.add(redeBill.getPkValue());
                    }
                    if (idSet.size() > 0) {
                        qFilters.add(new QFilter("id", "not in", idSet));
                    }
                }
                QFilter qFilter = new QFilter("refbillid", "=", (Object)0L);
                qFilter.or(new QFilter("refbillid", "=", dataEntity.getPkValue()));
                qFilters.add(qFilter);
            }
        });
    }

    protected void registerReceiveUnitF7() {
        new SupplierF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("receiveunit")).setCustomQFilter((evt, qFilters) -> {
            String propertyName = evt.getProperty().getName();
            if (!"receiveunit".equals(propertyName)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject contract = dataEntity.getDynamicObject("contractbill");
            if (null == contract) {
                long ctrlUnitId = OrgUtil.getCurrentCtrlUnitId((DynamicObject)dataEntity);
                qFilters.add(new QFilter("creator", "=", (Object)ctrlUnitId));
                return;
            }
            HashSet<Object> idSet = new HashSet<Object>();
            DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "partyb", "partycs"), (QFilter[])new QFilter[]{new QFilter("id", "=", contract.getPkValue())});
            if (null != contractBill) {
                DynamicObject partyB = contractBill.getDynamicObject("partyb");
                DynamicObjectCollection partyCs = contractBill.getDynamicObjectCollection("partycs");
                if (null != partyB) {
                    idSet.add(partyB.getPkValue());
                }
                for (DynamicObject partC : partyCs) {
                    DynamicObject supplier = partC.getDynamicObject("fbasedataid");
                    idSet.add(supplier.getPkValue());
                }
            }
            qFilters.add(new QFilter("id", "in", idSet));
        });
    }

    protected void registerPaymentTypeF7() {
        new PaymentTypeF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("paymenttype")).setCustomQFilter((evt, qFilters) -> {});
    }

    protected void registerContractBillF7() {
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill"));
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject contractBill;
        int status;
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!dataEntity.getBoolean("nocontractflag")) {
            ((FieldEdit)this.getView().getControl("contractbill")).setMustInput(true);
        }
        if ((status = this.getView().getFormShowParameter().getStatus().getValue()) == OperationStatus.EDIT.getValue()) {
            DataStandardHelper.updateDataStandEntry((String)this.getAppId(), (IDataModel)this.getModel(), (IFormView)this.getView(), (String)DataStandardBillEnum.PAYREQUEST.getValue());
        }
        if (null != (contractBill = dataEntity.getDynamicObject("contractbill"))) {
            dataEntity.set("latestoriprice", contractBill.get("latestoriprice"));
            dataEntity.set("latestprice", contractBill.get("latestprice"));
            this.getView().updateView("latestoriprice");
            this.getView().updateView("latestprice");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject payReqBill = this.getModel().getDataEntity(true);
        Object contractId = this.getView().getFormShowParameter().getCustomParam("contractbill");
        if (null != contractId) {
            payReqBill.set("nocontractflag", (Object)Boolean.FALSE);
        } else {
            long orgId;
            Object noContractFlagObj = this.getView().getFormShowParameter().getCustomParam("nocontractflag");
            boolean noContractFlag = false;
            if (null != noContractFlagObj) {
                noContractFlag = Boolean.parseBoolean(noContractFlagObj.toString());
                payReqBill.set("nocontractflag", (Object)noContractFlag);
                payReqBill.set("foreigncurrencyflag", (Object)Boolean.FALSE);
            } else {
                noContractFlag = payReqBill.getBoolean("nocontractflag");
            }
            DynamicObject org = payReqBill.getDynamicObject("org");
            if (null != org) {
                orgId = (Long)org.getPkValue();
            } else {
                orgId = RequestContext.get().getOrgId();
                payReqBill.set("org", (Object)BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org"));
            }
            DynamicObject currencyObj = CurrencyHelper.getCurrency((Long)orgId);
            payReqBill.set("oricurrency", (Object)currencyObj);
            payReqBill.set("currency", (Object)currencyObj);
            this.initViewForAddNew(noContractFlag, false);
        }
    }

    protected void initViewForAddNew(boolean nocontractFlag, boolean foreignCurrencyFlag) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"exchangerate"});
        view.setEnable(Boolean.valueOf(!foreignCurrencyFlag), new String[]{"amount"});
        view.setEnable(Boolean.valueOf(!foreignCurrencyFlag), new String[]{"prepayamt"});
        if (nocontractFlag) {
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"oriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedoriamt"});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"oricurrency"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"oriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"prepayoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"rewarddeductoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"latestoriprice"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"totaloriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"totalpayedconoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"settleoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"preunpayoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedconoriamt"});
            view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"inventry_oriamt"});
        }
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("receiveunit", "receiveunitname", entityName, this.getModel().getDataEntity(true), null));
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initViewForAddNew(dataEntity.getBoolean("nocontractflag"), dataEntity.getBoolean("foreigncurrencyflag"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject contractBill;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject model = this.getModel().getDataEntity();
        if (OperationUtil.isSubmitOp((String)operateKey) && null != (contractBill = model.getDynamicObject("contractbill"))) {
            this.updateBillForSubmit((Long)contractBill.getPkValue(), model);
        }
    }

    protected void updateBillForSubmit(Long conId, DynamicObject model) {
        Map preUnPayAmtMap = PayReqBillHelper.getPreUnPayOriAmt((String)this.getAppId(), (Long)conId, (Long)((Long)model.getPkValue()));
        model.set("preunpayoriamt", preUnPayAmtMap.get("preunpayoriamt"));
        model.set("preunpayamt", preUnPayAmtMap.get("preunpayamt"));
        this.getView().updateView("preunpayoriamt");
        this.getView().updateView("preunpayamt");
    }
}

