/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.payreqbill;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.LicenseUtil;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.OperationUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplListPlugin;

public class PayReqBillListPlugin
extends BillOrgTplListPlugin {
    private static final String ITEMKEY = "itemKey";
    private static final String TBL_NEWCON = "tblnewcon";
    private static final String TBL_NEWNOCON = "tblnewnocon";
    private static final String TBLPUSH = "tblpush";
    private static final String TBLTRACKDOWN = "tbltrackdown";
    private static final String TBLPAYREGIST = "tblpayregist";
    private static final String PAYMENTTYPENAME = "paymenttype.name";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean casLicenseFlag = LicenseUtil.checkCasGroupPermit();
        this.getView().setVisible(casLicenseFlag, new String[]{TBLPUSH});
        this.getView().setVisible(casLicenseFlag, new String[]{TBLTRACKDOWN});
        this.getView().setVisible(Boolean.valueOf(casLicenseFlag == false), new String[]{TBLPAYREGIST});
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String itemKey = this.getPageCache().get(ITEMKEY);
        ListView listView = (ListView)e.getSource();
        boolean noContractFlag = false;
        if (null == itemKey) {
            ListSelectedRowCollection rows = listView.getSelectedRows();
            if (rows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01", (String)"PayReqBillListPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow row = rows.get(0);
            DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)"nocontractflag");
            noContractFlag = payReqBill.getBoolean("nocontractflag");
        } else if (TBL_NEWNOCON.equals(itemKey)) {
            noContractFlag = true;
            this.getPageCache().remove(ITEMKEY);
        }
        this.getPageCache().remove(ITEMKEY);
        String caption = noContractFlag ? ResManager.loadKDString((String)"\u65e0\u5408\u540c\u4ed8\u6b3e", (String)"PayReqBillListPlugin_1", (String)"pccs-concs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u540c\u4ed8\u6b3e", (String)"PayReqBillListPlugin_2", (String)"pccs-concs-formplugin", (Object[])new Object[0]);
        e.getParameter().setCustomParam("nocontractflag", (Object)noContractFlag);
        e.getParameter().setCaption(caption);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey();
        if (TBL_NEWNOCON.equals(itemKey) || TBL_NEWCON.equals(itemKey)) {
            this.getPageCache().put(ITEMKEY, itemKey);
        }
    }

    @Override
    public void filterColumnSetFilter(SetFilterEvent args) {
        String fileName;
        super.filterColumnSetFilter(args);
        switch (fileName = args.getFieldName()) {
            case "paymenttype.name": {
                LinkedList<Long> paymentTypeList = new LinkedList<Long>();
                paymentTypeList.add(FiCasConst.PRE_PAYMENT);
                paymentTypeList.add(FiCasConst.PROGRESS_PAYMENT);
                paymentTypeList.add(FiCasConst.SETTLEMENT_PAYMENT);
                paymentTypeList.add(FiCasConst.WARRANTY_PAYMENT);
                args.addCustomQFilter(new QFilter("id", "in", paymentTypeList));
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection rows = args.getListSelectedData();
        ListSelectedRow selectRow = Optional.ofNullable(rows).filter(r -> rows.size() > 0).map(ro -> ro.get(0)).orElse(null);
        if (null == selectRow) {
            return;
        }
        if (OperationUtil.isSubmitOp((String)operateKey)) {
            this.doBeforeSubmit(selectRow);
        }
        switch (operateKey) {
            case "relatecon": {
                this.showRelateContractForm(selectRow, args);
                break;
            }
            case "payregist": {
                this.showPaymentRegistForm(selectRow, args);
                break;
            }
            case "push": {
                this.checkCanCreatePaymentBill(selectRow, args);
                break;
            }
            case "closebill": {
                this.checkBillCanClosed(selectRow, args);
                break;
            }
        }
    }

    protected void checkBillCanClosed(ListSelectedRow selectRow, BeforeDoOperationEventArgs args) {
        if (!BillStatusEnum.AUDITTED.getValue().equals(selectRow.getBillStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u672a\u5ba1\u6279\uff0c\u4e0d\u80fd\u5173\u95ed\uff01", (String)"PayReqBillListPlugin_3", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (PayReqBillHelper.checkHasClosed((String)this.getAppId(), (Long)((Long)selectRow.getPrimaryKeyValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u91cd\u590d\u5173\u95ed\uff01", (String)"PayReqBillListPlugin_4", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.closePayReqBill(selectRow, args);
    }

    protected void checkCanCreatePaymentBill(ListSelectedRow selectRow, BeforeDoOperationEventArgs args) {
        if (!BillStatusEnum.AUDITTED.getValue().equals(selectRow.getBillStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u672a\u5ba1\u6279\uff0c\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\uff01", (String)"PayReqBillListPlugin_5", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (PayReqBillHelper.checkHasClosed((String)this.getAppId(), (Long)((Long)selectRow.getPrimaryKeyValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\uff01", (String)"PayReqBillListPlugin_6", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    protected void closePayReqBill(ListSelectedRow selectRow, BeforeDoOperationEventArgs args) {
        boolean inProcess = WorkflowServiceHelper.inProcess((String)String.valueOf(selectRow.getPrimaryKeyValue()));
        if (inProcess) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u63d0\u4ea4\u5230\u6d41\u7a0b\u4e2d\uff01", (String)"PayReqBillListPlugin_7", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)selectRow.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)this.getSelectorByClosed());
        OperationResult result = OperationServiceHelper.executeOperate((String)"setclose", (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f\uff01", (String)"PayReqBillListPlugin_8", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        } else {
            ValidateResultCollection validateResult = result.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            for (int i = 0; i < validateErrors.size(); ++i) {
                ValidateResult validate = (ValidateResult)validateErrors.get(i);
                List allErrorInfo = validate.getAllErrorInfo();
                if (allErrorInfo.isEmpty()) continue;
                this.getView().showTipNotification(((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
                break;
            }
        }
        this.getView().updateView("billlistap");
    }

    protected String getSelectorByClosed() {
        String selector = String.join((CharSequence)",", "id", "bizstatus", "hasclosed");
        return selector;
    }

    private void showRelateContractForm(ListSelectedRow selectRow, BeforeDoOperationEventArgs args) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)selectRow.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "nocontractflag", "hasclosed", "project", "org"));
        if (bill.getBoolean("hasclosed")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u5173\u8054\u5408\u540c\uff01", (String)"PayReqBillListPlugin_9", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!bill.getBoolean("nocontractflag")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u65e0\u5408\u540c\u4ed8\u6b3e\u624d\u80fd\u6267\u884c\u5173\u8054\u5408\u540c\uff01", (String)"PayReqBillListPlugin_10", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!BillStatusEnum.AUDITTED.getValue().equals(selectRow.getBillStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u672a\u5ba1\u6279\uff0c\u4e0d\u80fd\u5173\u8054\u5408\u540c\uff01", (String)"PayReqBillListPlugin_11", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill_ref"));
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("id", bill.getPkValue());
        DynamicObject org = bill.getDynamicObject("org");
        form.setCustomParam("org", org.getPkValue());
        DynamicObject project = bill.getDynamicObject("project");
        if (null != project) {
            form.setCustomParam("project", project.getPkValue());
        }
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill_ref")));
        this.getView().showForm(form);
    }

    private void showPaymentRegistForm(ListSelectedRow selectRow, BeforeDoOperationEventArgs args) {
        if (!BillStatusEnum.AUDITTED.getValue().equals(selectRow.getBillStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u672a\u5ba1\u6279\uff0c\u4e0d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u767b\u8bb0\uff01", (String)"PayReqBillListPlugin_12", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (PayReqBillHelper.checkHasClosed((String)this.getAppId(), (Long)((Long)selectRow.getPrimaryKeyValue()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u636e\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u767b\u8bb0\uff01", (String)"PayReqBillListPlugin_13", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill_pre"));
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCustomParam("id", selectRow.getPrimaryKeyValue());
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill_pre")));
        this.getView().showForm(form);
    }

    protected void doBeforeSubmit(ListSelectedRow selectRow) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)selectRow.getPrimaryKeyValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "contractbill", "preunpayoriamt", "preunpayamt"));
        DynamicObject contractBill = bill.getDynamicObject("contractbill");
        if (null == contractBill) {
            return;
        }
        this.updatePreUnPayAmt((Long)contractBill.getPkValue(), bill);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bill});
    }

    protected void updatePreUnPayAmt(Long contractId, DynamicObject bill) {
        Map preUnPayAmtMap = PayReqBillHelper.getPreUnPayOriAmt((String)this.getAppId(), (Long)contractId, (Long)((Long)bill.getPkValue()));
        bill.set("preunpayoriamt", preUnPayAmtMap.get("preunpayoriamt"));
        bill.set("preunpayamt", preUnPayAmtMap.get("preunpayamt"));
    }
}

