/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.payreqbill;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;

public class PayReqBillPreFormPlugin
extends AbstractBillPlugIn {
    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object payReqId = formShowParameter.getCustomParam("id");
        this.getPageCache().put("id", payReqId.toString());
        this.setPayReqInfo(payReqId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "payedconamt": {
                this.payedConAmtOnChange(newVal);
                break;
            }
            case "payedoriamt": {
                this.payedOriAmtOnChange(newVal);
                break;
            }
            case "payedamt": {
                this.payedAmtOnChange(newVal);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("paymentregist".equals(operateKey)) {
            this.paymentRegist();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u767b\u8bb0\u6210\u529f\uff01", (String)"PayReqBillPreFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().updateView("billlistap");
        }
    }

    protected void setPayReqInfo(Object payReqId) {
        DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)payReqId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "oriamt", "amount", "rewarddeductoriamt", "rewarddeductamt", "prepayoriamt", "prepayamt", "payedconoriamt", "payedoriamt", "payedconamt", "payedamt", "foreigncurrencyflag", "oricurrency", "currency", "payeddescription", "paydate", "nocontractflag"));
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        dataEntity.set("currency", payReqBill.get("currency"));
        dataEntity.set("oricurrency", payReqBill.get("oricurrency"));
        dataEntity.set("foreigncurrencyflag", payReqBill.get("foreigncurrencyflag"));
        dataEntity.set("payeddescription", payReqBill.get("payeddescription"));
        dataEntity.set("paydate", (Object)new Timestamp(new Date().getTime()));
        BigDecimal payedConOriAmt = NumberUtil.ZERO;
        BigDecimal payedConAmt = NumberUtil.ZERO;
        BigDecimal payedOriAmt = NumberUtil.ZERO;
        BigDecimal payedAmt = NumberUtil.ZERO;
        payedConOriAmt = !NumberUtil.isZero((Object)payReqBill.get("payedconoriamt")) ? payReqBill.getBigDecimal("payedconoriamt") : NumberUtil.subtract((Object)payReqBill.get("oriamt"), (Object)payReqBill.get("prepayoriamt"));
        payedConAmt = !NumberUtil.isZero((Object)payReqBill.get("payedconamt")) ? payReqBill.getBigDecimal("payedconamt") : NumberUtil.subtract((Object)payReqBill.get("amount"), (Object)payReqBill.get("prepayamt"));
        payedOriAmt = !NumberUtil.isZero((Object)payReqBill.get("payedoriamt")) ? payReqBill.getBigDecimal("payedoriamt") : NumberUtil.subtract((Object[])new Object[]{payReqBill.get("oriamt"), payReqBill.get("prepayoriamt"), payReqBill.get("rewarddeductoriamt")});
        payedAmt = !NumberUtil.isZero((Object)payReqBill.get("payedamt")) ? payReqBill.getBigDecimal("payedamt") : NumberUtil.subtract((Object[])new Object[]{payReqBill.get("amount"), payReqBill.get("prepayamt"), payReqBill.get("rewarddeductamt")});
        dataEntity.set("payedconoriamt", (Object)payedConOriAmt);
        dataEntity.set("payedconamt", (Object)payedConAmt);
        dataEntity.set("payedoriamt", (Object)payedOriAmt);
        dataEntity.set("payedamt", (Object)payedAmt);
        BigDecimal exChangeRate = NumberUtil.divide((Object)payedAmt, (Object)payedOriAmt, (int)6);
        dataEntity.set("exchangerate", (Object)exChangeRate);
        this.foreignCurrencyOnChange(payReqBill.getBoolean("foreigncurrencyflag"));
        if (payReqBill.getBoolean("nocontractflag")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"payedconoriamt"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"payedconamt"});
        }
        this.getView().updateView();
    }

    protected void payedConAmtOnChange(Object newVal) {
        DynamicObject model = this.getModel().getDataEntity();
        if (!model.getBoolean("foreigncurrencyflag")) {
            model.set("payedconoriamt", newVal);
            this.getView().updateView("payedconoriamt");
        }
    }

    protected void payedOriAmtOnChange(Object newVal) {
        DynamicObject model = this.getModel().getDataEntity();
        model.set("exchangerate", (Object)NumberUtil.divide((Object)model.getBigDecimal("payedamt"), (Object)newVal, (int)6));
        this.getView().updateView("exchangerate");
    }

    protected void payedAmtOnChange(Object newVal) {
        DynamicObject model = this.getModel().getDataEntity();
        if (model.getBoolean("foreigncurrencyflag")) {
            model.set("exchangerate", (Object)NumberUtil.divide((Object)newVal, (Object)model.getBigDecimal("payedoriamt"), (int)6));
            this.getView().updateView("exchangerate");
        } else {
            model.set("payedoriamt", newVal);
            this.getView().updateView("payedoriamt");
        }
    }

    protected void paymentRegist() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long payReqId = Long.valueOf(this.getPageCache().get("id"));
        DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "id", "payedconoriamt", "payedconamt", "totalpayedconoriamt", "totalpayedconamt", "payedoriamt", "payedamt", "paydate", "description", "payeddescription"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payReqId)});
        payReqBill.set("payedconoriamt", dataEntity.get("payedconoriamt"));
        payReqBill.set("payedconamt", dataEntity.get("payedconamt"));
        payReqBill.set("totalpayedconoriamt", dataEntity.get("payedconoriamt"));
        payReqBill.set("totalpayedconamt", dataEntity.get("payedconamt"));
        payReqBill.set("payedoriamt", dataEntity.get("payedoriamt"));
        payReqBill.set("payedamt", dataEntity.get("payedamt"));
        payReqBill.set("paydate", dataEntity.get("paydate"));
        payReqBill.set("payeddescription", dataEntity.get("payeddescription"));
        SaveServiceHelper.update((DynamicObject)payReqBill);
    }

    protected void foreignCurrencyOnChange(Object newVal) {
        boolean foreignCurrencyFlag = (Boolean)newVal;
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedconoriamt"});
        view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"exchangerate"});
        view.setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedoriamt"});
    }
}

