/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.payreqbill;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.CurrencyHelper;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;
import org.apache.commons.lang.StringUtils;

public class PayReqBillPropertyChanged
extends AbstractPropertyChanged {
    public PayReqBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "contractbill": {
                this.contractOnChange(newVal);
                break;
            }
            case "project": {
                this.projectOnChange();
                break;
            }
            case "oriamt": {
                this.oriAmtOnChange(newVal);
                break;
            }
            case "amount": {
                this.amountOnChange(newVal);
                break;
            }
            case "foreigncurrencyflag": {
                this.foreignCurrencyOnChange(newVal);
                break;
            }
            case "oricurrency": {
                this.oriCurrencyOnChange(newVal);
                break;
            }
            case "exchangerate": {
                this.exchangeRateOnChange(newVal);
                break;
            }
            case "paymenttype": {
                this.paymentTypeOnChange(newVal, oldVal);
                break;
            }
            case "prepayoriamt": {
                this.prepayOriAmtOnChange(newVal);
                break;
            }
            case "prepayamt": {
                this.prepayAmtOnChange(newVal);
                break;
            }
            case "receiveunit": {
                this.receiveUnitOnChange(newVal);
                break;
            }
            case "invoiceentrys": {
                this.invoiceEntrysOnChange(newVal);
                break;
            }
            case "inventry_rewarddeduct": {
                this.rewarddeductOnChange(newVal, oldVal);
                break;
            }
        }
    }

    protected void oriAmtOnChange(Object newVal) {
        DynamicObject billObj = this.getModel().getDataEntity();
        BigDecimal exchangeRate = billObj.getBigDecimal("exchangerate");
        BigDecimal amount = NumberUtil.multiply((Object)newVal, (Object)exchangeRate, (int)2);
        billObj.set("amount", (Object)amount);
        this.getView().updateView("amount");
    }

    protected void amountOnChange(Object newVal) {
        DynamicObject billObj = this.getModel().getDataEntity();
        billObj.set("oriamt", newVal);
        this.getView().updateView("oriamt");
    }

    protected void prepayOriAmtOnChange(Object newVal) {
        DynamicObject billObj = this.getModel().getDataEntity();
        BigDecimal exchangeRate = billObj.getBigDecimal("exchangerate");
        BigDecimal amount = NumberUtil.multiply((Object)newVal, (Object)exchangeRate);
        billObj.set("prepayamt", (Object)amount);
        this.getView().updateView("prepayamt");
    }

    protected void prepayAmtOnChange(Object newVal) {
        DynamicObject billObj = this.getModel().getDataEntity();
        billObj.set("prepayoriamt", newVal);
        this.getView().updateView("prepayoriamt");
    }

    protected void contractOnChange(Object newVal) {
        DynamicObjectCollection bankColl;
        DynamicObject bdSupplier;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.getModel().deleteEntryData("payreqredeentry");
        this.getModel().deleteEntryData("payreqdataentry");
        dataEntity.set("paymenttype", null);
        if (null == newVal) {
            this.clearDataByConChanged(dataEntity);
            return;
        }
        DynamicObject contractBill = (DynamicObject)newVal;
        Long contractId = contractBill.getLong("id");
        boolean hasPrePaymentFlg = this.checkHasPrePayment(contractId);
        this.getView().setEnable(Boolean.valueOf(hasPrePaymentFlg), new String[]{"prepayoriamt"});
        this.getView().setEnable(Boolean.valueOf(hasPrePaymentFlg), new String[]{"prepayamt"});
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"), (String)String.join((CharSequence)",", "project", "contracttype", "oriamt", "amount", "notaxamt", "marginscale", "exchangerate", "foreigncurrencyflag", "partyb", "bd_taxrate", "oricurrency", "currency", "org"));
        dataEntity.set("foreigncurrencyflag", contract.get("foreigncurrencyflag"));
        this.foreignCurrencyOnChange(contract.get("foreigncurrencyflag"));
        dataEntity.set("org", (Object)contract.getDynamicObject("org"));
        dataEntity.set("project", contract.get("project"));
        dataEntity.set("oricurrency", contract.get("oricurrency"));
        dataEntity.set("currency", contract.get("currency"));
        dataEntity.set("exchangerate", contract.get("exchangerate"));
        this.setConTotalData(contractId, dataEntity);
        this.setConSettleData(contractId, dataEntity);
        DynamicObject receivUnit = (DynamicObject)contract.get("partyb");
        dataEntity.set("receiveunit", (Object)receivUnit);
        if (null != receivUnit && null != (bdSupplier = BusinessDataServiceHelper.loadSingle((Object)receivUnit.getPkValue(), (String)this.getSupplierEntityId(), (String)String.join((CharSequence)",", "bank", "bankaccount"))) && (bankColl = bdSupplier.getDynamicObjectCollection("entry_bank")).size() > 0) {
            DynamicObject backInfo = (DynamicObject)bankColl.get(0);
            dataEntity.set("receivebank", backInfo.get("bank"));
            dataEntity.set("receiveno", backInfo.get("bankaccount"));
        }
        this.loadDataStandardEntry(contract);
        this.loadRewardDeductEntry(contractId);
        this.getView().updateView();
    }

    protected void clearDataByConChanged(DynamicObject dataEntity) {
        dataEntity.set("prepayoriamt", null);
        dataEntity.set("prepayamt", null);
        dataEntity.set("totaloriamt", null);
        dataEntity.set("totalamount", null);
        dataEntity.set("totalpayedconoriamt", null);
        dataEntity.set("totalpayedconamt", null);
        dataEntity.set("totalinvoiceamt", null);
        dataEntity.set("totalinvoicetax", null);
        dataEntity.set("settleoriamt", null);
        dataEntity.set("settleamt", null);
        dataEntity.set("preunpayoriamt", null);
        dataEntity.set("preunpayamt", null);
        dataEntity.set("preunpayoriamt", null);
        dataEntity.set("preunpayamt", null);
        this.getView().setEnable(Boolean.FALSE, new String[]{"prepayoriamt"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"prepayamt"});
        this.getView().updateView();
    }

    protected void setConTotalData(Long contractId, DynamicObject dataEntity) {
        DynamicObject[] payReqBills = PayReqBillHelper.getPayReqAmountByContract((String)this.getAppId(), (Long)contractId, (boolean)false, (boolean)true);
        BigDecimal totaloriAmt = NumberUtil.ZERO;
        BigDecimal totalAmount = NumberUtil.ZERO;
        BigDecimal totalPayedConOriAmt = NumberUtil.ZERO;
        BigDecimal totalPayedConAmt = NumberUtil.ZERO;
        BigDecimal totalInvoiceAmt = NumberUtil.ZERO;
        BigDecimal totalInvoiceTax = NumberUtil.ZERO;
        BigDecimal totalPrePayOriAmt = NumberUtil.ZERO;
        BigDecimal totalPrePayAmt = NumberUtil.ZERO;
        BigDecimal preOriamt = NumberUtil.ZERO;
        BigDecimal preAmt = NumberUtil.ZERO;
        for (DynamicObject reqBill : payReqBills) {
            totaloriAmt = NumberUtil.add((Object)totaloriAmt, (Object)reqBill.getBigDecimal("oriamt"));
            totalAmount = NumberUtil.add((Object)totalAmount, (Object)reqBill.getBigDecimal("amount"));
            totalPayedConOriAmt = NumberUtil.add((Object)totalPayedConOriAmt, (Object)reqBill.getBigDecimal("payedconoriamt"));
            totalPayedConAmt = NumberUtil.add((Object)totalPayedConAmt, (Object)reqBill.getBigDecimal("payedconamt"));
            totalInvoiceAmt = NumberUtil.add((Object)totalInvoiceAmt, (Object)reqBill.getBigDecimal("invoiceamt"));
            totalInvoiceTax = NumberUtil.add((Object)totalInvoiceTax, (Object)reqBill.getBigDecimal("invoicetax"));
            DynamicObject paymentType = reqBill.getDynamicObject("paymenttype");
            if (FiCasConst.PRE_PAYMENT.equals((Long)paymentType.getPkValue())) {
                preOriamt = NumberUtil.add((Object)preOriamt, (Object)reqBill.getBigDecimal("oriamt"));
                preAmt = NumberUtil.add((Object)preAmt, (Object)reqBill.getBigDecimal("amount"));
                continue;
            }
            totalPrePayOriAmt = NumberUtil.add((Object)totalPrePayOriAmt, (Object)reqBill.getBigDecimal("prepayoriamt"));
            totalPrePayAmt = NumberUtil.add((Object)totalPrePayAmt, (Object)reqBill.getBigDecimal("prepayamt"));
        }
        dataEntity.set("totaloriamt", (Object)NumberUtil.subtract((Object)totaloriAmt, (Object)totalPrePayOriAmt));
        dataEntity.set("totalamount", (Object)NumberUtil.subtract((Object)totalAmount, (Object)totalPrePayAmt));
        dataEntity.set("totalpayedconoriamt", (Object)totalPayedConOriAmt);
        dataEntity.set("totalpayedconamt", (Object)totalPayedConAmt);
        dataEntity.set("totalinvoiceamt", (Object)NumberUtil.add((Object)totalInvoiceAmt, (Object)dataEntity.getBigDecimal("invoiceamt")));
        dataEntity.set("totalinvoicetax", (Object)NumberUtil.add((Object)totalInvoiceTax, (Object)dataEntity.getBigDecimal("invoicetax")));
        dataEntity.set("preunpayoriamt", (Object)NumberUtil.subtract((Object)preOriamt, (Object)totalPrePayOriAmt));
        boolean foreigncurrencyflag = dataEntity.getBoolean("foreigncurrencyflag");
        if (foreigncurrencyflag) {
            BigDecimal exchangerate = dataEntity.getBigDecimal("exchangerate");
            dataEntity.set("preunpayamt", (Object)NumberUtil.multiply((Object)dataEntity.get("preunpayoriamt"), (Object)exchangerate, (int)2));
        } else {
            dataEntity.set("preunpayamt", (Object)NumberUtil.subtract((Object)preAmt, (Object)totalPrePayAmt));
        }
    }

    protected void setConSettleData(Long contractId, DynamicObject dataEntity) {
        BigDecimal settleOriAmt = NumberUtil.ZERO;
        BigDecimal settleAmt = NumberUtil.ZERO;
        DynamicObject[] settleBills = ConSettleBillHelper.getSettleAmountByContract((String)this.getAppId(), (long)contractId, (boolean)true);
        if (settleBills.length > 0) {
            DynamicObject conSettleBill = settleBills[0];
            settleOriAmt = conSettleBill.getBigDecimal("oriamt");
            settleAmt = conSettleBill.getBigDecimal("amount");
        } else {
            DynamicObject[] stageSettleBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"stagesettlebill"), (String)String.join((CharSequence)",", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", (Object)contractId)});
            if (stageSettleBills.length > 0) {
                for (DynamicObject stageSettleBill : stageSettleBills) {
                    settleOriAmt = NumberUtil.add((Object)settleOriAmt, (Object)stageSettleBill.getBigDecimal("oriamt"));
                    settleAmt = NumberUtil.add((Object)settleAmt, (Object)stageSettleBill.getBigDecimal("amount"));
                }
            }
        }
        dataEntity.set("settleoriamt", (Object)settleOriAmt);
        dataEntity.set("settleamt", (Object)settleAmt);
    }

    protected void loadDataStandardEntry(DynamicObject contractBill) {
        DynamicObject contractType = contractBill.getDynamicObject("contracttype");
        if (null == contractType) {
            return;
        }
        DynamicObject[] dataStands = DataStandardHelper.getDataStandardArrByContract((String)this.getAppId(), (String)DataStandardBillEnum.PAYREQUEST.getValue(), (DynamicObject)contractBill);
        int dataStandSize = dataStands.length;
        if (dataStandSize > 0) {
            this.getModel().batchCreateNewEntryRow("payreqdataentry", dataStandSize);
            for (int i = 0; i < dataStandSize; ++i) {
                DynamicObject dataStand = dataStands[i];
                this.getModel().setValue("dataentry_datastandard", (Object)dataStand, i);
                this.getModel().setValue("dataentry_reportflag", null, i);
                this.getModel().setValue("dataentry_verifyqty", (Object)0, i);
            }
        }
        this.getModel().updateCache();
    }

    protected void loadRewardDeductEntry(Long contractId) {
        DynamicObject[] rewardDeductBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"rewarddeduct_f7"), (String)String.join((CharSequence)",", "paytype", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("refbillid", "=", (Object)0L), new QFilter("contractbill", "=", (Object)contractId)});
        int redeBillSize = rewardDeductBills.length;
        BigDecimal redeOriAmt = NumberUtil.ZERO;
        BigDecimal redeAmount = NumberUtil.ZERO;
        BigDecimal totalRedeOriAmt = NumberUtil.ZERO;
        BigDecimal totalRedeAmount = NumberUtil.ZERO;
        if (redeBillSize > 0) {
            this.getModel().batchCreateNewEntryRow("payreqredeentry", redeBillSize);
            for (int i = 0; i < redeBillSize; ++i) {
                DynamicObject redeBill = rewardDeductBills[i];
                this.getModel().setValue("inventry_rewarddeduct", (Object)redeBill, i);
                this.getModel().setValue("inventry_description", null, i);
                redeOriAmt = redeBill.getBigDecimal("oriamt");
                redeAmount = redeBill.getBigDecimal("amount");
                this.getModel().setValue("inventry_oriamt", (Object)redeOriAmt, i);
                this.getModel().setValue("inventry_amount", (Object)redeAmount, i);
                totalRedeOriAmt = NumberUtil.add((Object)totalRedeOriAmt, (Object)redeOriAmt);
                totalRedeAmount = NumberUtil.add((Object)totalRedeAmount, (Object)redeAmount);
            }
        }
        this.setInvEntrySumRow(totalRedeOriAmt, totalRedeAmount);
    }

    protected void setInvEntrySumRow(BigDecimal totalRedeOriAmt, BigDecimal totalRedeAmount) {
        DynamicObject currencyObj;
        String oriSign = "";
        String sign = "";
        DynamicObject oriCurrencyObj = (DynamicObject)this.getModel().getValue("oricurrency");
        if (null != oriCurrencyObj && StringUtils.isNotEmpty((String)oriCurrencyObj.getString("sign"))) {
            oriSign = oriCurrencyObj.getString("sign");
        }
        if (null != (currencyObj = (DynamicObject)this.getModel().getValue("currency")) && StringUtils.isNotEmpty((String)currencyObj.getString("sign"))) {
            sign = currencyObj.getString("sign");
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("payreqredeentry");
        HashMap<String, String> sumData = new HashMap<String, String>();
        sumData.put("inventry_oriamt", oriSign + NumberUtil.formatTo2ddString((Object)totalRedeOriAmt));
        sumData.put("inventry_amount", sign + NumberUtil.formatTo2ddString((Object)totalRedeAmount));
        entryGrid.setFloatButtomData(sumData);
        this.getModel().getDataEntity().set("rewarddeductoriamt", (Object)totalRedeOriAmt);
        this.getModel().getDataEntity().set("rewarddeductamt", (Object)totalRedeAmount);
        this.getView().updateView("rewarddeductoriamt");
        this.getView().updateView("rewarddeductamt");
        this.getView().updateView("payreqredeentry");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryType = e.getEntryProp().getName();
        if ("payreqredeentry".equals(entryType)) {
            this.afterDelRedeEntryRow();
        }
    }

    protected void afterDelRedeEntryRow() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection redeEntryDatas = dataEntity.getDynamicObjectCollection("payreqredeentry");
        BigDecimal redeOriAmt = NumberUtil.ZERO;
        BigDecimal redeAmount = NumberUtil.ZERO;
        for (DynamicObject entry : redeEntryDatas) {
            DynamicObject rewarddeduct = entry.getDynamicObject("inventry_rewarddeduct");
            if (null == rewarddeduct) continue;
            redeOriAmt = NumberUtil.add((Object)redeOriAmt, (Object)entry.get("inventry_oriamt"));
            redeAmount = NumberUtil.add((Object)redeAmount, (Object)entry.get("inventry_amount"));
        }
        this.setInvEntrySumRow(redeOriAmt, redeAmount);
    }

    protected void receiveUnitOnChange(Object newVal) {
        DynamicObjectCollection bankColl;
        DynamicObject receiveUnit;
        DynamicObject bdSupplier;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object receiveBank = null;
        Object receiveNo = null;
        if (null != newVal && null != (bdSupplier = BusinessDataServiceHelper.loadSingle((Object)(receiveUnit = (DynamicObject)newVal).getPkValue(), (String)this.getSupplierEntityId(), (String)String.join((CharSequence)",", "bank", "bankaccount"))) && (bankColl = bdSupplier.getDynamicObjectCollection("entry_bank")).size() > 0) {
            DynamicObject backInfo = (DynamicObject)bankColl.get(0);
            receiveBank = backInfo.get("bank");
            receiveNo = backInfo.get("bankaccount");
        }
        dataEntity.set("receivebank", receiveBank);
        dataEntity.set("receiveno", receiveNo);
        this.getView().updateView("receivebank");
        this.getView().updateView("receiveno");
    }

    protected void rewarddeductOnChange(Object newVal, Object oldVal) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("payreqredeentry");
        int[] rows = entryGrid.getSelectRows();
        if (0 == rows.length) {
            return;
        }
        int rowIndex = rows[0];
        DynamicObjectCollection redeEntryDatas = dataEntity.getDynamicObjectCollection("payreqredeentry");
        DynamicObject redeEntry = (DynamicObject)redeEntryDatas.get(rowIndex);
        BigDecimal totalRedeOriAmt = NumberUtil.ZERO;
        BigDecimal totalRedeAmount = NumberUtil.ZERO;
        if (null == newVal) {
            redeEntry.set("inventry_oriamt", null);
            redeEntry.set("inventry_amount", null);
        } else {
            DynamicObject redeBill = (DynamicObject)newVal;
            BigDecimal redeOriAmt = redeBill.getBigDecimal("oriamt");
            BigDecimal redeAmount = redeBill.getBigDecimal("amount");
            redeEntry.set("inventry_oriamt", (Object)redeOriAmt);
            redeEntry.set("inventry_amount", (Object)redeAmount);
            for (DynamicObject entry : redeEntryDatas) {
                DynamicObject rewarddeduct = entry.getDynamicObject("inventry_rewarddeduct");
                if (null == rewarddeduct) continue;
                totalRedeOriAmt = NumberUtil.add((Object)totalRedeOriAmt, (Object)entry.get("inventry_oriamt"));
                totalRedeAmount = NumberUtil.add((Object)totalRedeAmount, (Object)entry.get("inventry_amount"));
            }
        }
        this.setInvEntrySumRow(totalRedeOriAmt, totalRedeAmount);
    }

    protected void invoiceEntrysOnChange(Object newVal) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BigDecimal invoiceAmt = NumberUtil.ZERO;
        BigDecimal invoiceTax = NumberUtil.ZERO;
        BigDecimal invoiceNoTaxAmt = NumberUtil.ZERO;
        BigDecimal totalInvoiceAmt = NumberUtil.ZERO;
        BigDecimal totalInvoiceTax = NumberUtil.ZERO;
        DynamicObjectCollection invoiceColl = (DynamicObjectCollection)newVal;
        boolean noContractFlag = dataEntity.getBoolean("nocontractflag");
        if (invoiceColl.size() > 0) {
            DynamicObject[] payReqBills;
            for (DynamicObject data : invoiceColl) {
                DynamicObject invoice = data.getDynamicObject("fbasedataid");
                invoiceAmt = NumberUtil.add((Object)invoiceAmt, (Object)invoice.getBigDecimal("amount"));
                invoiceTax = NumberUtil.add((Object)invoiceTax, (Object)invoice.getBigDecimal("tax"));
                invoiceNoTaxAmt = NumberUtil.add((Object)invoiceNoTaxAmt, (Object)invoice.getBigDecimal("notaxamt"));
            }
            DynamicObject contractBill = dataEntity.getDynamicObject("contractbill");
            if (!noContractFlag && null != contractBill && (payReqBills = PayReqBillHelper.getPayReqAmountByContract((String)this.getAppId(), (Long)((Long)contractBill.getPkValue()), (boolean)true, (boolean)true)).length > 0) {
                for (DynamicObject payReqBill : payReqBills) {
                    totalInvoiceAmt = NumberUtil.add((Object)totalInvoiceAmt, (Object)payReqBill.getBigDecimal("invoiceamt"));
                    totalInvoiceTax = NumberUtil.add((Object)totalInvoiceAmt, (Object)payReqBill.getBigDecimal("invoicetax"));
                }
            }
            totalInvoiceAmt = NumberUtil.add((Object)totalInvoiceAmt, (Object)invoiceAmt);
            totalInvoiceTax = NumberUtil.add((Object)totalInvoiceTax, (Object)invoiceTax);
        }
        dataEntity.set("invoiceamt", (Object)invoiceAmt);
        dataEntity.set("invoicetax", (Object)invoiceTax);
        dataEntity.set("invoicenotaxamt", (Object)invoiceNoTaxAmt);
        this.getView().updateView("invoiceamt");
        this.getView().updateView("invoicetax");
        this.getView().updateView("invoicenotaxamt");
        if (!noContractFlag) {
            dataEntity.set("totalinvoiceamt", (Object)totalInvoiceAmt);
            dataEntity.set("totalinvoicetax", (Object)totalInvoiceTax);
            this.getView().updateView("totalinvoiceamt");
            this.getView().updateView("totalinvoicetax");
        }
    }

    protected void projectOnChange() {
        this.getModel().setValue("contractbill", null);
        this.getView().updateView("contractbill");
    }

    protected void foreignCurrencyOnChange(Object newVal) {
        boolean foreignCurrencyFlag = (Boolean)newVal;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"exchangerate"});
        this.getView().setEnable(Boolean.valueOf(!foreignCurrencyFlag), new String[]{"amount"});
        this.getView().setEnable(Boolean.valueOf(!foreignCurrencyFlag), new String[]{"prepayamt"});
        if (dataEntity.getBoolean("nocontractflag")) {
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"oriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedoriamt"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"oricurrency"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"oriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"prepayoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"rewarddeductoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"latestoriprice"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"totaloriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"totalpayedconoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"settleoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"preunpayoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"payedconoriamt"});
            this.getView().setVisible(Boolean.valueOf(foreignCurrencyFlag), new String[]{"inventry_oriamt"});
        }
    }

    protected void oriCurrencyOnChange(Object newVal) {
        DynamicObject model = this.getModel().getDataEntity();
        BigDecimal exchangeRate = NumberUtil.ONE;
        if (null != newVal) {
            DynamicObject currencyObj = model.getDynamicObject("currency");
            DynamicObject oriCurrencyObj = (DynamicObject)newVal;
            if (!currencyObj.getPkValue().equals(oriCurrencyObj.getPkValue())) {
                this.getModel().setValue("foreigncurrencyflag", (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue("foreigncurrencyflag", (Object)Boolean.FALSE);
            }
            DynamicObject orgObj = model.getDynamicObject("org");
            Long orgId = null;
            orgId = null != orgObj ? (Long)orgObj.getPkValue() : Long.valueOf(RequestContext.get().getOrgId());
            exchangeRate = CurrencyHelper.getExchangeRate((Long)orgId, (Long)((Long)((DynamicObject)newVal).getPkValue()));
        }
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
    }

    protected void exchangeRateOnChange(Object newVal) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        BigDecimal exchangeRate = NumberUtil.toBigDecimal((Object)newVal);
        BigDecimal amount = NumberUtil.multiply((Object)billObj.getBigDecimal("oriamt"), (Object)exchangeRate);
        this.getModel().getDataEntity().set("amount", (Object)amount);
        this.getView().updateView("amount");
    }

    protected void paymentTypeOnChange(Object newVal, Object oldVal) {
        if (null == newVal) {
            return;
        }
        DynamicObject paymentType = (DynamicObject)newVal;
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject contract = model.getDynamicObject("contractbill");
        if (null == contract || FiCasConst.PRE_PAYMENT.equals(paymentType.getPkValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"prepayoriamt"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"prepayamt"});
            this.getModel().setValue("prepayoriamt", null);
        } else {
            boolean enableFlag = this.checkHasPrePayment(contract.getPkValue());
            boolean foreigncurrencyflag = model.getBoolean("foreigncurrencyflag");
            if (foreigncurrencyflag) {
                this.getView().setEnable(Boolean.valueOf(enableFlag), new String[]{"prepayoriamt"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"prepayamt"});
            } else {
                this.getView().setEnable(Boolean.valueOf(enableFlag), new String[]{"prepayamt"});
            }
        }
        this.getView().updateView("prepayoriamt");
        this.getView().updateView("prepayamt");
    }

    private boolean checkHasPrePayment(Object contractId) {
        boolean hasPrePaymentFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (QFilter[])new QFilter[]{new QFilter("contractbill", "=", contractId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("paymenttype", "=", (Object)FiCasConst.PRE_PAYMENT)});
        return hasPrePaymentFlag;
    }

    protected String getSupplierEntityId() {
        return "bd_supplier";
    }
}

