/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.payreqbill;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.business.helper.PayReqBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.f7.ProjectF7SelectListener;

public class PayReqBillRefFormPlugin
extends AbstractBillPlugIn {
    public String getAppId() {
        return MetaDataUtil.getAppIdByView((IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object payReqId = this.getView().getFormShowParameter().getCustomParam("id");
        this.getPageCache().put("id", payReqId.toString());
        Object orgId = this.getView().getFormShowParameter().getCustomParam("org");
        this.getModel().setValue("org", orgId);
        Object projectId = this.getView().getFormShowParameter().getCustomParam("project");
        this.getModel().setValue("project", projectId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        new ProjectF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("project"));
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("relatecontract".equals(operateKey)) {
            this.relateContractData();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u6210\u529f\uff01", (String)"PayReqBillRefFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().updateView("billlistap");
        }
    }

    private void relateContractData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long payReqId = Long.valueOf(this.getPageCache().get("id"));
        DynamicObject payReqBill = BusinessDataServiceHelper.loadSingle((Object)payReqId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"payreqbill"), (String)String.join((CharSequence)",", "id", "contractbill", "nocontractflag", "totaloriamt", "totalamount", "invoiceamt", "invoicetax", "totalinvoiceamt", "totalinvoicetax", "settleoriamt", "settleamt"));
        DynamicObject contractBill = dataEntity.getDynamicObject("contractbill");
        Long contractId = (Long)contractBill.getPkValue();
        payReqBill.set("contractbill", (Object)contractBill);
        payReqBill.set("nocontractflag", (Object)Boolean.FALSE);
        DynamicObject[] payReqBills = PayReqBillHelper.getPayReqAmountByContract((String)this.getAppId(), (Long)contractId, (boolean)true, (boolean)true);
        BigDecimal totaloriAmt = NumberUtil.ZERO;
        BigDecimal totalAmount = NumberUtil.ZERO;
        BigDecimal totalInvoiceAmt = NumberUtil.ZERO;
        BigDecimal totalInvoiceTax = NumberUtil.ZERO;
        for (DynamicObject reqBill : payReqBills) {
            totaloriAmt = NumberUtil.add((Object)totaloriAmt, (Object)reqBill.getBigDecimal("oriamt"));
            totalAmount = NumberUtil.add((Object)totalAmount, (Object)reqBill.getBigDecimal("amount"));
            totalInvoiceAmt = NumberUtil.add((Object)totalInvoiceAmt, (Object)reqBill.getBigDecimal("invoiceamt"));
            totalInvoiceTax = NumberUtil.add((Object)totalInvoiceTax, (Object)reqBill.getBigDecimal("invoicetax"));
        }
        payReqBill.set("totaloriamt", (Object)totaloriAmt);
        payReqBill.set("totalamount", (Object)totalAmount);
        payReqBill.set("totalinvoiceamt", (Object)NumberUtil.add((Object)totalInvoiceAmt, (Object)payReqBill.getBigDecimal("invoiceamt")));
        payReqBill.set("totalinvoicetax", (Object)NumberUtil.add((Object)totalInvoiceTax, (Object)payReqBill.getBigDecimal("invoicetax")));
        BigDecimal settleOriAmt = NumberUtil.ZERO;
        BigDecimal settleAmt = NumberUtil.ZERO;
        DynamicObject[] settleBills = ConSettleBillHelper.getSettleAmountByContract((String)this.getAppId(), (long)contractId, (boolean)true);
        if (settleBills.length > 0) {
            DynamicObject conSettleBill = settleBills[0];
            settleOriAmt = conSettleBill.getBigDecimal("oriamt");
            settleAmt = conSettleBill.getBigDecimal("amount");
        } else {
            DynamicObject[] stageSettleBills = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"stagesettlebill"), (String)String.join((CharSequence)",", "oriamt", "amount"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", (Object)contractId)});
            if (stageSettleBills.length > 0) {
                for (DynamicObject stageSettleBill : stageSettleBills) {
                    settleOriAmt = NumberUtil.add((Object)settleOriAmt, (Object)stageSettleBill.getBigDecimal("oriamt"));
                    settleAmt = NumberUtil.add((Object)settleAmt, (Object)stageSettleBill.getBigDecimal("amount"));
                }
            }
        }
        payReqBill.set("settleoriamt", (Object)settleOriAmt);
        payReqBill.set("settleamt", (Object)settleAmt);
        SaveServiceHelper.update((DynamicObject)payReqBill);
    }
}

