/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.rewarddeductbill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.DeductPropertyEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;

public class RewardDeductBillPropertyChanged
extends AbstractPropertyChanged {
    public RewardDeductBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String filedName;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        switch (filedName = pro.getName()) {
            case "project": {
                this.projectOnChange();
                break;
            }
            case "entry_contractbill": {
                this.entry_contractOnChange(e, rowIndex);
                break;
            }
            case "entry_amount": {
                this.entry_amountOnChange(rowIndex);
                break;
            }
            case "entry_oriamt": {
                this.entry_oriAmtOnChange(rowIndex);
                break;
            }
            case "entry_payitem": {
                this.entry_payItemOnChange(rowIndex);
                break;
            }
        }
    }

    private void projectOnChange() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("rewarddeductentry");
        entrys.clear();
        entrys.addNew();
        this.getView().updateView("rewarddeductentry");
    }

    private void entry_contractOnChange(PropertyChangedArgs propertychangedargs, int rowIndex) {
        ChangeData cd = propertychangedargs.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        DynamicObject entry = this.getModel().getEntryRowEntity("rewarddeductentry", rowIndex);
        if (null == newVal) {
            entry.set("entry_supplier", null);
            entry.set("entry_description", null);
            entry.set("entry_currency", null);
            entry.set("entry_oricurrency", null);
        } else {
            DynamicObject contractBill = entry.getDynamicObject("entry_contractbill");
            long contractBillId = contractBill.getLong("id");
            contractBill = BusinessDataServiceHelper.loadSingle((Object)contractBillId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
            DynamicObject partB = contractBill.getDynamicObject("partyb");
            DynamicObject currency = contractBill.getDynamicObject("currency");
            DynamicObject oriCurrency = contractBill.getDynamicObject("oricurrency");
            entry.set("entry_supplier", (Object)partB);
            entry.set("entry_currency", (Object)currency);
            entry.set("entry_oricurrency", (Object)oriCurrency);
        }
        entry.set("entry_oriamt", null);
        entry.set("entry_amount", null);
        this.getView().updateView("rewarddeductentry", rowIndex);
    }

    private void entry_amountOnChange(int rowIndex) {
        DynamicObject entry = this.getModel().getEntryRowEntity("rewarddeductentry", rowIndex);
        DynamicObject payItem = entry.getDynamicObject("entry_payitem");
        BigDecimal amount = entry.getBigDecimal("entry_amount");
        BigDecimal oriAmt = entry.getBigDecimal("entry_oriamt");
        if (null != payItem) {
            String payType = payItem.getString("deductproperty");
            if (DeductPropertyEnum.SUBTRACT.getValue().equals(payType) && NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)amount) < 0) {
                entry.set("entry_amount", (Object)amount.negate());
            } else if (DeductPropertyEnum.ADD.getValue().equals(payType) && NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)amount) > 0) {
                entry.set("entry_amount", (Object)BigDecimal.ZERO);
            }
        }
        DynamicObject dynamicObject = entry.getDynamicObject("entry_contractbill");
        BigDecimal exchangeRate = null;
        exchangeRate = null != dynamicObject ? Optional.ofNullable(dynamicObject.getBigDecimal("exchangerate")).orElse(BigDecimal.ONE) : BigDecimal.ONE;
        amount = entry.getBigDecimal("entry_amount");
        if (NumberUtil.compareTo((Object)exchangeRate, (Object)BigDecimal.ONE) == 0 && NumberUtil.compareTo((Object)amount, (Object)oriAmt) != 0) {
            entry.set("entry_oriamt", (Object)amount);
            this.getView().updateView("rewarddeductentry", rowIndex);
        }
    }

    private void entry_oriAmtOnChange(int rowIndex) {
        DynamicObject entry = this.getModel().getEntryRowEntity("rewarddeductentry", rowIndex);
        DynamicObject payItem = entry.getDynamicObject("entry_payitem");
        BigDecimal oriAmt = entry.getBigDecimal("entry_oriamt");
        if (null != payItem) {
            String payType = payItem.getString("deductproperty");
            if (DeductPropertyEnum.SUBTRACT.getValue().equals(payType) && NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)oriAmt) < 0) {
                entry.set("entry_oriamt", (Object)oriAmt.negate());
            } else if (DeductPropertyEnum.ADD.getValue().equals(payType) && NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)oriAmt) > 0) {
                entry.set("entry_oriamt", (Object)BigDecimal.ZERO);
            }
        }
        DynamicObject dynamicObject = entry.getDynamicObject("entry_contractbill");
        BigDecimal exchangeRate = null;
        exchangeRate = null != dynamicObject ? Optional.ofNullable(dynamicObject.getBigDecimal("exchangerate")).orElse(BigDecimal.ONE) : BigDecimal.ONE;
        oriAmt = entry.getBigDecimal("entry_oriamt");
        entry.set("entry_amount", (Object)NumberUtil.multiply((Object)oriAmt, (Object)exchangeRate, (int)2));
        this.getView().updateView("rewarddeductentry", rowIndex);
    }

    private void entry_payItemOnChange(int rowIndex) {
        boolean subtractPayTypeAndAmtOverZeroFlag;
        DynamicObject entry = this.getModel().getEntryRowEntity("rewarddeductentry", rowIndex);
        DynamicObject payItem = entry.getDynamicObject("entry_payitem");
        if (null == payItem) {
            return;
        }
        BigDecimal amount = entry.getBigDecimal("entry_amount");
        BigDecimal oriAmt = entry.getBigDecimal("entry_oriamt");
        String payType = payItem.getString("deductproperty");
        boolean addPayTypeAndAmtLessZeroFlag = DeductPropertyEnum.ADD.getValue().equals(payType) && (NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)oriAmt) > 0 || NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)amount) > 0);
        boolean bl = subtractPayTypeAndAmtOverZeroFlag = DeductPropertyEnum.SUBTRACT.getValue().equals(payType) && (NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)oriAmt) < 0 || NumberUtil.compareTo((Object)BigDecimal.ZERO, (Object)amount) < 0);
        if (addPayTypeAndAmtLessZeroFlag || subtractPayTypeAndAmtOverZeroFlag) {
            entry.set("entry_amount", (Object)amount.negate());
            entry.set("entry_oriamt", (Object)oriAmt.negate());
            this.getView().updateView("rewarddeductentry", rowIndex);
        }
    }
}

