/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.stagesettlebill;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTplFormPlugin;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.stagesettlebill.StageSettleBillPropertyChanged;

public class StageSettleBillFormPlugin
extends BillOrgTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new StageSettleBillPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerContractBillF7();
    }

    protected void registerContractBillF7() {
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill")).setCustomQFilter((evt, qFilters) -> {
            Set hasSettledConIds = ConSettleBillHelper.getHasSettledConIds((String)this.getAppId(), (long)OrgUtil.getCurrentOrgId((DynamicObject)this.getModel().getDataEntity()));
            if (hasSettledConIds.size() > 0) {
                qFilters.add(new QFilter("id", "not in", (Object)hasSettledConIds));
            }
        });
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("supplier", "suppliername", entityName, this.getModel().getDataEntity(true), null));
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject contractBill;
        super.afterBindData(e);
        int status = this.getView().getFormShowParameter().getStatus().getValue();
        if (status == OperationStatus.EDIT.getValue()) {
            DataStandardHelper.updateDataStandEntry((String)this.getAppId(), (IDataModel)this.getModel(), (IFormView)this.getView(), (String)DataStandardBillEnum.STAGESETTLE.getValue());
        }
        if (null != (contractBill = this.getModel().getDataEntity().getDynamicObject("contractbill"))) {
            this.getModel().setValue("conlatestoriprice", contractBill.get("latestoriprice"));
            this.getView().updateView("conlatestoriprice");
        }
    }
}

