/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.stagesettlebill;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.business.helper.StageSettleBillHelper;
import kd.pccs.concs.business.helper.bd.DataStandardHelper;
import kd.pccs.concs.common.enums.DataStandardBillEnum;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.base.AbstractPropertyChanged;

public class StageSettleBillPropertyChanged
extends AbstractPropertyChanged {
    public StageSettleBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        switch (propertyName = e.getProperty().getName()) {
            case "oriamt": {
                this.oriAmtChanged(newValue, oldValue);
                break;
            }
            case "totalsettleoriamt": {
                this.totalSettleOriAmtChanged(newValue, oldValue);
                break;
            }
            case "contractbill": {
                this.contractChanged(newValue, oldValue);
                break;
            }
            case "project": {
                this.projectChanged(newValue, oldValue);
                break;
            }
        }
    }

    protected void oriAmtChanged(Object newValue, Object oldValue) {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject conObj = model.getDynamicObject("contractbill");
        if (conObj == null) {
            return;
        }
        Map totalSettleAmtMap = StageSettleBillHelper.queryTotalSettleAmt((String)this.getAppId(), (Long)((Long)conObj.getPkValue()));
        BigDecimal amount = NumberUtil.multiply((Object)newValue, (Object)model.getBigDecimal("exchangerate"));
        this.getModel().setValue("amount", (Object)amount);
        this.getModel().setValue("totalsettleoriamt", (Object)NumberUtil.add((Object)newValue, totalSettleAmtMap.get("totalsettleoriamt")));
        this.getModel().setValue("totalsettleamt", (Object)NumberUtil.add((Object)amount, totalSettleAmtMap.get("totalsettleamt")));
    }

    protected void totalSettleOriAmtChanged(Object newValue, Object oldValue) {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject conObj = model.getDynamicObject("contractbill");
        if (conObj == null) {
            return;
        }
        Map totalSettleAmtMap = StageSettleBillHelper.queryTotalSettleAmt((String)this.getAppId(), (Long)((Long)conObj.getPkValue()));
        BigDecimal totalSettleAmt = NumberUtil.multiply((Object)newValue, (Object)model.getBigDecimal("exchangerate"));
        this.getModel().setValue("totalsettleamt", (Object)totalSettleAmt);
        this.getModel().setValue("oriamt", (Object)NumberUtil.subtract((Object)newValue, totalSettleAmtMap.get("totalsettleoriamt")));
        this.getModel().setValue("amount", (Object)NumberUtil.subtract((Object)totalSettleAmt, totalSettleAmtMap.get("totalsettleamt")));
    }

    protected void contractChanged(Object newValue, Object oldValue) {
        this.setContractNew((DynamicObject)newValue);
    }

    protected void projectChanged(Object newValue, Object oldValue) {
        this.setContractNew(null);
    }

    protected void setContractNew(DynamicObject contract) {
        DynamicObject model = this.getModel().getDataEntity();
        model.set("contractbill", (Object)contract);
        if (contract == null) {
            model.set("supplier", null);
            model.set("foreigncurrencyflag", null);
            model.set("exchangerate", null);
            model.set("currency", null);
            model.set("oricurrency", null);
            model.set("conlatestoriprice", null);
            ((FieldEdit)this.getView().getControl("oriamt")).setMustInput(false);
        } else {
            DynamicObject currency;
            DynamicObject oriCurrency = contract.getDynamicObject("oricurrency");
            if (null != oriCurrency) {
                oriCurrency = BusinessDataServiceHelper.loadSingle((Object)oriCurrency.getPkValue(), (String)"bd_currency");
            }
            if (null != (currency = contract.getDynamicObject("currency"))) {
                currency = BusinessDataServiceHelper.loadSingle((Object)currency.getPkValue(), (String)"bd_currency");
            }
            model.set("supplier", (Object)contract.getDynamicObject("partyb"));
            model.set("org", (Object)contract.getDynamicObject("org"));
            model.set("project", (Object)contract.getDynamicObject("project"));
            this.getModel().setValue("foreigncurrencyflag", (Object)contract.getBoolean("foreigncurrencyflag"));
            model.set("exchangerate", (Object)contract.getBigDecimal("exchangerate"));
            model.set("currency", (Object)currency);
            model.set("oricurrency", (Object)oriCurrency);
            model.set("conlatestoriprice", contract.get("latestoriprice"));
            boolean multiTaxRateFlag = contract.getBoolean("multitaxrateflag");
            if (multiTaxRateFlag) {
                ((FieldEdit)this.getView().getControl("oriamt")).setMustInput(true);
            } else {
                ((FieldEdit)this.getView().getControl("oriamt")).setMustInput(false);
            }
            this.getView().updateView();
        }
        this.updateSettleAmout(model, contract);
        this.updateStageSettleDataEntry(model, contract);
        this.getView().updateView();
    }

    protected void updateSettleAmout(DynamicObject model, DynamicObject conObj) {
        if (conObj == null) {
            model.set("totalsettleoriamt", null);
            model.set("totalsettleamt", null);
            model.set("oriamt", null);
            model.set("amount", null);
            return;
        }
        Map totalSettleAmtMap = StageSettleBillHelper.queryTotalSettleAmt((String)this.getAppId(), (Long)((Long)conObj.getPkValue()));
        model.set("totalsettleoriamt", totalSettleAmtMap.get("totalsettleoriamt"));
        model.set("totalsettleamt", totalSettleAmtMap.get("totalsettleamt"));
        model.set("oriamt", (Object)BigDecimal.ZERO);
        model.set("amount", (Object)BigDecimal.ZERO);
    }

    protected void updateStageSettleDataEntry(DynamicObject stageSettle, DynamicObject contract) {
        this.getModel().deleteEntryData("stagesettleentry");
        if (null == contract) {
            return;
        }
        DynamicObject[] dataStands = DataStandardHelper.getDataStandardArrByContract((String)this.getAppId(), (String)DataStandardBillEnum.STAGESETTLE.getValue(), (DynamicObject)contract);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("stagesettleentry");
        DynamicObjectType entryType = entrys.getDynamicObjectType();
        for (int i = 0; i < dataStands.length; ++i) {
            DynamicObject dataStand = dataStands[i];
            DynamicObject entry = new DynamicObject(entryType);
            entry.set("dataentry_datastandard", (Object)dataStand);
            entry.set("dataentry_verifyReport", null);
            entry.set("dataentry_verifyQty", null);
            entrys.add((Object)entry);
        }
        this.getModel().updateEntryCache(entrys);
    }
}

