/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.supplyconbill;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.pccs.concs.business.helper.ConSettleBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.OrgUtil;
import kd.pccs.concs.common.util.ParameterUtil;
import kd.pccs.concs.common.util.supplier.SupplierParam;
import kd.pccs.concs.common.util.supplier.SupplierUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplFormPlugin;
import kd.pccs.concs.formplugin.f7.ChgCfmF7SelectListener;
import kd.pccs.concs.formplugin.f7.ContractBillF7SelectListener;
import kd.pccs.concs.formplugin.supplyconbill.SupplyConBillOptCfmEntry;
import kd.pccs.concs.formplugin.supplyconbill.SupplyConBillPropertyChanged;

public class SupplyConBillFormPlugin
extends BillOrgTaxTplFormPlugin {
    @Override
    protected void initPropertyChanged() {
        this.propertyChanged = new SupplyConBillPropertyChanged(this, this.getModel());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerContractBillF7();
        this.registerChgCfmF7();
    }

    protected void registerChgCfmF7() {
        new ChgCfmF7SelectListener((AbstractFormPlugin)this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("chgentry_changebill")).setCustomQFilter((evt, qFilters) -> this.addChgCfmF7Filter(qFilters));
    }

    protected void addChgCfmF7Filter(List<QFilter> qFilters) {
        QFilter qFilter;
        DynamicObject suppConModel = this.getModel().getDataEntity(true);
        DynamicObject conBill = suppConModel.getDynamicObject("contractbill");
        if (null != conBill) {
            HashSet<Long> chgIds = new HashSet<Long>();
            DynamicObjectCollection conchgentry = suppConModel.getDynamicObjectCollection("supplyconchgentry");
            qFilter = new QFilter("contractbill", "=", (Object)((Long)conBill.getPkValue()));
            qFilter = qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()));
            qFilter = qFilter.and(new QFilter("refbillstatus", "=", (Object)" "));
            if (!conchgentry.isEmpty()) {
                for (DynamicObject entry : conchgentry) {
                    DynamicObject chgCfmInfo = entry.getDynamicObject("chgentry_changebill");
                    if (null == chgCfmInfo) continue;
                    chgIds.add((Long)chgCfmInfo.getPkValue());
                }
                if (chgIds.size() > 0) {
                    qFilter = qFilter.and(new QFilter("id", "not in", chgIds));
                }
            }
        } else {
            qFilter = new QFilter("id", "=", (Object)0L);
        }
        qFilters.add(qFilter);
    }

    protected void registerContractBillF7() {
        new ContractBillF7SelectListener(this, this.getModel()).registerListener((BasedataEdit)this.getView().getControl("contractbill")).setCustomQFilter((evt, qFilters) -> qFilters.add(new QFilter("id", "not in", (Object)ConSettleBillHelper.getHasSettledConIds((String)this.getAppId(), (long)OrgUtil.getCurrentOrgId((DynamicObject)this.getModel().getDataEntity())))));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCtrlMode();
    }

    protected void setCtrlMode() {
        IDataModel model = this.getModel();
        String ctrlMode = ParameterUtil.getParameter((String)this.getAppId(), (String)"param_supplyctrlmode", (Long)OrgUtil.getCurrentOrgId((DynamicObject)model.getDataEntity()));
        model.setValue("ctrlmode", (Object)ctrlMode);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deletechgentry": {
                this.deleteChgCfmEntry();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if ("deletechgentry".equals(operateKey)) {
            new SupplyConBillOptCfmEntry().afterOptSupplyConChgEntry(this.getModel());
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
    }

    private final void deleteChgCfmEntry() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid conCfmEntryGrid = (EntryGrid)view.getControl("supplyconchgentry");
        int[] rows = conCfmEntryGrid.getSelectRows();
        if (0 == rows.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"SupplyConBillFormPlugin_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
            return;
        }
        model.deleteEntryRows("supplyconchgentry", rows);
    }

    @Override
    protected void initSupplierName() {
        super.initSupplierName();
        String entityName = this.getView().getFormShowParameter().getFormId();
        SupplierUtil.handlerCommonSupplierName((SupplierParam)new SupplierParam("partyb", "partybname", entityName, this.getModel().getDataEntity(true), null));
    }
}

