/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.supplyconbill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.pccs.concs.common.util.NumberUtil;

public class SupplyConBillOptCfmEntry {
    public void afterOptSupplyConChgEntry(IDataModel model) {
        DynamicObject supplyBill = model.getDataEntity();
        boolean isMultiTaxRate = supplyBill.getBoolean("multitaxrateflag");
        if (isMultiTaxRate) {
            DynamicObjectCollection taxEntryCol = model.getEntryEntity("taxentry");
            Optional.ofNullable(taxEntryCol).ifPresent(col -> {
                BigDecimal oriAmtSum = BigDecimal.ZERO;
                BigDecimal taxSum = BigDecimal.ZERO;
                BigDecimal noTaxAmtSum = BigDecimal.ZERO;
                for (DynamicObject taxEntry : col) {
                    oriAmtSum = oriAmtSum.add(taxEntry.getBigDecimal("taxentry_oriamt"));
                    taxSum = taxSum.add(taxEntry.getBigDecimal("taxentry_tax"));
                    noTaxAmtSum = noTaxAmtSum.add(taxEntry.getBigDecimal("taxentry_notaxamt"));
                }
                model.setValue("oriamt", (Object)oriAmtSum);
                model.setValue("tax", (Object)taxSum);
                model.setValue("notaxamt", (Object)noTaxAmtSum);
                model.setValue("taxrate", (Object)NumberUtil.multiply((Object)NumberUtil.divide((Object)taxSum, (Object)noTaxAmtSum, (int)4), (Object)NumberUtil.ONE_HUNDRED));
            });
        } else {
            DynamicObjectCollection conCfmEntryCol = model.getEntryEntity("supplyconchgentry");
            Optional.ofNullable(conCfmEntryCol).ifPresent(col -> {
                BigDecimal oriAmtSum = BigDecimal.ZERO;
                for (DynamicObject conCfmEntryInfo : col) {
                    DynamicObject changeBill = conCfmEntryInfo.getDynamicObject("chgentry_changebill");
                    if (null == changeBill) continue;
                    oriAmtSum = oriAmtSum.add(changeBill.getBigDecimal("oriamt"));
                }
                model.setValue("oriamt", (Object)oriAmtSum);
            });
        }
    }
}

