/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.supplyconbill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.concs.common.enums.SuppFormWayEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import kd.pccs.concs.formplugin.billtpl.BillOrgTaxTplPropertyChanged;

public class SupplyConBillPropertyChanged
extends BillOrgTaxTplPropertyChanged {
    public SupplyConBillPropertyChanged(AbstractBillPlugIn plugin, IDataModel dataModel) {
        super(plugin, dataModel);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Optional.ofNullable(key).ifPresent(k -> {
            Object newVal = e.getChangeSet()[0].getNewValue();
            Optional.ofNullable(newVal).ifPresent(val -> {
                switch (k) {
                    case "contractbill": {
                        this.onchangeContractBill(val);
                        break;
                    }
                    case "formway": {
                        this.onchangeFormWay(val);
                        break;
                    }
                    case "project": {
                        this.onchangeProject(val);
                        break;
                    }
                    case "chgentry_changebill": {
                        this.onchangeChangeBill();
                        break;
                    }
                }
            });
        });
    }

    public void onchangeProject(Object newVal) {
        DynamicObject suppBill = this.getModel().getDataEntity();
        DynamicObject contract = suppBill.getDynamicObject("contractbill");
        Optional.ofNullable(contract).map(con -> con.getDynamicObject("project")).map(project -> project.getPkValue().toString()).filter(prjId -> !prjId.equals(((DynamicObject)newVal).getPkValue().toString())).ifPresent(o -> {
            suppBill.set("contractbill", null);
            this.getView().updateView("contractbill");
            this.getModel().deleteEntryData("taxentry");
            this.getModel().deleteEntryData("supplyconchgentry");
        });
    }

    public void onchangeChangeBill() {
        DynamicObject supplyBill = this.getModel().getDataEntity();
        boolean isMultiTaxRate = supplyBill.getBoolean("multitaxrateflag");
        DynamicObjectCollection chgCfmTaxEntryCol = new DynamicObjectCollection();
        DynamicObjectCollection suppChgEntryCol = this.getModel().getEntryEntity("supplyconchgentry");
        BigDecimal oriAmtSum = BigDecimal.ZERO;
        BigDecimal amtSum = BigDecimal.ZERO;
        if (suppChgEntryCol != null && suppChgEntryCol.size() > 0) {
            for (DynamicObject suppChgEntryInfo : suppChgEntryCol) {
                DynamicObject conCfmInfo = suppChgEntryInfo.getDynamicObject("chgentry_changebill");
                if (null == conCfmInfo) continue;
                conCfmInfo = BusinessDataServiceHelper.loadSingle((Object)conCfmInfo.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"chgcfmbill"), (String)String.join((CharSequence)",", "oriamt", "amount", "taxentry", "taxentry_amount", "taxentry_tax", "taxentry_notaxamt", "taxentry_content", "taxentry_taxrate", "taxentry_oriamt"));
                oriAmtSum = oriAmtSum.add(conCfmInfo.getBigDecimal("oriamt"));
                amtSum = NumberUtil.add((Object)amtSum, (Object)conCfmInfo.getBigDecimal("amount"));
                if (!isMultiTaxRate) continue;
                chgCfmTaxEntryCol.addAll((Collection)conCfmInfo.getDynamicObjectCollection("taxentry"));
            }
        }
        this.getModel().setValue("oriamt", (Object)oriAmtSum);
        this.getModel().setValue("amount", (Object)amtSum);
        int size = chgCfmTaxEntryCol.size();
        if (0 != size) {
            amtSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            BigDecimal noTaxAmtSum = BigDecimal.ZERO;
            DynamicObjectCollection suppTaxEntryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("taxentry");
            suppTaxEntryCol.clear();
            for (int i = 0; i < size; ++i) {
                DynamicObject taxEntryInfo = (DynamicObject)chgCfmTaxEntryCol.get(i);
                BigDecimal amout = taxEntryInfo.getBigDecimal("taxentry_amount");
                BigDecimal tax = taxEntryInfo.getBigDecimal("taxentry_tax");
                BigDecimal noTaxAmt = taxEntryInfo.getBigDecimal("taxentry_notaxamt");
                DynamicObject suppTaxEntry = suppTaxEntryCol.addNew();
                suppTaxEntry.set("taxentry_content", taxEntryInfo.get("taxentry_content"));
                suppTaxEntry.set("taxentry_amount", (Object)amout);
                suppTaxEntry.set("taxentry_taxrate", taxEntryInfo.get("taxentry_taxrate"));
                suppTaxEntry.set("taxentry_notaxamt", (Object)noTaxAmt);
                suppTaxEntry.set("taxentry_tax", (Object)tax);
                suppTaxEntry.set("taxentry_oriamt", (Object)taxEntryInfo.getBigDecimal("taxentry_oriamt"));
                amtSum = NumberUtil.add((Object)amtSum, (Object)amout);
                taxSum = taxSum.add(tax);
                noTaxAmtSum = noTaxAmtSum.add(noTaxAmt);
            }
            this.getModel().setValue("amount", (Object)amtSum);
            this.getModel().setValue("tax", (Object)taxSum);
            this.getModel().setValue("notaxamt", (Object)noTaxAmtSum);
            this.getModel().setValue("taxrate", (Object)NumberUtil.multiply((Object)NumberUtil.divide((Object)taxSum, (Object)noTaxAmtSum, (int)4), (Object)NumberUtil.ONE_HUNDRED));
            this.getView().updateView("taxentry");
        }
    }

    public void onchangeFormWay(Object newVal) {
        DynamicObject supplyBill = this.getModel().getDataEntity(true);
        DynamicObject contractBill = supplyBill.getDynamicObject("contractbill");
        Optional.ofNullable(contractBill).ifPresent(con -> {
            boolean isMultiCurrency = supplyBill.getBoolean("foreigncurrencyflag");
            BigDecimal oriAmt = supplyBill.getBigDecimal("oriamt");
            BigDecimal exchangeRate = supplyBill.getBigDecimal("exchangerate");
            if (SuppFormWayEnum.ADDSUPP.getValue().equals(newVal)) {
                if (isMultiCurrency) {
                    this.getModel().setValue("amount", (Object)oriAmt.multiply(exchangeRate));
                }
                this.getModel().getEntryEntity("supplyconchgentry").clear();
            } else {
                this.getModel().setValue("oriamt", (Object)0);
                if (isMultiCurrency) {
                    this.getModel().setValue("amount", (Object)oriAmt.multiply(exchangeRate));
                } else {
                    this.getModel().setValue("amount", (Object)0);
                }
            }
        });
        this.getView().updateView();
    }

    public void onchangeContractBill(Object conBill) {
        DynamicObject supplyBill = this.getModel().getDataEntity();
        DynamicObject contractBill = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)conBill).getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"contractbill"));
        DynamicObject project = supplyBill.getDynamicObject("project");
        if (null == project && null != contractBill.getDynamicObject("project")) {
            this.getModel().setValue("project", (Object)contractBill.getDynamicObject("project"));
        }
        boolean foreigncurrencyflag = contractBill.getBoolean("foreigncurrencyflag");
        boolean multitaxrateflag = contractBill.getBoolean("multitaxrateflag");
        if (SuppFormWayEnum.CHGTOSUPP.getValue().equals(supplyBill.getString("formway"))) {
            this.getModel().deleteEntryData("supplyconchgentry");
        }
        this.getModel().setValue("foreigncurrencyflag", (Object)foreigncurrencyflag);
        this.getModel().setValue("multitaxrateflag", (Object)multitaxrateflag);
        this.getModel().setValue("oricurrency", (Object)contractBill.getDynamicObject("oricurrency"));
        this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        this.getModel().setValue("partyb", (Object)contractBill.getDynamicObject("partyb"));
        this.getModel().setValue("exchangerate", (Object)contractBill.getBigDecimal("exchangerate"));
        this.getModel().setValue("taxrate", (Object)contractBill.getBigDecimal("taxrate"));
        this.getModel().setValue("bd_taxrate", (Object)contractBill.getDynamicObject("bd_taxrate"));
        this.getModel().setValue("org", (Object)contractBill.getDynamicObject("org"));
        if (multitaxrateflag && SuppFormWayEnum.ADDSUPP.getValue().equals(supplyBill.getString("formway"))) {
            DynamicObjectCollection suppTaxEntryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("taxentry");
            DynamicObjectCollection conTaxEntryCol = contractBill.getDynamicObjectCollection("taxentry");
            suppTaxEntryCol.clear();
            Optional.ofNullable(conTaxEntryCol).ifPresent(col -> {
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject taxEntryInfo = (DynamicObject)col.get(i);
                    DynamicObject suppTaxEntry = new DynamicObject(suppTaxEntryCol.getDynamicObjectType());
                    suppTaxEntry.set("taxentry_content", taxEntryInfo.get("taxentry_content"));
                    suppTaxEntry.set("taxentry_taxrate", taxEntryInfo.get("taxentry_taxrate"));
                    suppTaxEntryCol.add((Object)suppTaxEntry);
                }
                this.getView().updateView("taxentry");
            });
        }
    }
}

