/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.formplugin.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.WebOffice;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.pccs.concs.common.util.MetaDataUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class WebOfficeUtil {
    private static final Log logger = LogFactory.getLog(WebOfficeUtil.class);
    public static final String ID = "id";
    public static final String FNUMBER = "FNUMBER";
    public static final String FBILLTYPE = "FBillType";
    public static final String FINTERID = "FInterID";
    public static final String FMODIFYTIME = "FModifyTime";
    public static final String FATTACHMENTNAME = "FAttachmentName";
    public static final String FCREATETIME = "fcreatetime";
    public static final String FALIASFILENAME = "FaliasFileName";
    public static final String FEXTNAME = "FExtName";
    public static final String FATTACHMENTSIZE = "FATTACHMENTSIZE";
    public static final String FCREATEMEN = "FCREATEMEN";
    public static final String FATTACHMENTPANEL = "fattachmentpanel";
    public static final String FDESCRIPTION = "fdescription";
    public static final String FFILEID = "FFileId";
    public static final String CONBILL_ATTACHMENTPANEL = "attachmentpanel";
    public static final String CONTEMP_ATTACHMENTPANEL = "attachmentpanelap";
    public static final String BOS_ATTACHMENT = "bos_attachment";
    public static final String UTF8 = "utf-8";
    public static final String FILENAME = "fileName";
    public static final String FILEPATH = "filePath";
    public static final String URL = "url";
    public static final String MOB = "rc-upload-";

    public static Long uploadDoc(String appId, Long pkId, Long conDocFileId, String fileName, String url, boolean isContractBill) throws IOException {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
        if (null != conDocFileId) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{conDocFileId});
        }
        long id = ORM.create().genLongId(BOS_ATTACHMENT);
        dynamicObject.set(ID, (Object)id);
        dynamicObject.set(FNUMBER, (Object)(MOB + UUID.randomUUID().toString()));
        if (isContractBill) {
            dynamicObject.set(FBILLTYPE, (Object)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"));
            dynamicObject.set(FATTACHMENTPANEL, (Object)CONBILL_ATTACHMENTPANEL);
        } else {
            dynamicObject.set(FBILLTYPE, (Object)MetaDataUtil.getEntityId((String)appId, (String)"contemplate"));
            dynamicObject.set(FATTACHMENTPANEL, (Object)CONTEMP_ATTACHMENTPANEL);
        }
        dynamicObject.set(FINTERID, (Object)pkId);
        Date now = new Date();
        dynamicObject.set(FMODIFYTIME, (Object)now);
        dynamicObject.set(FCREATETIME, (Object)now);
        dynamicObject.set(FALIASFILENAME, (Object)fileName);
        dynamicObject.set(FATTACHMENTNAME, (Object)fileName);
        dynamicObject.set(FEXTNAME, (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        dynamicObject.set(FATTACHMENTSIZE, (Object)WebOfficeUtil.getFileSize(url));
        dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u6a21\u7248\u9644\u4ef6", (String)"WebOfficeUtil_0", (String)"pccs-concs-formplugin", (Object[])new Object[0]));
        dynamicObject.set(FFILEID, (Object)url);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getFileSize(String fileUrl) throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream in = fileService.getInputStream(fileUrl);
        if (null != in) {
            Integer available = null;
            try {
                available = in.available();
                Long l = available.longValue();
                return l;
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Throwable)e);
                }
            }
            finally {
                block14: {
                    try {
                        IOUtils.close((Closeable)in);
                    }
                    catch (IOException e) {
                        if (!logger.isErrorEnabled()) break block14;
                        logger.error((Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public static Map<String, String> handleFileUrl(Object[] urls, String docurl, String docname, String name) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof String) {
            String tFileName;
            String[] files;
            block5: {
                filePath = urlData.toString();
                fileName = filePath.substring(filePath.lastIndexOf(47));
                files = fileName.split("\\.");
                tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
                try {
                    tFileName = URLEncoder.encode(tFileName, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    if (!logger.isInfoEnabled()) break block5;
                    logger.info(e.getMessage());
                }
            }
            String tExtend = files.length == 2 ? files[1] : "doc";
            fileName = tFileName + '.' + tExtend;
            url = filePath;
        } else if (urlData instanceof Map) {
            filePath = ((Map)urlData).get(URL).toString();
            fileName = StringUtils.isBlank((String)docname) ? name : docname;
            url = filePath;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        return dataMap;
    }

    public static Map<String, String> uploadTempFile(String url, String docurl, String filePath, String fileName, Map fileNameData) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String appId = (String)fileNameData.get("appId");
        String formId = (String)fileNameData.get("formId");
        Object pkId = fileNameData.get("pkId");
        String turl = "";
        if (url.contains("tempfile")) {
            FileItem fileItem;
            FileService service;
            TempFileCache cache;
            block8: {
                cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                InputStream in = cache.getInputStream(url);
                service = FileServiceFactory.getAttachmentFileService();
                fileItem = null;
                if (StringUtils.isNotBlank((String)docurl)) {
                    fileItem = new FileItem(fileName, docurl, in);
                    fileItem.setCreateNewFileWhenExists(false);
                } else {
                    String utf8FileName;
                    block7: {
                        String suffix = StringUtils.isNotBlank((String)filePath) && filePath.endsWith(".docx") ? ".docx" : ".doc";
                        utf8FileName = fileName = fileName + suffix;
                        try {
                            utf8FileName = URLEncoder.encode(utf8FileName, UTF8);
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!logger.isInfoEnabled()) break block7;
                            logger.info(e.getMessage());
                        }
                    }
                    fileItem = new FileItem(utf8FileName, WebOfficeUtil.getAttachmentFileName(appId, formId, pkId, fileName), in);
                    fileItem.setCreateNewFileWhenExists(true);
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block8;
                    logger.info(e.getMessage());
                }
            }
            turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        return dataMap;
    }

    public static void openWebOfficeFile(WebOffice webOffice, String url, String fileName) {
        String tFileName;
        String[] files;
        String tUrl;
        block2: {
            tUrl = UrlService.getAttachmentFullUrl((String)url);
            String urlName = tUrl.substring(tUrl.lastIndexOf(47));
            files = urlName.split("\\.");
            tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isInfoEnabled()) break block2;
                logger.info(e.getMessage());
            }
        }
        String tExtend = files.length == 2 ? files[1] : "doc";
        fileName = tFileName + '.' + tExtend;
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
        tUrl = tUrl + fileName;
        webOffice.openAll(tUrl, fileName);
    }

    public static String getAttachmentFileName(String appId, String formId, Object pkId, String filename) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)pkId, (String)filename);
    }
}

