/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.common.enums;

import java.util.Arrays;
import kd.pccs.placs.common.enums.CompletionStatusEnum;

public enum TaskCompleteStatusMobColorEnum {
    UNSTART_COLOR(CompletionStatusEnum.UNSTART, "#D0DBFF"),
    PROGRESSING_COLOR(CompletionStatusEnum.PROGRESSING, "#00BBFF"),
    OVERDUE_COLOR(CompletionStatusEnum.OVERDUE, "#FB2323"),
    ONTIMECOMPLETE_COLOR(CompletionStatusEnum.ONTIMECOMPLETE, "#83F348"),
    OVERDUECOMPLETE_COLOR(CompletionStatusEnum.OVERDUECOMPLETE, "#2EECE9"),
    ESTIMATEDELAY_COLOR(CompletionStatusEnum.ESTIMATEDELAY, "#FFC000");

    private CompletionStatusEnum value;
    private String color;

    private TaskCompleteStatusMobColorEnum(CompletionStatusEnum value, String color) {
        this.value = value;
        this.color = color;
    }

    public static TaskCompleteStatusMobColorEnum findByCompleteStatus(String completeStatus) {
        CompletionStatusEnum completionStatusEnum = CompletionStatusEnum.getEnumByValue(completeStatus);
        return TaskCompleteStatusMobColorEnum.findByValue(completionStatusEnum);
    }

    public static TaskCompleteStatusMobColorEnum findByValue(CompletionStatusEnum completionStatusEnum) {
        TaskCompleteStatusMobColorEnum[] values = TaskCompleteStatusMobColorEnum.values();
        return Arrays.stream(values).filter(taskCompleteStatusMobColorEnum -> taskCompleteStatusMobColorEnum.getValue() == completionStatusEnum).findFirst().get();
    }

    public CompletionStatusEnum getValue() {
        return this.value;
    }

    public String getColor() {
        return this.color;
    }
}

