/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.common.enums;

import java.util.Arrays;
import java.util.Optional;
import kd.pccs.placs.common.enums.TaskTypeEnum;

public enum TaskTypeMobColorEnum {
    KEYNODE_COLOR(TaskTypeEnum.KEYNODE, "#FB2323", "#FFF2F4", "#FF8088"),
    KIMPORTANTNODE_COLOR(TaskTypeEnum.IMPORTANTNODE, "#FF991C", "#FFFBF2;", "#FFCB78"),
    GENERALNODE_COLOR(TaskTypeEnum.GENERALNODE, "#666666", "#F5F5F5", "#CCCCCC"),
    ROUTINEWORK_COLOR(TaskTypeEnum.ROUTINEWORK, "#666666", "#F5F5F5", "#CCCCCC"),
    ASSIGNTASK_COLOR(TaskTypeEnum.ASSIGNTASK, "#999999", "#FAFAFA", "#D9D9D9");

    private TaskTypeEnum value;
    private String foreColor;
    private String backColor;
    private String borderColor;

    private TaskTypeMobColorEnum(TaskTypeEnum value, String foreColor, String backColor, String borderColor) {
        this.value = value;
        this.foreColor = foreColor;
        this.backColor = backColor;
        this.borderColor = borderColor;
    }

    public static TaskTypeMobColorEnum findByValue(String taskTypeVal) {
        TaskTypeEnum taskTypeEnum = TaskTypeEnum.getEnumByValue(taskTypeVal);
        return TaskTypeMobColorEnum.findByValue(taskTypeEnum);
    }

    public static TaskTypeMobColorEnum findByValue(TaskTypeEnum taskTypeEnum) {
        TaskTypeMobColorEnum taskTypeMobColorEnum = GENERALNODE_COLOR;
        if (taskTypeEnum == null) {
            return taskTypeMobColorEnum;
        }
        TaskTypeMobColorEnum[] values = TaskTypeMobColorEnum.values();
        Optional<TaskTypeMobColorEnum> colorEnumOptional = Arrays.asList(values).stream().filter(taskType -> taskType.getValue() == taskTypeEnum).findFirst();
        if (colorEnumOptional.isPresent()) {
            taskTypeMobColorEnum = colorEnumOptional.get();
        }
        return taskTypeMobColorEnum;
    }

    public TaskTypeEnum getValue() {
        return this.value;
    }

    public String getForeColor() {
        return this.foreColor;
    }

    public String getBackColor() {
        return this.backColor;
    }

    public String getBorderColor() {
        return this.borderColor;
    }
}

