/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateUtil {
    private static final Log logger = LogFactory.getLog(DateUtil.class);
    public static final String DATEFORMAT = "yyyy-MM-dd";

    public static int compareByDay(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(oneDate);
        int year = calendar.get(1);
        int dayOfYear = calendar.get(6);
        calendar.clear();
        calendar.setTime(otherDate);
        int otherYear = calendar.get(1);
        int otherDayOfYear = calendar.get(6);
        if (year < otherYear) {
            return -1;
        }
        if (year > otherYear) {
            return 1;
        }
        if (dayOfYear < otherDayOfYear) {
            return -1;
        }
        if (dayOfYear > otherDayOfYear) {
            return 1;
        }
        return 0;
    }

    public static Date getDateAfterAddDays(Date srcDate, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcDate);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static int getDaysBetweenTwoDate(Date firstDate, Date secondDate) {
        if (firstDate == null || secondDate == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        int nDay = (int)((secondDate.getTime() - firstDate.getTime()) / 86400000L);
        return nDay;
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date getThisWeekMonday(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getThisWeekSunDay(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        Calendar cal = Calendar.getInstance();
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day + 6);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getLastWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getThisWeekMonday(date));
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getLastWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getThisWeekSunDay(date));
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getThisWeekMonday(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getNextWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getThisWeekSunDay(date));
        cal.add(5, 7);
        return cal.getTime();
    }

    public static Date getFirstDayOfThisMonth(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        Calendar cale = Calendar.getInstance();
        cale.setTime(date);
        cale.add(2, 0);
        cale.set(5, 1);
        return cale.getTime();
    }

    public static Date getLastDayOfThisMonth(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        Calendar cale = Calendar.getInstance();
        cale.setTime(date);
        cale.add(2, 1);
        cale.set(5, 0);
        cale.set(11, 23);
        cale.set(12, 59);
        cale.set(13, 59);
        return cale.getTime();
    }

    public static Date getFirstDayOfPreMonth(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date getLastDayOfPreMonth(Date date) {
        Date firstDayOfPreMonth = DateUtil.getFirstDayOfPreMonth(date);
        Date lastDayOfPreMonth = DateUtil.getLastDayOfThisMonth(firstDayOfPreMonth);
        return lastDayOfPreMonth;
    }

    public static Date getFirstDayOfNextMonth(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        String format = simpleDateFormat.format(date);
        try {
            date = simpleDateFormat.parse(format);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Date firstDayOfNextMonth = DateUtil.getFirstDayOfNextMonth(date);
        Date lastDayOfThisMonth = DateUtil.getLastDayOfThisMonth(firstDayOfNextMonth);
        return lastDayOfThisMonth;
    }

    public static Date getEndDayTime(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 0);
        return calendarEnd.getTime();
    }

    public static String monthDayClearZero(String dateStr) {
        Integer month = Integer.valueOf(dateStr.substring(5, 7));
        Integer day = Integer.valueOf(dateStr.substring(8, 10));
        StringBuilder res = new StringBuilder();
        res.append(month);
        res.append('-');
        res.append(day);
        return res.toString();
    }

    public static String formatShortDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static Date parseShortDate(String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT);
        Date parse = null;
        try {
            parse = simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        return parse;
    }

    public static Date parseDate(String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            parse = simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("parse date error!", (Throwable)e);
        }
        return parse;
    }

    public static Date getYearFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getHalfYearStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 6) {
                c.set(2, 0);
            } else if (currentMonth >= 7 && currentMonth <= 12) {
                c.set(2, 6);
            }
            c.set(5, 1);
            now = c.getTime();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return now;
    }

    public static Date getHalfYearEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            now = c.getTime();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return now;
    }

    public static Date getQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 6);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = c.getTime();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return now;
    }

    public static Date getQuarterEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            now = c.getTime();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return now;
    }

    public static Date getStartDayTime(Date date) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(date);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }
}

