/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.common.utils;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OperateHelper {
    private static final Log LOG = LogFactory.getLog(OperateHelper.class);

    public static OperationResult saveOperate(String billName, List<DynamicObject> targetBillObjs) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ignorewarn", String.valueOf(true));
            saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            saveOption.setVariableValue("strictvalidation", String.valueOf(true));
            saveOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)billName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResult.isSuccess()) {
                StringBuilder errMessage = OperateHelper.errorMsgHandle(saveResult);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"OperateHelper_0", (String)"pccs-placs-common", (Object[])new Object[0]), errMessage.toString()));
            }
            OperationResult operationResult = saveResult;
            return operationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static OperationResult submitOperate(String billName, OperationResult saveResult) {
        return OperateHelper.executeOperate(billName, saveResult, "submit");
    }

    public static OperationResult checkOperate(String billName, OperationResult result) {
        return OperateHelper.executeOperate(billName, result, "audit");
    }

    protected static OperationResult executeOperate(String billName, OperationResult saveResult, String operateKey) {
        return OperateHelper.executeOperate(billName, saveResult.getSuccessPkIds().toArray(), operateKey);
    }

    public static OperationResult executeOperate(String billName, Object[] ids, String operateKey) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            OperateOption operation = OperateOption.create();
            operation.setVariableValue("ignorewarn", String.valueOf(true));
            operation.setVariableValue("ignoreinteraction", String.valueOf(true));
            operation.setVariableValue("strictvalidation", String.valueOf(true));
            operation.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)operateKey, (String)billName, (Object[])ids, (OperateOption)operation);
            if (!result.isSuccess()) {
                StringBuilder errMessage = OperateHelper.errorMsgHandle(result);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a%s\u3002", (String)"OperateHelper_1", (String)"pccs-placs-common", (Object[])new Object[0]), errMessage));
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static OperationResult executeOperate(String billName, DynamicObject[] dataEntities, String operateKey) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            OperateOption operation = OperateOption.create();
            operation.setVariableValue("ignorewarn", String.valueOf(true));
            operation.setVariableValue("ignoreinteraction", String.valueOf(true));
            operation.setVariableValue("strictvalidation", String.valueOf(true));
            operation.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)operateKey, (String)billName, (DynamicObject[])dataEntities, (OperateOption)operation);
            if (!result.isSuccess()) {
                StringBuilder errMessage = OperateHelper.errorMsgHandle(result);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a%s\u3002", (String)"OperateHelper_1", (String)"pccs-placs-common", (Object[])new Object[0]), errMessage));
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected static StringBuilder errorMsgHandle(OperationResult operationResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(operationResult.getMessage());
        for (IOperateInfo errInfo : operationResult.getAllErrorOrValidateInfo()) {
            String detailMessage = errInfo.getMessage();
            LOG.error(detailMessage);
            errMessage.append(detailMessage);
        }
        return errMessage;
    }
}

