/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.common.utils.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.pccs.placs.common.utils.tree.Composite;
import kd.pccs.placs.common.utils.tree.Hierarchyable;

public class Hierarchy
implements Serializable {
    private static final long serialVersionUID = 6714923846602940014L;
    private Comparator<Hierarchyable> comparator = null;
    private boolean sort = false;
    private Composite rootNode = null;
    private HashMap<Long, Composite> items = new HashMap();

    public Hierarchy() {
    }

    public Hierarchy(boolean sort) {
        this.sort = sort;
    }

    public Hierarchy(Comparator<Hierarchyable> comparator) {
        this.comparator = comparator;
    }

    public Hierarchy(Comparator<Hierarchyable> comparator, boolean sort) {
        this.comparator = comparator;
        this.sort = sort;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public Comparator<Hierarchyable> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Hierarchyable> comparator) {
        this.comparator = comparator;
    }

    public Hierarchyable getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode.getNode();
        }
        return null;
    }

    public void setRootNode(Hierarchyable rootNode) {
        this.rootNode = new Composite(rootNode);
        this.items.put(rootNode.getId(), this.rootNode);
    }

    public synchronized void addObject(Hierarchyable object) {
        this.addNode(object);
    }

    public synchronized void addObject(Hierarchyable[] objectArray) {
        for (Hierarchyable object : objectArray) {
            this.addNode(object);
        }
    }

    public synchronized void addObject(List<Hierarchyable> objectArray) {
        for (Hierarchyable object : objectArray) {
            this.addNode(object);
        }
    }

    private void addNode(Hierarchyable hierarchy) {
        Long id = hierarchy.getId();
        Long parentId = hierarchy.getParentId();
        boolean add = false;
        Composite item = this.items.get(id);
        if (item == null) {
            item = new Composite(hierarchy);
            add = true;
        } else {
            if (item.getNode() == null) {
                add = true;
            }
            item.setNode(hierarchy);
        }
        this.items.put(id, item);
        Composite parent = this.items.get(parentId);
        if (parent == null && !parentId.equals(this.rootNode.getId())) {
            parent = new Composite(null);
            parent.getChildren().add(item);
            add = false;
            this.items.put(parentId, parent);
        }
        if (parent != null && add) {
            parent.getChildren().add(item);
        }
    }

    public synchronized boolean move(Hierarchyable movedNode, Hierarchyable toNode) {
        boolean result = false;
        if (this.rootNode != null) {
            Composite movedObj = this.items.get(movedNode.getId());
            Composite toObj = this.items.get(toNode.getId());
            if (movedObj != null && toObj != null) {
                movedObj.setParentId(toNode.getId());
                toObj.getChildren().add(movedObj);
                Composite parent = this.items.get(movedObj.getParentId());
                if (parent != null) {
                    parent.getChildren().remove(movedObj);
                }
                result = true;
            }
        }
        return result;
    }

    public synchronized void removeObject(Hierarchyable object) {
        if (this.rootNode != null) {
            Composite item = this.items.get(object.getId());
            Composite parent = this.items.get(object.getParentId());
            if (parent != null) {
                parent.getChildren().remove(item);
            }
            this.items.remove(object.getId());
        }
    }

    public List<Hierarchyable> getAllTreeNodes() {
        ArrayList<Hierarchyable> list = new ArrayList<Hierarchyable>();
        if (this.rootNode != null) {
            list.add(this.rootNode.getNode());
            list.addAll(this.getTreeNodes());
        }
        return list;
    }

    public List<Hierarchyable> getTreeNodes() {
        if (this.rootNode != null) {
            return this.getAllChildren(this.rootNode.getNode());
        }
        return null;
    }

    public List<Hierarchyable> getAllChildren(Hierarchyable object) {
        ArrayList<Hierarchyable> list = new ArrayList<Hierarchyable>();
        if (this.rootNode != null) {
            this.getChildren(list, object);
        }
        return list;
    }

    private void getChildren(List<Hierarchyable> list, Hierarchyable item) {
        List<Hierarchyable> childs = this.getDirectChildren(item);
        for (Hierarchyable child : childs) {
            list.add(child);
            if (this.getChildCount(child) <= 0) continue;
            this.getChildren(list, child);
        }
    }

    public List<Hierarchyable> getDirectChildren(Hierarchyable object) {
        Composite item;
        ArrayList<Hierarchyable> list = new ArrayList<Hierarchyable>();
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            ArrayList<Composite> childs = item.getChildren();
            for (Composite child : childs) {
                list.add(child.getNode());
            }
            if (this.sort && this.comparator != null) {
                Collections.sort(list, this.comparator);
            }
        }
        return list;
    }

    public List<Hierarchyable> getDirectChildren(Hierarchyable object, Comparator<Hierarchyable> comparator) {
        ArrayList<Hierarchyable> list = new ArrayList<Hierarchyable>();
        if (this.rootNode != null) {
            Composite item = null;
            item = this.items.get(object.getId());
            if (item != null) {
                ArrayList<Composite> childs = item.getChildren();
                for (Composite child : childs) {
                    list.add(child.getNode());
                }
                if (this.sort && comparator != null) {
                    Collections.sort(list, comparator);
                }
            }
        }
        return list;
    }

    public Hierarchyable getLastChild(Hierarchyable object) {
        List<Hierarchyable> children = this.getAllChildren(object);
        if (children.size() == 0) {
            return object;
        }
        return children.get(children.size() - 1);
    }

    public int getChildCount(Hierarchyable object) {
        Composite item;
        int result = 0;
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            result = item.getChildCount();
        }
        return result;
    }

    public boolean isFirstChild(Hierarchyable object) {
        Composite item;
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            Composite parent = this.items.get(item.getParentId());
            return this.isExistFirstChild(item, parent);
        }
        return false;
    }

    private boolean isExistFirstChild(Composite item, Composite parent) {
        Composite child;
        return parent != null && parent.getChildCount() > 0 && (child = parent.getChildren().get(0)) != null && child.getId().equals(item.getId());
    }

    public boolean isLastChild(Hierarchyable object) {
        Composite item;
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            Composite parent = this.items.get(item.getParentId());
            return this.isExistLastChild(item, parent);
        }
        return false;
    }

    private boolean isExistLastChild(Composite item, Composite parent) {
        Composite child;
        return parent != null && parent.getChildCount() > 0 && (child = parent.getChildren().get(parent.getChildCount() - 1)) != null && child.getId().equals(item.getId());
    }

    public List<Hierarchyable> getAllParent(Hierarchyable object) {
        Composite item;
        ArrayList<Hierarchyable> list = new ArrayList<Hierarchyable>();
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            this.addParentNode(list, item);
        }
        return list;
    }

    private void addParentNode(ArrayList<Hierarchyable> list, Composite item) {
        Composite parent = this.items.get(item.getParentId());
        while (parent != null && parent.getNode() != null) {
            list.add(parent.getNode());
            if (parent.getId().equals(this.rootNode.getId())) break;
            parent = this.items.get(parent.getParentId());
        }
    }

    public Hierarchyable getParents(Hierarchyable object, int level) {
        Composite item;
        Hierarchyable node = null;
        if (level == 0) {
            return object;
        }
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            Composite parent = this.items.get(item.getParentId());
            node = this.getParentNodeOnLevel(parent, level);
        }
        return node;
    }

    private Hierarchyable getParentNodeOnLevel(Composite parent, int level) {
        int levels = 0;
        while (parent != null && parent.getNode() != null) {
            if (++levels == level) {
                return parent.getNode();
            }
            if (parent.getId().equals(this.rootNode.getId())) break;
            parent = this.items.get(parent.getParentId());
        }
        return null;
    }

    public int getLevel(Hierarchyable object) {
        Composite item;
        int result = 0;
        if (this.rootNode != null && (item = this.items.get(object.getId())) != null) {
            Composite parent = this.items.get(item.getParentId());
            return this.getParentLevel(parent, result);
        }
        return result;
    }

    private int getParentLevel(Composite parent, int result) {
        while (parent != null && parent.getNode() != null && !parent.getId().equals(this.rootNode.getId())) {
            ++result;
            parent = this.items.get(parent.getParentId());
        }
        return result;
    }

    public boolean contains(Hierarchyable object) {
        boolean result = false;
        Composite item = this.items.get(object.getId());
        if (item != null) {
            result = true;
        }
        return result;
    }

    public void clear() {
        this.rootNode = null;
        this.items.clear();
    }

    public Hierarchyable getObject(Hierarchyable object) {
        return this.getObject(object.getId());
    }

    public Hierarchyable getObject(long id) {
        Hierarchyable result = null;
        Composite item = this.items.get(id);
        if (item != null) {
            result = item.getNode();
        }
        return result;
    }

    public List<Hierarchyable> getObjectByName(String name) {
        ArrayList<Hierarchyable> result = new ArrayList<Hierarchyable>();
        if (name == null || "".equals(name)) {
            return new ArrayList<Hierarchyable>();
        }
        List<Hierarchyable> allChildren = this.getAllChildren(this.getRootNode());
        for (int i = 0; i < allChildren.size(); ++i) {
            if (allChildren.get(i).getName().indexOf(name) < 0) continue;
            result.add(allChildren.get(i));
        }
        return result;
    }
}

