/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class AssignTaskOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("relationtask");
        e.getFieldKeys().add("expecttime");
        e.getFieldKeys().add("percent");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("sourcetask");
        e.getFieldKeys().add("islatest");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("prechangetask");
        e.getFieldKeys().add("assigner");
        e.getFieldKeys().add("planendtime");
        e.getFieldKeys().add("planstarttime");
        e.getFieldKeys().add("transactiontype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                this.verifyTaskDate(dataEntities);
                this.changeTaskStatus(dataEntities, operationKey);
                this.checkPlanTime(dataEntities);
                this.checkExistResultDoc(dataEntities);
                break;
            }
            case "unsubmit": {
                this.changeTaskStatus(dataEntities, operationKey);
                break;
            }
            case "audit": {
                this.changeStatus(dataEntities);
                this.riskColorSet(dataEntities);
                this.updateTaskCompleteStatus(dataEntities);
                this.changePreTaskStatus(dataEntities);
                this.updateReference(dataEntities);
                break;
            }
        }
    }

    protected void checkExistResultDoc(DynamicObject[] dataEntities) {
        for (DynamicObject task : dataEntities) {
            DynamicObjectCollection resultDocCollection;
            boolean hasResultDoc = false;
            DynamicObjectCollection txCollect = task.getDynamicObjectCollection("transactiontype");
            for (DynamicObject tx : txCollect) {
                Long baseDataId = tx.getLong("fbasedataid_id");
                DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
                hasResultDoc = true;
            }
            if (!hasResultDoc || (resultDocCollection = task.getDynamicObjectCollection("taskresultdocentry")).size() > 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e1a\u52a1\u7c7b\u578b\u5305\u542b\u6210\u679c\u7c7b\u578b\uff0c\u8bf7\u5f55\u5165\u5bf9\u5e94\u7684\u201c\u6210\u679c\u660e\u7ec6\u201d\u3002", (String)"AssignTaskOp_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]), new Object[0]);
            throw new KDBizException(msg);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(8);
        if ("audit".equals(key)) {
            for (DynamicObject bill : dataEntities) {
                if (bill.getDynamicObject("assigner") != null || bill.getDynamicObject("auditor") == null) continue;
                bill.set("assigner", (Object)bill.getDynamicObject("auditor"));
                billList.add(bill);
            }
            if (billList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
            }
        }
    }

    protected void updateReference(DynamicObject[] dataEntities) {
        for (DynamicObject task : dataEntities) {
            DynamicObject[] workHourObjs;
            DynamicObject preTask = (DynamicObject)task.get("prechangetask");
            if (null == preTask) continue;
            QFilter workHoursFilter = new QFilter("task", "in", preTask.getPkValue());
            for (DynamicObject workHour : workHourObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"), (String)"task", (QFilter[])new QFilter[]{workHoursFilter})) {
                workHour.set("task", (Object)task);
            }
        }
    }

    protected void changePreTaskStatus(DynamicObject[] dataEntities) {
        ArrayList preChangeTaskList = new ArrayList();
        Stream.of(dataEntities).forEach(task -> {
            DynamicObject preTask = (DynamicObject)task.get("prechangetask");
            if (null != preTask) {
                preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getPkValue(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
                preTask.set("islatest", (Object)DefaultEnum.NO.getValue());
                preChangeTaskList.add(preTask);
            }
        });
        SaveServiceHelper.update((DynamicObject[])preChangeTaskList.toArray(new DynamicObject[preChangeTaskList.size()]));
    }

    protected void riskColorSet(DynamicObject[] currentTaskEntry) {
        Set taskIds = Stream.of(currentTaskEntry).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(',').append("controllevel").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("tasktype").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        RiskColorUtil.setColor((String)this.getAppId(), (DynamicObject[])tasks, (boolean)true);
        SaveServiceHelper.update((DynamicObject[])tasks);
    }

    protected void changeStatus(DynamicObject[] dataEntities) {
        for (DynamicObject task : dataEntities) {
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            if (null == sourceTask) {
                task.set("sourcetask", (Object)task);
            }
            task.set("status", (Object)StatusEnum.CHECKED.getValue());
            task.set("islatest", (Object)DefaultEnum.YES.getValue());
        }
    }

    protected void checkPlanTime(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            Date endDate = dataEntity.getDate("planendtime");
            Date beginDate = dataEntity.getDate("planstarttime");
            if (endDate == null || beginDate == null || endDate.compareTo(beginDate) >= 0) continue;
            String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u5df2\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002", (String)"AssignTaskOp_5", (String)"pccs-placs-opplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    protected void updateTaskCompleteStatus(DynamicObject[] dataEntities) {
        Stream.of(dataEntities).forEach(task -> {
            BigDecimal oneHundred = BigDecimal.valueOf(100.0);
            DynamicObject relateTask = task.getDynamicObject("relationtask");
            BigDecimal percent = task.getBigDecimal("percent");
            if (relateTask != null || percent.compareTo(oneHundred) == 0) {
                return;
            }
            Date planStartTime = task.getDate("planstarttime");
            Date planEndTime = task.getDate("planendtime");
            Date expectTime = task.getDate("expecttime");
            Date currentDate = new Date();
            if (DateUtil.compareByDay((Date)planStartTime, (Date)currentDate) > 0 && percent.compareTo(BigDecimal.ZERO) == 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
            } else if (expectTime != null && DateUtil.compareByDay((Date)expectTime, (Date)planEndTime) > 0 && percent.compareTo(BigDecimal.ZERO) > 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.ESTIMATEDELAY.getValue());
            } else if (DateUtil.compareByDay((Date)planEndTime, (Date)currentDate) < 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            } else {
                task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            }
        });
    }

    protected void verifyTaskDate(DynamicObject[] dataEntities) {
        for (DynamicObject task : dataEntities) {
            if ("0".equals(task.getPkValue().toString()) || task == null) continue;
            Date endDate = task.getDate("planendtime");
            Date beginDate = task.getDate("planstarttime");
            if (endDate != null && beginDate != null && endDate.compareTo(beginDate) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"AssignTaskOp_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                throw new KDBizException(msg);
            }
            if (null == endDate || DateUtil.compareByDay((Date)endDate, (Date)new Date()) > -1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"AssignTaskOp_6", (String)"pccs-placs-opplugin", (Object[])new Object[0]));
        }
    }

    protected void changeTaskStatus(DynamicObject[] tasks, String operationKey) {
        Stream.of(tasks).forEach(task -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)"submit", (CharSequence)operationKey)) {
                task.set("status", (Object)StatusEnum.UNCHECKED.getValue());
                task.set("isleaf", (Object)DefaultEnum.YES.getValue());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"audit", (CharSequence)operationKey)) {
                task.set("status", (Object)StatusEnum.CHECKED.getValue());
            } else {
                task.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
            }
        });
    }
}

