/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.base.BaseOp;

public class AssistTransferOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("atransferdate");
        e.getFieldKeys().add("pmulticooperationperson");
        e.getFieldKeys().add("amulticooperationperson");
        e.getFieldKeys().add("amulticooperationdept");
        e.getFieldKeys().add("atransferperson");
        e.getFieldKeys().add("aremark");
        e.getFieldKeys().add("atask");
        e.getFieldKeys().add("atransfertime");
        e.getFieldKeys().add("astatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "save": {
                DynamicObject[] transfers;
                ArrayList<Long> taskIds = new ArrayList<Long>();
                DynamicObjectCollection assistentityList = dataEntities[0].getDynamicObjectCollection("assistentity");
                for (DynamicObject assistentity : assistentityList) {
                    taskIds.add(assistentity.getLong("atask_id"));
                }
                QFilter taskidFilter = new QFilter("assistentity.atask", "in", taskIds);
                QFilter islatestFilter = new QFilter("islatest", "=", (Object)DefaultEnum.YES.getValue());
                QFilter[] ofilters = new QFilter[]{taskidFilter, islatestFilter};
                for (DynamicObject transfer : transfers = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assisttasktransfer"), (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, multicooperationdept1, date, remark1, multicooperationperson, person, islatest,assistentity.islatesta", (QFilter[])ofilters)) {
                    if (transfer.getPkValue().equals(dataEntities[0].getPkValue())) continue;
                    transfer.set("islatest", (Object)DefaultEnum.NO.getValue());
                    for (DynamicObject entity : transfer.getDynamicObjectCollection("assistentity")) {
                        entity.set("islatesta", (Object)DefaultEnum.NO.getValue());
                    }
                }
                SaveServiceHelper.update((DynamicObject[])transfers);
                break;
            }
            case "submit": {
                this.updateAssistEntityData(dataEntities[0], StatusEnum.UNCHECKED.getValue());
                break;
            }
            case "unsubmit": {
                this.updateAssistEntityData(dataEntities[0], StatusEnum.TEMPSAVE.getValue());
                break;
            }
            case "audit": {
                this.updateAssistEntityData(dataEntities[0], StatusEnum.CHECKED.getValue());
                this.transferAssist(dataEntities[0]);
                break;
            }
        }
    }

    public void updateAssistEntityData(DynamicObject dataEntity, String billstatus) {
        DynamicObject[] assists;
        DynamicObjectCollection assistentityList = dataEntity.getDynamicObjectCollection("assistentity");
        ArrayList<Object> assistIds = new ArrayList<Object>();
        for (DynamicObject assist : assistentityList) {
            assistIds.add(assist.getPkValue());
        }
        QFilter assistId = new QFilter("id", "in", assistIds);
        QFilter[] filters = new QFilter[]{assistId};
        for (DynamicObject dt : assists = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"assisttransfer"), (String)"atransferdate, pmulticooperationperson, amulticooperationperson, amulticooperationdept, atransferperson, aremark, atransfertime, astatus, islatesta", (QFilter[])filters)) {
            dt.set("astatus", (Object)billstatus);
        }
        SaveServiceHelper.save((DynamicObject[])assists);
    }

    public void transferAssist(DynamicObject dataEntity) {
        ORM orm = ORM.create();
        DynamicObjectCollection assistentityList = dataEntity.getDynamicObjectCollection("assistentity");
        ArrayList<Object> taskIds = new ArrayList<Object>(10);
        for (DynamicObject dt : assistentityList) {
            taskIds.add(dt.getDynamicObject("atask").getPkValue());
        }
        QFilter taskid = new QFilter("id", "in", taskIds);
        QFilter[] filters = new QFilter[]{taskid};
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,sharer,responsibleperson,multicooperationperson,responsibledept,multicooperationdept,relationtask", (QFilter[])filters);
        DynamicObjectCollection amulticooperationperson = ((DynamicObject)assistentityList.get(0)).getDynamicObjectCollection("amulticooperationperson");
        DynamicObject[] coopers = (DynamicObject[])amulticooperationperson.toArray((Object[])new DynamicObject[amulticooperationperson.size()]);
        DynamicObjectCollection amulticooperationdept = ((DynamicObject)assistentityList.get(0)).getDynamicObjectCollection("amulticooperationdept");
        DynamicObject[] coodepts = (DynamicObject[])amulticooperationdept.toArray((Object[])new DynamicObject[amulticooperationdept.size()]);
        for (DynamicObject task : tasks) {
            DynamicObjectCollection transferCooPersons = new DynamicObjectCollection();
            DynamicObjectType coopersonDT = task.getDynamicObjectCollection("multicooperationperson").getDynamicObjectType();
            for (int i = 0; i < coopers.length; ++i) {
                DynamicObject cooper = new DynamicObject(coopersonDT);
                cooper.set("pkid", (Object)orm.genLongId((IDataEntityType)coopersonDT));
                cooper.set("fbasedataid", coopers[i].get("fbasedataid"));
                cooper.set("fbasedataid_id", coopers[i].get("fbasedataid_id"));
                transferCooPersons.add((Object)cooper);
            }
            DynamicObjectCollection transferCooDepts = new DynamicObjectCollection();
            DynamicObjectType coodeptDT = task.getDynamicObjectCollection("multicooperationdept").getDynamicObjectType();
            for (int i = 0; i < coodepts.length; ++i) {
                DynamicObject coodept = new DynamicObject(coodeptDT);
                coodept.set("pkid", (Object)orm.genLongId((IDataEntityType)coodeptDT));
                coodept.set("fbasedataid", coodepts[i].get("fbasedataid"));
                coodept.set("fbasedataid_id", coodepts[i].get("fbasedataid_id"));
                transferCooDepts.add((Object)coodept);
            }
            task.set("multicooperationperson", (Object)transferCooPersons);
            task.set("multicooperationdept", (Object)transferCooDepts);
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }
}

