/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.DateUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.DeptPlanValidator;
import kd.pccs.placs.opplugin.base.BaseOp;
import org.apache.commons.collections.CollectionUtils;

public class DeptPlanOp
extends BaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("sourceplan");
        e.getFieldKeys().add("prechangeplan");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("STARTTIME");
        e.getFieldKeys().add("ENDTIME");
        e.getFieldKeys().add("taskentity");
        e.getFieldKeys().add("relationtask");
        e.getFieldKeys().add("islatest");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("taskstarttimetx");
        e.getFieldKeys().add("taskendtimetx");
        e.getFieldKeys().add("prechangetask");
        e.getFieldKeys().add("completionstatus");
        e.getFieldKeys().add("multicooperationperson");
        e.getFieldKeys().add("multicooperationdept");
        e.getFieldKeys().add("respersontx");
        e.getFieldKeys().add("resdepttx");
        e.getFieldKeys().add("tasknametx");
        e.getFieldKeys().add("pid");
        e.getFieldKeys().add("assigner");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("transactiontype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DeptPlanValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"submit")) {
            this.checkExistResultDocs(dataEntities);
            for (DynamicObject bill : dataEntities) {
                bill.set("planstatus", (Object)PlanEnum.CHECKING.getValue());
            }
            this.verifyTaskDate(dataEntities);
            this.updateTaskCompleteStatus(dataEntities);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"unsubmit")) {
            for (DynamicObject bill : dataEntities) {
                bill.set("planstatus", (Object)PlanEnum.CREATEING.getValue());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"audit")) {
            this.onAudit(dataEntities);
            this.updateReference(dataEntities);
            this.SyncData(dataEntities);
        }
    }

    protected void verifyTaskDate(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            if ("0".equals(bill.getPkValue().toString())) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
            HashMap<String, DynamicObject> pkId2Task = new HashMap<String, DynamicObject>(entries.size());
            for (DynamicObject task : entries) {
                String msg;
                pkId2Task.put(task.getPkValue().toString(), task);
                DynamicObject parentTask = (DynamicObject)pkId2Task.get(task.getString("pid"));
                if (parentTask != null) {
                    Date parentEndDate;
                    Date parentBeginDate;
                    Date beginDate = task.getDate("taskstarttimetx");
                    if (beginDate.compareTo(parentBeginDate = parentTask.getDate("taskstarttimetx")) < 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanOp_4", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                        throw new KDBizException(msg);
                    }
                    Date endDate = task.getDate("taskendtimetx");
                    if (endDate.compareTo(parentEndDate = parentTask.getDate("taskendtimetx")) > 0) {
                        String msg2 = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanOp_5", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                        throw new KDBizException(msg2);
                    }
                }
                if (task == null) continue;
                Date endDate = task.getDate("taskendtimetx");
                Date beginDate = task.getDate("taskstarttimetx");
                if (endDate == null || beginDate == null || endDate.compareTo(beginDate) >= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanOp_5", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("name"));
                throw new KDBizException(msg);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(8);
        if ("audit".equals(key)) {
            for (DynamicObject bill : dataEntities) {
                if (bill.getDynamicObject("assigner") != null || bill.getDynamicObject("auditor") == null) continue;
                bill.set("assigner", (Object)bill.getDynamicObject("auditor"));
                billList.add(bill);
            }
            if (billList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[billList.size()]));
            }
            this.updateTaskAssigner(dataEntities);
        }
    }

    private void updateTaskAssigner(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObject[] taskArr;
            DynamicObject assigner = bill.getDynamicObject("assigner");
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(8);
            QFilter planIdFilter = new QFilter("planid", "=", (Object)Long.valueOf(bill.getString("id")));
            for (DynamicObject task : taskArr = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"assigner", (QFilter[])new QFilter[]{planIdFilter})) {
                task.set("assigner", (Object)assigner);
                taskList.add(task);
            }
            if (taskList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[taskList.size()]));
        }
    }

    protected void changeTaskStatus(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection taskEntries = bill.getDynamicObjectCollection("taskentity");
            List<Object> taskIds = taskEntries.stream().map(entry -> entry.getPkValue().toString()).collect(Collectors.toList());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Object[taskIds.size()]), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
            if (tasks == null || tasks.length <= 0) {
                return;
            }
            for (int i = 0; i < tasks.length; ++i) {
                DynamicObject task = tasks[i];
                task.set("status", (Object)StatusEnum.UNCHECKED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])tasks);
        }
    }

    protected void updateTaskCompleteStatus(DynamicObject[] dataEntities) {
        Date currentDate = new Date();
        for (DynamicObject plan : dataEntities) {
            DynamicObjectCollection taskEntries = plan.getDynamicObjectCollection("taskentity");
            if (taskEntries == null || taskEntries.isEmpty()) continue;
            for (DynamicObject task : taskEntries) {
                int result2;
                Date planEndTime;
                int result1;
                String complteStatus = task.getString("completionstatus");
                DynamicObject relateTask = task.getDynamicObject("relationtask");
                if (relateTask != null || !StringUtils.equals((CharSequence)complteStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue())) continue;
                Date planStartTime = task.getDate("taskstarttimetx");
                if (planStartTime != null && (result1 = DateUtil.compareByDay((Date)planStartTime, (Date)currentDate)) != 1) {
                    task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
                }
                if ((planEndTime = task.getDate("taskendtimetx")) == null || (result2 = DateUtil.compareByDay((Date)planEndTime, (Date)currentDate)) != -1) continue;
                task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
            }
        }
    }

    protected void onAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> parentList = new ArrayList<DynamicObject>(dataEntities.length);
        HashMap<Object, Object> newIdMap = new HashMap<Object, Object>(16);
        for (DynamicObject bill : dataEntities) {
            BigDecimal version = (BigDecimal)bill.get("version");
            int intVersion = version.intValue();
            Long parentBillId = (Long)bill.get("prechangeplan");
            if (intVersion != 1 && parentBillId != 0L) {
                DynamicObject parentBill = BusinessDataServiceHelper.loadSingle((Object)parentBillId, (String)(this.getAppId() + "_" + "deptplan"));
                parentBill.set("planstatus", (Object)PlanEnum.HISTORY.getValue());
                DynamicObjectCollection entries = parentBill.getDynamicObjectCollection("taskentity");
                for (DynamicObject entry : entries) {
                    entry.set("islatest", (Object)"0");
                }
                parentList.add(parentBill);
            }
            bill.set("planstatus", (Object)PlanEnum.PUBLISHED.getValue());
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
            for (DynamicObject entry : entries) {
                entry.set("islatest", (Object)"1");
                entry.set("status", (Object)StatusEnum.CHECKED.getValue());
                DynamicObject preTask = entry.getDynamicObject("prechangetask");
                if (entry.getDynamicObject("relationtask") != null || preTask == null) continue;
                newIdMap.put(preTask.getPkValue(), entry.getPkValue());
            }
            if (intVersion == 1 || 0L == parentBillId) continue;
            this.riskColorSet(entries);
        }
        SaveServiceHelper.save((DynamicObject[])parentList.toArray(new DynamicObject[parentList.size()]));
        this.updateWorkHoursData(newIdMap);
    }

    protected void riskColorSet(DynamicObjectCollection entries) {
        Set taskIds = entries.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(',').append("controllevel").append(',').append("planendtime").append(',').append("riskcolor").append(',').append("islatest").append(',').append("sourcetask").append(',').append("prechangetask").append(',').append("tasktype").append(',').append("project").append(',').append("belongplantype").append(',').append("planid");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        RiskColorUtil.setColor((String)this.getAppId(), (DynamicObject[])tasks, (boolean)true);
        SaveServiceHelper.update((DynamicObject[])tasks);
    }

    protected void updateWorkHoursData(Map<Object, Object> ref) {
        DynamicObject[] workHourTasks;
        QFilter filter = new QFilter("task", "in", ref.keySet());
        for (DynamicObject workHour : workHourTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"workhours"), (String)"task", (QFilter[])new QFilter[]{filter})) {
            DynamicObject workHourTask = workHour.getDynamicObject("task");
            if (!ref.containsKey(workHourTask.getPkValue())) continue;
            workHour.set("task", ref.get(workHourTask.getPkValue()));
        }
        SaveServiceHelper.update((DynamicObject[])workHourTasks);
    }

    protected void updateReference(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject[] tasks;
            DynamicObjectCollection taskEntries = dataEntity.getDynamicObjectCollection("taskentity");
            Map<Object, DynamicObject> ref = taskEntries.stream().filter(entry -> entry.getDynamicObject("prechangetask") != null).collect(Collectors.toMap(task -> task.getDynamicObject("prechangetask").getPkValue(), task -> task));
            QFilter filter = new QFilter("relationtask", "in", ref.keySet());
            for (DynamicObject task2 : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"relationtask,belongplantype,planid", (QFilter[])new QFilter[]{filter})) {
                DynamicObject relationTask;
                DynamicObject belongPlanType = task2.getDynamicObject("belongplantype");
                if (belongPlanType == null) {
                    String planId = task2.getString("planid");
                    QFilter idFilter = new QFilter("id", "=", (Object)planId);
                    DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"personplan"), (String)"name", (QFilter[])new QFilter[]{idFilter});
                    if (plan == null) continue;
                }
                if (!ref.containsKey((relationTask = task2.getDynamicObject("relationtask")).getPkValue())) continue;
                task2.set("relationtask", (Object)ref.get(relationTask.getPkValue()));
            }
            SaveServiceHelper.update((DynamicObject[])tasks);
            HashMap<Object, Integer> task2meetcount = new HashMap<Object, Integer>(taskEntries.size());
            QFilter meettasksFilter = new QFilter("meettask", "in", (Object)ref.keySet().toArray());
            DynamicObject[] meettasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"meettask", (QFilter[])new QFilter[]{meettasksFilter});
            for (DynamicObject meettask : meettasks) {
                DynamicObject curTask = ref.get(meettask.getDynamicObject("meettask").getPkValue());
                meettask.set("meettask", (Object)curTask);
                task2meetcount.put(curTask.getPkValue(), task2meetcount.getOrDefault(curTask.getPkValue(), 0) + 1);
            }
            for (DynamicObject task3 : taskEntries) {
                if (!task2meetcount.containsKey(task3.getPkValue())) continue;
                task3.set("meetassigncount", task2meetcount.get(task3.getPkValue()));
            }
            if (meettasks.length <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])meettasks);
        }
    }

    protected void SyncData(DynamicObject[] bills) {
        ArrayList<DynamicObject> relationTasks = null;
        ArrayList<DynamicObject> associatedTasks = null;
        ArrayList<DynamicObject> personTasksList = null;
        ORM orm = ORM.create();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection tasks = bill.getDynamicObjectCollection("taskentity");
            relationTasks = new ArrayList<DynamicObject>(10);
            associatedTasks = new ArrayList<DynamicObject>(10);
            personTasksList = new ArrayList<DynamicObject>(10);
            for (DynamicObject task : tasks) {
                DynamicObject relationTask;
                DynamicObjectCollection cooPerontx = task.getDynamicObjectCollection("multicooperationperson");
                DynamicObjectCollection cooDepttx = task.getDynamicObjectCollection("multicooperationdept");
                QFilter qFilterPerson = new QFilter("relationtask", "=", task.getPkValue());
                DynamicObject[] personTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{qFilterPerson});
                if (personTasks.length > 0) {
                    for (DynamicObject personTask : personTasks) {
                        personTask.set("responsibleperson", (Object)task.getDynamicObject("respersontx").getPkValue().toString());
                        personTask.set("responsibledept", (Object)task.getDynamicObject("resdepttx").getPkValue().toString());
                        DynamicObjectCollection cooPersons = new DynamicObjectCollection();
                        DynamicObjectType cooPersonDT = cooPerontx.getDynamicObjectType();
                        for (DynamicObject cooper : cooPerontx) {
                            DynamicObject newcooper = new DynamicObject(cooPersonDT);
                            newcooper.set("pkid", (Object)orm.genLongId((IDataEntityType)cooPersonDT));
                            newcooper.set("fbasedataid", cooper.get("fbasedataid"));
                            newcooper.set("fbasedataid_id", cooper.get("fbasedataid_id"));
                            cooPersons.add((Object)newcooper);
                        }
                        DynamicObjectCollection cooDepts = new DynamicObjectCollection();
                        DynamicObjectType cooDeptDT = cooDepttx.getDynamicObjectType();
                        for (DynamicObject coodept : cooDepttx) {
                            DynamicObject newcoodept = new DynamicObject(cooDeptDT);
                            newcoodept.set("pkid", (Object)orm.genLongId((IDataEntityType)cooDeptDT));
                            newcoodept.set("fbasedataid", coodept.get("fbasedataid"));
                            newcoodept.set("fbasedataid_id", coodept.get("fbasedataid_id"));
                            cooDepts.add((Object)newcoodept);
                        }
                        if (null != cooPerontx && cooPerontx.size() > 0) {
                            personTask.set("multicooperationperson", (Object)cooPersons);
                            personTask.set("multicooperationdept", (Object)cooDepts);
                        } else {
                            personTask.set("multicooperationperson", null);
                            personTask.set("multicooperationdept", null);
                        }
                        personTasksList.add(personTask);
                    }
                }
                if (null == (relationTask = task.getDynamicObject("relationtask")) || null == (relationTask = BusinessDataServiceHelper.loadSingle((Object)relationTask.getPkValue().toString(), (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task")))) continue;
                QFilter qFilter = new QFilter("relationtask", "=", relationTask.getPkValue());
                DynamicObject[] assocTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)TaskConstant.AllProperty, (QFilter[])new QFilter[]{qFilter});
                relationTask.set("responsibleperson", (Object)task.getDynamicObject("respersontx").getPkValue().toString());
                relationTask.set("responsibledept", (Object)task.getDynamicObject("resdepttx").getPkValue().toString());
                if (null != cooPerontx && cooPerontx.size() > 0) {
                    DynamicObjectCollection cooPersons = new DynamicObjectCollection();
                    DynamicObjectType cooPersonDT = cooPerontx.getDynamicObjectType();
                    for (DynamicObject cooper : cooPerontx) {
                        DynamicObject newcooper = new DynamicObject(cooPersonDT);
                        newcooper.set("pkid", (Object)orm.genLongId((IDataEntityType)cooPersonDT));
                        newcooper.set("fbasedataid", cooper.get("fbasedataid"));
                        newcooper.set("fbasedataid_id", cooper.get("fbasedataid_id"));
                        cooPersons.add((Object)newcooper);
                    }
                    DynamicObjectCollection cooDepts = new DynamicObjectCollection();
                    DynamicObjectType cooDeptDT = cooDepttx.getDynamicObjectType();
                    for (DynamicObject coodept : cooDepttx) {
                        DynamicObject newcoodept = new DynamicObject(cooDeptDT);
                        newcoodept.set("pkid", (Object)orm.genLongId((IDataEntityType)cooDeptDT));
                        newcoodept.set("fbasedataid", coodept.get("fbasedataid"));
                        newcoodept.set("fbasedataid_id", coodept.get("fbasedataid_id"));
                        cooDepts.add((Object)newcoodept);
                    }
                    relationTask.set("multicooperationperson", (Object)cooPersons);
                    relationTask.set("multicooperationdept", (Object)cooDepts);
                } else {
                    relationTask.set("multicooperationperson", null);
                    relationTask.set("multicooperationdept", null);
                }
                relationTasks.add(relationTask);
                if (assocTasks.length <= 0) continue;
                for (DynamicObject assocTask : assocTasks) {
                    assocTask.set("responsibleperson", (Object)task.getDynamicObject("respersontx").getPkValue().toString());
                    assocTask.set("responsibledept", (Object)task.getDynamicObject("resdepttx").getPkValue().toString());
                    if (null != cooPerontx && cooPerontx.size() > 0) {
                        DynamicObjectCollection cooPersons = new DynamicObjectCollection();
                        DynamicObjectType cooPersonDT = cooPerontx.getDynamicObjectType();
                        for (DynamicObject cooper : cooPerontx) {
                            DynamicObject newcooper = new DynamicObject(cooPersonDT);
                            newcooper.set("pkid", (Object)orm.genLongId((IDataEntityType)cooPersonDT));
                            newcooper.set("fbasedataid", cooper.get("fbasedataid"));
                            newcooper.set("fbasedataid_id", cooper.get("fbasedataid_id"));
                            cooPersons.add((Object)newcooper);
                        }
                        DynamicObjectCollection cooDepts = new DynamicObjectCollection();
                        DynamicObjectType cooDeptDT = cooDepttx.getDynamicObjectType();
                        for (DynamicObject coodept : cooDepttx) {
                            DynamicObject newcoodept = new DynamicObject(cooDeptDT);
                            newcoodept.set("pkid", (Object)orm.genLongId((IDataEntityType)cooDeptDT));
                            newcoodept.set("fbasedataid", coodept.get("fbasedataid"));
                            newcoodept.set("fbasedataid_id", coodept.get("fbasedataid_id"));
                            cooDepts.add((Object)newcoodept);
                        }
                        assocTask.set("multicooperationperson", (Object)cooPersons);
                        assocTask.set("multicooperationdept", (Object)cooDepts);
                    } else {
                        assocTask.set("multicooperationperson", null);
                        assocTask.set("multicooperationdept", null);
                    }
                    associatedTasks.add(assocTask);
                }
            }
            if (relationTasks.size() != 0) {
                SaveServiceHelper.save((DynamicObject[])relationTasks.toArray(new DynamicObject[relationTasks.size()]));
                if (associatedTasks.size() != 0) {
                    SaveServiceHelper.save((DynamicObject[])associatedTasks.toArray(new DynamicObject[associatedTasks.size()]));
                }
            }
            if (personTasksList.size() == 0) continue;
            SaveServiceHelper.save((DynamicObject[])personTasksList.toArray(new DynamicObject[personTasksList.size()]));
        }
    }

    protected void checkExistResultDocs(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            this.checkExistResultDoc(bill);
        }
    }

    protected void checkExistResultDoc(DynamicObject bill) {
        DynamicObjectCollection tasks = bill.getDynamicObjectCollection("taskentity");
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            DynamicObjectCollection resultDocCollection;
            if (!this.isAchievementNode((DynamicObject)tasks.get(i)) || !CollectionUtils.isEmpty((Collection)(resultDocCollection = ((DynamicObject)tasks.get(i)).getDynamicObjectCollection("taskresultdocentry")))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f53\u524d\u8ba1\u5212\u7b2c%s\u884c\uff1a\u201c\u6210\u679c\u660e\u7ec6\u201d\u3002", (String)"DeptPlanOp_6", (String)"pccs-placs-opplugin", (Object[])new Object[0]), i + 1);
            throw new KDBizException(msg);
        }
    }

    protected boolean isAchievementNode(DynamicObject task) {
        boolean achievementNode = false;
        DynamicObjectCollection transactionTypeList = task.getDynamicObjectCollection("transactiontype");
        for (DynamicObject txType : transactionTypeList) {
            if (txType == null || txType.getDynamicObject(1) == null || !Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.getDynamicObject(1).getString("number"))) continue;
            achievementNode = true;
            break;
        }
        return achievementNode;
    }
}

