/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.placs.opplugin;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;

public class DeptPlanValidator
extends AbstractValidator {
    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            this.submitValidate();
        }
    }

    protected void submitValidate() {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity dataEntity : entities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = bill.getDynamicObjectCollection("taskentity");
            if (entryEntities.size() <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5206\u5f55\u4e2d\u7f3a\u5c11\u4efb\u52a1\u884c\uff0c\u8bf7\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"DeptPlanValidator_5", (String)"pccs-placs-opplugin", (Object[])new Object[0]), bill.get("name").toString()));
            }
            this.verifyTaskDate(bill);
            Date planStartTime = bill.getDate("STARTTIME");
            Date planEndTime = bill.getDate("ENDTIME");
            int index = 1;
            for (DynamicObject entry : entryEntities) {
                if (entry.getDynamicObject("relationtask") != null) {
                    ++index;
                    continue;
                }
                boolean isPlanTimeIncludeTaskTime = false;
                Date taskStartTime = entry.getDate("taskstarttimetx");
                Date taskEndTime = entry.getDate("taskendtimetx");
                if (null != planStartTime && null != planEndTime && null != taskStartTime && null != taskEndTime) {
                    if (taskStartTime.equals(planStartTime) && taskEndTime.equals(planEndTime)) {
                        isPlanTimeIncludeTaskTime = true;
                    }
                    if (!taskEndTime.before(planStartTime) && !taskStartTime.after(planEndTime)) {
                        isPlanTimeIncludeTaskTime = true;
                    }
                } else {
                    isPlanTimeIncludeTaskTime = true;
                }
                if (!isPlanTimeIncludeTaskTime) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u6e05\u5355\u201d\u7b2c%s\u884c\uff1a\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u4e0e\u90e8\u95e8\u8ba1\u5212\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u4efb\u52a1\u7684\u65f6\u95f4\u8de8\u5ea6\u3002", (String)"DeptPlanValidator_6", (String)"pccs-placs-opplugin", (Object[])new Object[0]), index);
                    this.addErrorMessage(dataEntity, msg);
                }
                ++index;
            }
        }
    }

    protected void verifyTaskDate(DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("taskentity");
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject task : entries) {
            Date beginDate;
            DynamicObject parentTask;
            map.put(task.getPkValue().toString(), task);
            String taskPid = task.get("pid").toString();
            if (taskPid != null && !"0".equals(taskPid) && (parentTask = (DynamicObject)map.get(taskPid)) != null) {
                Date parentEndDate;
                Date parentBeginDate;
                beginDate = task.getDate("taskstarttimetx");
                if (beginDate.compareTo(parentBeginDate = parentTask.getDate("taskstarttimetx")) < 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanValidator_7", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("tasknametx"));
                    throw new KDBizException(msg);
                }
                Date endDate = task.getDate("taskendtimetx");
                if (endDate.compareTo(parentEndDate = parentTask.getDate("taskendtimetx")) > 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanValidator_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("tasknametx"));
                    throw new KDBizException(msg);
                }
            }
            if (task == null) continue;
            Date endDate = task.getDate("taskendtimetx");
            beginDate = task.getDate("taskstarttimetx");
            if (endDate == null || beginDate == null || endDate.compareTo(beginDate) >= 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u4e3a%s\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u8be5\u4efb\u52a1\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"DeptPlanValidator_8", (String)"pccs-placs-opplugin", (Object[])new Object[0]), task.getString("tasknametx"));
            throw new KDBizException(msg);
        }
    }
}

